/*	OASYS source code for Escape from Planet Delta
	by Russell Wallace 31 Jan 1991
	See game introduction for details
*/

// Classes for abnormal objects

class room {}
class player {}
class button {{button}}
class door {{door} {lock} {padlock}}
class box {{box} {large box}}

// Classes for normal objects

class lamp {{lamp} {atomic lamp}}
class card {{card} {credit card} {american express card}
	{american express credit card}}
class torch {{torch}}
class herring {{herring} {red herring} {fish}}
class safe {{safe} {large safe}}
class detonator {{detonator}}
class plastic_key {{plastic key}}
class metal_key {{metal key}}
class ceramic_key {{ceramic key}}
class suit {{suit} {space suit}}
class explosive {{explosive} {plastic explosive}}
class mask {{mask} {gas mask}}
class whisky {{whiskey} {whisky}}
class disk {{disk} {floppy disk}}
class drive {{drive} {disk drive}}
class book {{book}}
class computer {{computer}}
class socket {{socket}}
class ladder {{ladder}}
class scrap {{scrap} {scrap metal}}
class paper {{paper} {sheet}}
class pan {{pan} {saucepan}}
class shovel {{shovel} {spade}}
class bottle {{bottle}}
class rubble {{rubble}}
class desk {{desk}}
class tiger {{tiger}}

// Miscellaneous global variables

int drunk				// State of drunkenness of player
int desk_moved
int pan_moved
int describe_mode		// When to give full location descriptions
string null_string		// Always left equal to *NULL STRING*
int drive_connected		// Is disk drive connected to computer
int computer_connected	// Is computer connected to comms socket
int hangar_vacuum		// Is hangar in vacuum
int tiger_moved

// Global variables for objects

object lamp
object card
object torch
object herring
object safe
object detonator
object plastic_key
object metal_key
object ceramic_key
object suit
object explosive
object mask
object whisky
object disk
object drive
object book
object computer
object socket
object ladder
object scrap
object paper
object pan
object shovel
object bottle
object rubble
object desk
object tiger

// Global variables for locations -- all will be of class room

object control_room
object corridor1
object corridor2
object corridor3
object office1
object office2
object lift_top
object corridor4
object bar
object kitchen
object cargo_hold
object lift_centre
object explosive_store
object corridor5
object corridor6
object chemical_store
object corridor7
object corridor8
object storage_compartment
object corridor9
object locker
object corridor10
object corridor11
object corridor12
object fridge
object equipment_store
object lift_bottom
object airlock
object crater
object cave_entrance
object cave1
object maze1
object maze2
object maze3
object maze4
object maze5
object maze6
object tunnel1
object tunnel2
object canyon_centre
object canyon_south
object cave2
object canyon_north
object canyon_teleport
object hangar_teleport
object hangar
object corridor19
object computer_room
object airlock2
object corridor13
object corridor14
object corridor15
object corridor16
object corridor17
object corridor18
object control_room2

// Object properties

property object in				// where is the object
property int is_open
property int is_worn
property object n				// what locations are reached by going in the 8
property object s				// directions of the compass + up and down
property object e
property object w
property object ne
property object nw
property object se
property object sw
property object up
property object down
property int moved				// has the object been moved yet
property string short_desc
property string word_desc		// one-word name for the object
property string long_desc
property string examine_desc	// text you get when you EXAMINE the object
property object door			// for locations -- the door if any
property int direction			// for doors -- which direction are they in
property int weight
property int is_on				// is the object turned on
property int is_dark			// for locations -- is it dark
property int is_vacuum			// for locations -- is it in vacuum

method int is_carried
"You haven't got that.\n"
{
	return this in == player and not this is_worn
}

method int is_visible
"I don't see that here.\n"
{
	if this in == player or this in == player in
		return 1
	if not this in exists
		return 0
			// object is visible if its container is visible and its container
			// is open
	return (this in is_open) and (this in is_visible)
}

// Selector method for METHOD GET -- like is_visible except that something
// being carried is not gettable

method int is_gettable
"It isn't there to take.\n"
{
	if this in == player in or (this in == player and this is_worn)
		return 1
	if not this in exists
		return 0
	return (this in is_open) and (this in is_visible)
}

method tiger_death
{
	print "The tiger leaps at you, knocks you to the ground, breaks your "
		"neck, rips you apart and eats you. If it's any consolation, it finds "
		"the meat among the least tasty it's eaten in a very long time.\n"
	exit
}

// Method for doing background stuff like checking for death from vacuum etc.
// Gets called by other methods after they've finished doing their bit.

method go
{
	if tiger_moved and tiger is_visible
		this tiger_death
	if tiger is_visible
		tiger_moved = 1
	if this in is_vacuum and not suit is_worn
	{
		print "You've always wondered why people seem to go to all the "
			"trouble of putting on space suits before exposing themselves to "
			"vacuum. Suddenly all is revealed. It's to prevent themselves "
			"dying from explosive decompression. You realize this because you "
			"are yourself dying from precisely this cause, having entered "
			"vacuum without a space suit. On the whole, it probably wasn't "
			"something that was worth dying to find out but there you are.\n"
		exit
	}
	if this in is_dark and not (lamp is_visible and lamp is_on)
	{
		print "It's dark here underground without a source of light. Pitch "
			"dark. You can't see where you're going and you stumble and gash "
			"your space suit on a sharp rock. You die a messy and unpleasant "
			"death.\n"
		exit
	}
	if drunk
	{
		if drunk == 1
			print "You are slightly drunk.\n"
		if drunk == 2
			print "You are reasonably drunk.\n"
		if drunk == 3
			print "You are fairly drunk.\n"
		if drunk == 4
			print "You are very drunk.\n"
		if drunk == 5
			print "You are extremely drunk.\n"
		drunk = drunk - 1
	}
}

method list_contents
{
	object o
	int how_many

	if not this is_open
		return
	o = object 1
	do
	{
		if o in == this and o moved
			how_many = how_many + 1
		o = o next
	}
	while o exists
	if how_many == 0
		return
	print "The "
	print this word_desc
	print " contains "
	o = object 1
	do
	{
		if o in == this and o moved
		{
			print o short_desc
			how_many = how_many - 1
			if how_many
			{
				if how_many == 1
					print " and "
				else
					print ", "
			}
			else
				print ".\n"
		}
		o = o next
	}
	while o exists
	o = object 1
	do
	{
		if o in == this
			o list_contents
		o = o next
	}
	while o exists
}

method int list_objects string initial_message
{
	object o
	int how_many

	o = object 1
	do
	{
		if o in == this and o moved
			how_many = how_many + 1
		o = o next
	}
	while o exists
	if how_many == 0
		return 0
	print initial_message
	o = object 1
	do
	{
		if o in == this and o moved
		{
			print o short_desc
			how_many = how_many - 1
			if how_many
			{
				if how_many == 1
					print " and "
				else
					print ", "
			}
			else
				print ".\n"
		}
		o = o next
	}
	while o exists
	o = object 1
	do
	{
		if o in == this and o moved
			o list_contents
		o = o next
	}
	while o exists
	return 1
}

// Method to describe current location to player -- the verbose_description
// flag is used to indicate whether the full description should always be given

method describe_location int verbose_description
{
	object l
	object o
	int i

	l = this in
	print l short_desc
	print "\n"
	if verbose_description or
		(describe_mode != -1 and (describe_mode == 1 or not l moved))
	{
		l moved = 1
		print l long_desc
		print "\n"
	}
	if l == hangar
		if hangar_vacuum
			print "The roof is open.\n"
		else
			print "The roof is closed.\n"
	o = object 1
	do
	{
		if o in == l and not o moved and not o is player
		{
			print o long_desc
			print "\n"
			o list_contents
		}
		o = o next
	}
	while o exists
	i = l list_objects "You can also see "
}

method look verbs {{l} {look}}
{
	this describe_location 1
}

method go_north verbs {{n} {north} {go north}}
{
	if this in == corridor10
	{
		if not drunk
		{
			print "You walk into the field. Suddenly you find that the "
				"corridor starts spinning around you. Finally it stops "
				"spinning and you find yourself facing back the way you "
				"came.\n"
			this go
			return
		}
		print "You lurch into the field. Suddenly you find that the corridor's "
			"angular velocity increases dramatically. Finally it stops "
			"spinning. Much to your surprise you find that it seems you've "
			"actually got where you were going.\n"
		this in = corridor11
		this describe_location 0
		this go
		return
	}
	if not this in n exists
	{
		print "You can't go that way.\n"
		return
	}
	if this in door exists
		if this in door direction == 1 and not this in door is_open
		{
			print "You can't go through a locked door.\n"
			return
		}
	this in = this in n
	this describe_location 0
	this go
}

method go_south verbs {{s} {south} {go south}}
{
	if not this in s exists
	{
		print "You can't go that way.\n"
		return
	}
	if this in door exists
		if this in door direction == 2 and not this in door is_open
		{
			print "You can't go through a locked door.\n"
			return
		}
	this in = this in s
	this describe_location 0
	this go
}

method go_east verbs {{e} {east} {go east}}
{
	if not this in e exists
	{
		print "You can't go that way.\n"
		return
	}
	if tiger is_visible
		this tiger_death
	if this in door exists
		if this in door direction == 3 and not this in door is_open
		{
			print "You can't go through a locked door.\n"
			return
		}
	this in = this in e
	this describe_location 0
	this go
}

method go_west verbs {{w} {west} {go west}}
{
	if not this in w exists
	{
		print "You can't go that way.\n"
		return
	}
	if tiger is_visible
		this tiger_death
	if this in door exists
		if this in door direction == 4 and not this in door is_open
		{
			print "You can't go through a locked door.\n"
			return
		}
	this in = this in w
	this describe_location 0
	this go
}

method go_northeast verbs {{ne} {northeast} {go northeast}}
{
	if not this in ne exists
	{
		print "You can't go that way.\n"
		return
	}
	this in = this in ne
	this describe_location 0
	this go
}

method go_northwest verbs {{nw} {northwest} {go northwest}}
{
	if not this in nw exists
	{
		print "You can't go that way.\n"
		return
	}
	this in = this in nw
	this describe_location 0
	this go
}

method go_southeast verbs {{se} {southeast} {go southeast}}
{
	if not this in se exists
	{
		print "You can't go that way.\n"
		return
	}
	this in = this in se
	this describe_location 0
	this go
}

method go_southwest verbs {{sw} {southwest} {go southwest}}
{
	if not this in sw exists
	{
		print "You can't go that way.\n"
		return
	}
	this in = this in sw
	this describe_location 0
	this go
}

method go_up verbs {{u} {up} {go up}}
{
	if this in == hangar
	{
		if not ladder is_gettable
		{
			print "The airlock is too high up for you to reach.\n"
			return
		}
		this in = airlock2
		this describe_location 0
		this go
		return
	}
	if not this in up exists
	{
		print "You can't go that way.\n"
		return
	}
	if this in door exists
		if this in door direction == 9 and not this in door is_open
		{
			print "You can't go through a locked door.\n"
			return
		}
	this in = this in up
	this describe_location 0
	this go
}

method go_down verbs {{d} {down} {go down}}
{
	if not this in down exists
	{
		print "You can't go that way.\n"
		return
	}
	if this in door exists
		if this in door direction == 10 and not this in door is_open
		{
			print "You can't go through a locked door.\n"
			return
		}
	this in = this in down
	this describe_location 0
	this go
}

// Method to calculate total weight of object, which is object's own weight
// plus weight of all objects inside it and inside those etc.

method int total_weight
{
	object o
	int result

	result = this weight
	o = object 1
	do
	{
		if o in == this
			result = result + o total_weight
		o = o next
	}
	while o exists
	return result
}

method get object x is_gettable
	verbs {{get x} {take x} {pick up x} {pick x up} {remove x} {take off x}
		{take x off}}
{
	if x is_worn
	{
		print "Removed.\n"
		x is_worn = 0
		return
	}
	if x weight == 9999 or x is whisky
	{
		print "You can't take that.\n"
		return
	}
	if this total_weight + x total_weight > 3000
	{
		print "You're carrying too much already.\n"
		return
	}
	if (x is drive or x is computer) and drive_connected
	{
		drive_connected = 0
		if computer is_on
		{
			print "(You turn off the computer.)\n"
			computer is_on = 0
		}
		print "(You disconnect the disk drive.)\n"
	}
	if (x is computer) and computer_connected
	{
		computer_connected = 0
		if computer is_on
		{
			print "(You turn off the computer.)\n"
			computer is_on = 0
		}
		print "(You disconnect the computer.)\n"
	}
	x in = this
	x moved = 1
	print "Taken.\n"
	if x is pan and not pan_moved
	{
		pan_moved = 1
		print "Underneath the pan you uncover a metal key.\n"
		metal_key in = this in
	}
	this go
}

method drop object x is_carried verbs {{drop x} {put down x} {put x down}}
{
	x in = this in
	x is_worn = 0
	print "Dropped.\n"
	this go
}

method put_in object x is_carried object y is_visible
	verbs {{put x in y} {put x into y}}
{
	if x == y
	{
		print "You can't put something into itself!\n"
		return
	}
	if y is socket or y is computer
	{
		print "Try CONNECT (object) TO (object).\n"
		return
	}
	if not y is box and not y is safe and not y is drive
	{
		print "You can't put things in that.\n"
		return
	}
	if not y is_open
	{
		print "It isn't open.\n"
		return
	}
	if y is drive
	{
		if not x is disk
		{
			print "You can only put floppy disks in a floppy disk drive.\n"
			return
		}
		x in = y
		print "OK, you put the disk into the disk drive.\n"
		this go
		return
	}
	print "OK.\n"
	x in = y
	x is_worn = 0
	this go
}

method quit verbs {{quit}}
{
	quit
}

method inventory verbs {{i} {inv} {inventory}}
{
	if not this list_objects "You are carrying "
		print "You are emptyhanded.\n"
}

method save verbs {{save}}
{
	save
}

method load verbs {{load} {restore}}
{
	if load
	{
		this describe_location 0
		this inventory
	}
}

method examine object x is_visible
 	verbs {{examine x} {look at x} {search x} {read x} {look under x}
		{search under x}}
{
	if x examine_desc != null_string
	{
		print x examine_desc
		print "\n"
	}
	if x is door
	{
		if x is_open
			print "The door is unlocked.\n"
		else
			print "The door is locked.\n"
	}
	if x is box
	{
		if x is_open
			print "The box is open.\n"
		else
			print "The box is closed.\n"
	}
	if x is desk and not desk_moved
	{
		desk_moved = 1
		print "Underneath the desk you uncover a plastic key.\n"
		plastic_key in = this in
		this go
	}
	if x is pan and not pan_moved
	{
		pan_moved = 1
		print "Underneath the pan you uncover a metal key.\n"
		metal_key in = this in
		this go
	}
	if x is safe
	{
		if x is_open
			print "The safe is open.\n"
		else
			print "The safe is shut.\n"
	}
	if (x is socket and computer_connected) or (x is drive and drive_connected)
		print "It's connected to the computer.\n"
	if x is computer and drive_connected and not computer_connected
		print "It's connected to the disk drive.\n"
	if x is computer and computer_connected and not drive_connected
		print "It's connected to the communications socket.\n"
	if x is computer and computer_connected and drive_connected
		print "It's connected to the disk drive and the communications socket.\n"
	if x is_on
		print "It's switched on.\n"
	if (x is lamp or x is computer) and not x is_on
		print "It's switched off.\n"
	x list_contents
}

method wear object x is_carried verbs {{wear x} {put on x} {put x on}}
{
	if not x is mask and not x is suit
	{
		print "You can't wear that!\n"
		return
	}
	if x is_worn
	{
		print "You're already wearing it.\n"
		return
	}
	print "OK.\n"
	x is_worn = 1
	this go
}

method press object x is_visible
	verbs {{press x} {push x} {move x} {shove x} {slide x}}
{
	if x is button
	{
		print "Your surroundings seem to shift slightly.\n"
		if this in == hangar_teleport
			this in = canyon_teleport
		else
			this in = hangar_teleport
		this describe_location 0
		this go
		return
	}
	if x is desk and not desk_moved
	{
		desk_moved = 1
		print "Underneath the desk you uncover a plastic key.\n"
		plastic_key in = this in
		this go
		return
	}
	if x is pan and not pan_moved
	{
		pan_moved = 1
		print "Underneath the pan you uncover a metal key.\n"
		metal_key in = this in
		this go
		return
	}
	print "Nothing happens.\n"
	this go
}

method use object x is_visible verbs {{use x}}
{
	if x == lamp
	{
		print "Try TURN ON LAMP.\n"
		return
	}
	if x == torch
	{
		print "Try BURN (object) WITH TORCH.\n"
		return
	}
	if x == detonator or x == explosive
	{
		print "Get the explosive and the detonator and type BLOW UP "
			"(object).\n"
		return
	}
	if x == plastic_key or x == metal_key or x == ceramic_key
	{
		print "Open things with it.\n"
		return
	}
	if x == suit
	{
		print "PUT ON SUIT and you can then go into vacuum.\n"
		return
	}
	if x == mask
	{
		print "PUT ON MASK to protect yourself from toxic gases.\n"
		return
	}
	if x == whisky
	{
		print "Well, what do people usually do with whisky??\n"
		return
	}
	if x == disk
	{
		print "You'll have to put it into a disk drive, then turn on "
			"the computer.\n"
		return
	}
	if x == drive
	{
		print "You'll have to connect it to a computer then turn on "
			"the computer.\n"
		return
	}
	if x == computer
	{
		print "Connect up all the required peripherals then TURN ON "
			"COMPUTER. The power supply is built in, as is the screen.\n"
		return
	}
	if x == socket
	{
		print "You connect a computer to it to obtain communications "
			"facilities.\n"
		return
	}
	if x == ladder
	{
		print "When in an appropriate place, PUT DOWN LADDER and then "
			"GO UP.\n"
		return
	}
	if x == shovel
	{
		print "Have the shovel to hand and type DIG in the appropriate "
			"circumstances.\n"
		return
	}
	print "Sorry, but you'll have to use some other verb.\n"
}

method open object x is_visible verbs {{open x} {unlock x}}
{
	object o

	if not x is box and not x is door and not x is safe
	{
		print "You can't open that.\n"
		return
	}
	if x is_open
	{
		print "It's already open.\n"
		return
	}
	if x is box
	{
		x is_open = 1
		x moved = 1
		o = object 1
		do
		{
			if o in == x and o is box
			{
				print "You open the box and remove another, smaller box.\n"
				o in = this in
				this go
				return
			}
			o = o next
		}
		while o exists
		print "You open the box and remove an American Express credit card and "
			"an oxy-acetylene torch.\n"
		card in = this in
		torch in = this in
		this go
		return
	}
	if x is door and (this in == airlock or this in == crater)
	{
		print "You'll have to type in the access code to open the door - try "
			"TYPE (code).\n"
		return
	}
	print "You'll have to tell me what you want to open it with.\n"
}

method do_open_door
{
	this door is_open = 1
	this door long_desc = "The door is unlocked."
}

method open_door
{
	int dir

	this do_open_door
	dir = this door direction
	if dir == 1
		this n do_open_door
	if dir == 2
		this s do_open_door
	if dir == 3
		this e do_open_door
	if dir == 4
		this w do_open_door
	if dir == 9
		this up do_open_door
	if dir == 10
		this down do_open_door
}

method open_with object x is_visible object y is_carried
	verbs {{open x with y} {unlock x with y}}
{
	object l

	if not x is box and not x is door and not x is safe
	{
		print "You can't open that.\n"
		return
	}
	if x is_open
	{
		print "It's already open.\n"
		return
	}
	if x is box
	{
		this open x
		return
	}
	if x is door and (this in == airlock or this in == crater)
	{
		print "You'll have to type in the access code to open the door - try "
			"TYPE (code).\n"
		return
	}
	if x is safe
	{
		if y is metal_key
		{
			print "You open the safe.\n"
			safe is_open = 1
			safe list_contents
			this go
			return
		}
		print "That won't open the safe.\n"
		return
	}
	l = this in
	if l == control_room or l == corridor1 or l == corridor3 or l == office2
	{
		if y is card
		{
			print "You manage to unlock the door with the credit card.\n"
			this in open_door
			this go
			return
		}
		print "That won't unlock the door.\n"
		this go
		return
	}
	if l == explosive_store or l == chemical_store or l == corridor5 or
		l == corridor6
	{
		if y is ceramic_key
		{
			print "You unlock the door.\n"
			this in open_door
			this go
			return
		}
		print "That won't unlock the door.\n"
		this go
		return
	}
	if l == canyon_north or l == canyon_teleport
	{
		if y is metal_key
		{
			print "You unlock the door.\n"
			this in open_door
			this go
			return
		}
		print "That won't unlock the door.\n"
		this go
		return
	}
	if l == corridor8 or l == storage_compartment or l == corridor17 or
		l == control_room2
	{
		if y is plastic_key
		{
			print "You unlock the door.\n"
			this in open_door
			this go
			return
		}
	}
	print "That won't unlock the door.\n"
	this go
	return
}

method do_close_door
{
	this door is_open = 0
	this door long_desc = "The door is locked.\n"
}

method close_door
{
	int dir

	this do_close_door
	dir = this door direction
	if dir == 1
		this n do_close_door
	if dir == 2
		this s do_close_door
	if dir == 3
		this e do_close_door
	if dir == 4
		this w do_close_door
	if dir == 9
		this up do_close_door
	if dir == 10
		this down do_close_door
}

method close object x is_visible verbs {{close x} {shut x} {lock x}}
{
	if x is box
	{
		print "These are disposable cardboard boxes, you can't close them "
			"again.\n"		// We're being lazy here!
		return
	}
	if not x is door and not x is safe
	{
		print "You can't close that.\n"
		return
	}
	if not x is_open
	{
		print "It isn't open.\n"
		return
	}
	if x is safe
	{
		print "The safe door slams shut.\n"
		x is_open = 0
		this go
		return
	}
	if this in == corridor9 or this in == locker
	{
		print "The lock on the door doesn't work anymore.\n"
		this go
		return
	}
	print "You lock the door.\n"
	this in close_door
	this go
}

method close_with object x is_visible object y is_carried
	verbs {{close x with y} {shut x with y} {lock x with y}}
{
	this close x
}

method help verbs {{help}}
{
	print "Wise up man, nobody except Infocom has given online help in an "
		"adventure game since the early eighties and Infocom only did "
		"it cause they had loads of money to spend on development. "
		"Contact the author if you're really stuck, or of course you "
		"can always look at the source code. (OK, if you're really "
		"stuck for a phrase, try USE (object), it might point you "
		"in the right direction).\n"
}

method give object x is_carried verbs {{give x} {show x} {offer x}}
{
	print "You'll have to tell me what you want to give it to.\n"
}

method give_to object x is_carried object y is_visible
	verbs {{give x to y} {show x to y} {offer x to y}
		{give y x} {show y x} {offer y x}}
{
	if not y is tiger or not x is herring
	{
		print "It doesn't seem to want the "
		print x word_desc
		print ".\n"
		this go
		return
	}
	print "You toss the herring on the floor in front of the tiger. The tiger "
		"sniffs suspiciously at the fish, then grabs it and gobbles it down. "
		"It licks its lips and yawns as if to say, \"Thanks for the appetizer!\" "
		"and steps towards you. Suddenly it stops and starts gagging. It curls "
		"up into a ball, foams at the mouth and dies. Ideas for blackmailing "
		"the cook start flooding into your mind.\n"
	destroy herring
	destroy tiger
	this go
}

method eat object x is_carried verbs {{eat x}}
{
	if not x is herring
	{
		print "It doesn't look very edible to me.\n"
		return
	}
	print "OK, you eat the herring. It tastes totally horrible. Suddenly you "
		"get a terrible pain in your stomach. You start throwing up. Now you "
		"can't breathe. The last thought that flashes through your mind is "
		"how much money you could sue the cook for.\n"
	exit
}

method feed object x is_visible verbs {{feed x}}
{
	if not x is tiger
	{
		print "It doesn't look very hungry to me.\n"
		return
	}
	if not herring is_carried
	{
		print "You have nothing edible.\n"
		return
	}
	this give_to herring tiger
}

method connect_to object x is_visible object y is_visible
	verbs {{connect x to y} {plug x into y} {connect x and y} {connect x with y}}
{
	if not (x is drive and y is computer) and not (x is computer and y is drive)
		and not (x is socket and y is computer) and
		not (x is computer and y is socket)
	{
		print "You can't connect those things.\n"
		return
	}
	if x in != this in or y in != this in
	{
		print "You'll have to put it down first.\n"
		return
	}
	if x is drive or y is drive
	{
		if drive_connected
		{
			print "The disk drive is already plugged into the computer.\n"
			return
		}
		drive_connected = 1
		print "OK, you plug the disk drive into the computer.\n"
		this go
		return
	}
	if computer_connected
	{
		print "The computer is already plugged into the socket.\n"
		return
	}
	computer_connected = 1
	print "OK, you plug the computer into the socket.\n"
	this go
}

method connect object x is_visible verbs {{connect x} {plug x in} {plug in x}}
{
	print "You'll have to tell me what you want to connect it to.\n"
}

method disconnect_computer
{
	if not computer_connected
	{
		print "The computer isn't connected to a communications socket.\n"
		return
	}
	computer_connected = 0
	if computer is_on
	{
		print "(You turn off the computer.)\n"
		computer is_on = 0
	}
	print "OK, you disconnect the computer from the communications socket.\n"
	this go
}

method disconnect_drive
{
	if not drive_connected
	{
		print "The disk drive isn't connected to anything.\n"
		return
	}
	drive_connected = 0
	if computer is_on
	{
		print "(You turn off the computer.)\n"
		computer is_on = 0
	}
	print "OK, you disconnect the disk drive from the computer.\n"
	this go
}

method disconnect object x is_visible verbs {{disconnect x} {unplug x}}
{
	if not x is computer and not x is drive and not x is socket
	{
		print "That isn't connected to anything.\n"
		return
	}
	if x is socket
		this disconnect_computer
	if x is drive
		this disconnect_drive
	if x is computer
	{
		if drive_connected
		{
			this disconnect_drive
			return
		}
		if computer_connected
		{
			this disconnect_computer
			return
		}
		print "The computer isn't connected to anything.\n"
	}
}

method disconnect_from object x is_visible object y is_visible
	verbs {{disconnect x from y} {disconnect x and y} {unplug x from y}}
{
	if ((x is drive and y is computer) or (x is computer and y is drive))
		and drive_connected
	{
		this disconnect_drive
		return
	}
	if ((x is socket and y is computer) or (x is computer and y is socket))
		and computer_connected
	{
		this disconnect_computer
		return
	}
	print "Those things aren't connected.\n"
}

method drink object x is_visible verbs {{drink x}}
{
	if not x is whisky
	{
		print "You can't drink that.\n"
		return
	}
	destroy x
	print "Glug ... glug ... glug ... hic!\n"
	drunk = 5
	this go
}

method brief verbs {{brief}}
{
	print "Brief descriptions only.\n"
	describe_mode = -1
}

method verbose verbs {{verbose}}
{
	print "Verbose descriptions.\n"
	describe_mode = 1
}

method normal verbs {{normal}}
{
	print "Normal descriptions.\n"
	describe_mode = 0
}

method turn_on object x is_visible
	verbs {{turn on x} {turn x on} {light x} {switch x on} {switch on x}}
{
	if x is_on
	{
		print "It's already on.\n"
		return
	}
	if not x is computer and not x is lamp
	{
		print "You can't turn that on.\n"
		return
	}
	if x is lamp
	{
		x is_on = 1
		print "You turn on the lamp. Light floods the area.\n"
		this go
		return
	}
	if not drive_connected
	{
		print "You press the ON button on the computer. The screen lights "
			"up and the machine beeps apologetically at you. The following "
			"message appears on the screen:\n\n"
			"HARDWARE ERROR - MASS STORAGE ACCESS FAILURE. SYSTEM HALTED.\n\n"
			"The computer switches itself off again.\n"
		this go
		return
	}
	if disk in != drive
	{
		print "You press the ON button on the computer. The screen lights up, "
			"the disk drive activates for a moment and the machine beeps "
			"apologetically at you. The following message appears on the "
			"screen:\n\n"
			"ERROR - INVALID BOOT DISK. SYSTEM HALTED.\n\n"
			"The computer switches itself off again.\n"
		this go
		return
	}
	if not computer_connected
	{
		print "You press the ON button on the computer. The screen lights up "
			"and the disk drive activates. Eventually the machine beeps "
			"apologetically at you. The following message appears on the "
			"screen:\n\n"
			"HARDWARE ERROR - COMMUNICATIONS PORT ACCESS FAILURE. "
			"SYSTEM HALTED.\n\n"
			"The computer switches itself off again.\n"
		this go
		return
	}
	if not hangar_vacuum
	{
		hangar_vacuum = 1
		print "You press the ON button on the computer. The screen lights up "
			"and the disk drive activates. Eventually the following appears "
			"on the screen:\n\n"
			"PROGRAM EXECUTING -- OPENING HANGAR DOOR.\n"
			"WARNING - AREA NOW IN VACUUM.\n\n"
			"You hear a distant whirring noise. All the air is suddenly "
			"sucked from the room.\n"
		hangar_teleport is_vacuum = 1
		hangar is_vacuum = 1
		corridor19 is_vacuum = 1
		computer_room is_vacuum = 1
		this go
		return
	}
	hangar_vacuum = 0
	print "You press the ON button on the computer. The screen lights up "
		"and the disk drive activates. Eventually the following appears "
		"on the screen:\n\n"
		"PROGRAM EXECUTING -- CLOSING HANGAR DOOR.\n\n"
		"You hear a distant whirring noise. The air suddenly rushes back into "
		"the room.\n"
	hangar_teleport is_vacuum = 0
	hangar is_vacuum = 0
	corridor19 is_vacuum = 0
	computer_room is_vacuum = 0
	this go
}

method turn_off object x is_visible
	verbs {{turn off x} {turn x off} {switch off x} {switch off x}}
{
	if not x is_on
	{
		print "It isn't turned on.\n"
		return
	}
	print "Click.\n"
	x is_on = 0
	this go
}

method kill		// Method to destroy an object plus all its contents
{
	object o
	object o2

	o = object 1
	do
	{
		o2 = o next
		if o in == this
			o kill
		o = o2
	}
	while o exists
	destroy this
}

// Method to destroy door in this location plus the corresponding door in the
// next location

method destroy_door
{
	int dir

	dir = this door direction
	destroy this door
	if dir == 1
		destroy this n door
	if dir == 2
		destroy this s door
	if dir == 3
		destroy this e door
	if dir == 4
		destroy this w door
	if dir == 9
		destroy this up door
	if dir == 10
		destroy this down door
}

method blow_up object x is_visible
	verbs {{blow up x} {blow x up} {demolish x}}
{
	if not explosive is_carried
	{
		print "You haven't got any explosive.\n"
		return
	}
	if not detonator is_carried
	{
		print "The plastic explosive can only be set off by a special "
			"detonator which you haven't got.\n"
		return
	}
	if x in != this in
	{
		print "You'll have to put it on the ground first.\n"
		return
	}
	print "You put the detonator and explosive together and retreat to a "
		"safe distance. There is a massive explosion. The "
	print x word_desc
	print " is now destroyed.\n"
	if x is explosive or x is detonator
	{
		explosive kill
		detonator kill
		this go
		return
	}
	explosive kill
	detonator kill
	if x == this in door
	{
		this in destroy_door
		if this in == airlock
			this in is_vacuum = 1
		this go
		return
	}
	if x is computer or x is drive
		drive_connected = 0
	x kill
	this go
}

method blow_up_with object x is_visible object y is_carried
	verbs {{blow up x with y} {blow x up with y} {demolish x with y}}
{
	if not y is explosive
	{
		print "You can't blow things up with that.\n"
		return
	}
	this blow_up x
}

method cut object x is_visible
	verbs {{cut x} {burn x} {melt x} {cut through x} {burn through x}}
{
	if not torch is_carried
	{
		print "You haven't got the required equipment.\n"
		return
	}
	if x is safe
	{
		print "The torch fails to make much impression on the safe.\n"
		this go
		return
	}
	if x is tiger
	{
		print "You attack the tiger with the torch. Unfortunately the torch "
			"contains a built-in safety device which causes it to shut off "
			"when pointed at an organic life form. This tends to slightly "
			"limit its usefulness as a weapon. You feel slightly embarrassed "
			"when you discover this as you point the torch at the tiger and "
			"nothing happens. You feel even more embarrassed when the tiger "
			"kills you.\n"
		exit
	}
	if x is rubble
	{
		print "The torch fails to make much impression on the rubble.\n"
		this go
		return
	}
	if not x is door
	{
		if x in != this in
		{
			print "You'll have to put it on the ground first.\n"
			return
		}
		print "OK, you destroy the "
		print x word_desc
		print ".\n"
		if x is computer or x is drive or x is socket
		{
			computer_connected = 0
			drive_connected = 0
		}
		x kill
		this go
		return
	}
	if (this in == corridor9 or this in == locker)
		if this in door is_open
		{
			print "The door here is already open.\n"
			return
		}
	if this in == corridor9
	{
		print "You melt the padlock with the torch. The door swings open.\n"
		this in open_door
		this go
		return
	}
	print "The torch fails to make much impression on the door.\n"
	this go
}

method cut_with object x is_visible object y is_carried
	verbs {{cut x with y} {burn x with y} {melt x with y} {cut through x with y}
	{burn through x with y}}
{
	if y is explosive
	{
		print "Try BLOW UP.\n"
		return
	}
	if not y is torch
	{
		print "You can't damage it with that.\n"
		return
	}
	this cut x
}

method dig verbs {{dig}}
{
	if not rubble is_visible
	{
		print "There's nothing here to dig.\n"
		return
	}
	if not shovel is_carried
	{
		print "You've nothing to dig with.\n"
		return
	}
	print "After a couple of hours of hard work, you dig away the rubble "
		"with the shovel.\n"
	destroy rubble
	tunnel1 e = tunnel2
	this go
}

method dig_x object x is_visible verbs {{dig x} {clear x}}
{
	print "Just use DIG.\n"
}

method dig_x_with object x is_visible object y is_carried
	verbs {{dig x with y} {clear x with y}}
{
	print "Just use DIG.\n"
}

method type int number verbs {{type number} {enter number} {key number}}
{
	if this in != airlock and this in != crater and this in != control_room2
	{
		print "There's nothing around here to type numbers on.\n"
		return
	}
	if this in == control_room2
	{
		if number != 3142
		{
			print "You hear a loud BEEP and a message flashes on the screen: "
				"INCORRECT AUTHORIZATION CODE.\n"
			this go
			return
		}
		if not hangar_vacuum
		{
			print "The engines start, the ship lifts from the ground and "
				"slams into the roof of the hangar. The structure "
				"crumples like a paper dart smashed into a wall. The nuclear "
				"reactor explodes, demolishing the hangar and burying the "
				"wreckage under thousands of tons of rubble.\n"
			exit
		}
		print "The engines start, the ship lifts from the ground and heads "
			"for the sky. At the required distance from the planet's gravity "
			"field the faster-than-light drive engages and you are on your "
			"way home. Well done.\n"
		exit		// Success!
	}
	if number != 7648
	{
		print "A sign flashes: \"INCORRECT ACCESS CODE\".\n"
		this go
		return
	}
	if this in door is_open
	{
		print "Nothing happens, on the grounds that the airlock door is "
			"already unlocked. (It can be locked manually, just type LOCK "
			"DOOR.)\n"
		this go
		return
	}
	print "The door is now unlocked.\n"
	this in open_door
	this go
}

method type_on int number object x is_visible
	verbs {{type number on x} {enter number on x} {key number on x}}
{
	print "Just use TYPE (code).\n"
}

method create_other_door int direction
{
	this door = create door
	this door direction = direction
	this door long_desc = "The door is locked."
	this door word_desc = "door"
	this door weight = 9999
	this door in = this
}

// Method to create a door in a location together with the corresponding door
// in the next location

method create_door int direction
{
	this create_other_door direction
	if direction == 1
		this n create_other_door 2
	if direction == 2
		this s create_other_door 1
	if direction == 3
		this e create_other_door 4
	if direction == 4
		this w create_other_door 3
	if direction == 9
		this up create_other_door 10
	if direction == 10
		this down create_other_door 9
}

method init
{
	object o
	object innerbox
	object box
	int i

	print
		"Escape from Planet Delta by Russell Wallace\n\n"

		"Originally written with The Quill on the Commodore 64 "
		"in the mid eighties and ported to OASYS in January 1991. This game "
		"is public domain and source and object code may be freely copied and "
		"used.\n\n"

		"The plot is as follows: You were on a starship flying to the planet "
		"Betelgeuse Delta, fourth planet of the Betelgeuse star system. On "
		"approaching the planet for landing, the ship developed engine "
		"trouble and appeared to be about to crash. Unfortunately there was "
		"not quite enough lifeboat space for everyone, so your shipmates beat "
		"you up, threw you into the control room, locked the door, grabbed "
		"the lifeboat, ejected and are probably on their way back to Earth by "
		"now. The ship crash landed but amazingly is still mostly intact and "
		"you survived the landing. However there is no chance of your being "
		"able to fly it out of here, so you will have to look for the "
		"Starfleet base on the planet and try to find some means of escape.\n\n"

		"Commands can be multiple words, but words like ALL, IT and AND are "
		"not supported. SAVE saves the game and LOAD reloads your position. "
		"VERBOSE, BRIEF and NORMAL give you different lengths of location "
		"descriptions.\n\n"

		"Good luck!\n\n"

	player = create player

			// Create all the normal objects

	lamp = create lamp
	card = create card
	torch = create torch
	herring = create herring
	safe = create safe
	detonator = create detonator
	plastic_key = create plastic_key
	metal_key = create metal_key
	ceramic_key = create ceramic_key
	suit = create suit
	explosive = create explosive
	mask = create mask
	whisky = create whisky
	disk = create disk
	drive = create drive
	book = create book
	computer = create computer
	socket = create socket
	ladder = create ladder
	scrap = create scrap
	paper = create paper
	pan = create pan
	shovel = create shovel
	bottle = create bottle
	rubble = create rubble
	desk = create desk
	tiger = create tiger

			// Create all the locations

	control_room = create room
	corridor1 = create room
	corridor2 = create room
	corridor3 = create room
	office1 = create room
	office2 = create room
	lift_top = create room
	corridor4 = create room
	bar = create room
	kitchen = create room
	cargo_hold = create room
	lift_centre = create room
	explosive_store = create room
	corridor5 = create room
	corridor6 = create room
	chemical_store = create room
	corridor7 = create room
	corridor8 = create room
	storage_compartment = create room
	corridor9 = create room
	locker = create room
	corridor10 = create room
	corridor11 = create room
	corridor12 = create room
	fridge = create room
	equipment_store = create room
	lift_bottom = create room
	airlock = create room
	crater = create room
	cave_entrance = create room
	cave1 = create room
	maze1 = create room
	maze2 = create room
	maze3 = create room
	maze4 = create room
	maze5 = create room
	maze6 = create room
	tunnel1 = create room
	tunnel2 = create room
	canyon_centre = create room
	canyon_south = create room
	cave2 = create room
	canyon_north = create room
	canyon_teleport = create room
	hangar_teleport = create room
	hangar = create room
	corridor19 = create room
	computer_room = create room
	airlock2 = create room
	corridor13 = create room
	corridor14 = create room
	corridor15 = create room
	corridor16 = create room
	corridor17 = create room
	corridor18 = create room
	control_room2 = create room

			// Assign exits from locations

	control_room e = corridor1
	corridor1 w = control_room
	corridor1 e = lift_top
	corridor1 ne = corridor2
	corridor2 n = office1
	corridor2 sw = corridor1
	corridor2 e = corridor3
	corridor3 w = corridor2
	corridor3 n = office2
	office1 s = corridor2
	office2 s = corridor3
	lift_top w = corridor1
	lift_top down = lift_centre
	corridor4 w = kitchen
	corridor4 e = lift_centre
	corridor4 se = bar
	corridor4 ne = cargo_hold
	bar nw = corridor4
	kitchen e = corridor4
	cargo_hold sw = corridor4
	lift_centre w = corridor4
	lift_centre up = lift_top
	lift_centre down = lift_bottom
	explosive_store e = corridor5
	corridor5 e = corridor6
	corridor5 w = explosive_store
	corridor6 w = corridor5
	corridor6 e = lift_bottom
	corridor6 ne = corridor7
	corridor6 n = chemical_store
	chemical_store s = corridor6
	corridor7 sw = corridor6
	corridor7 n = corridor10
	corridor7 se = corridor8
	corridor8 nw = corridor7
	corridor8 e = corridor9
	corridor8 n = storage_compartment
	storage_compartment s = corridor8
	corridor9 w = corridor8
	corridor9 s = airlock
	corridor9 e = locker
	locker w = corridor9
	corridor10 s = corridor7
	corridor11 s = corridor10
	corridor11 n = equipment_store
	corridor11 w = corridor12
	corridor12 e = corridor11
	corridor12 w = fridge
	fridge e = corridor12
	equipment_store s = corridor11
	lift_bottom w = corridor6
	lift_bottom up = lift_centre
	airlock n = corridor9
	airlock down = crater
	crater up = airlock
	crater e = cave_entrance
	cave_entrance w = crater
	cave_entrance se = cave1
	cave1 nw = cave_entrance
	cave1 e = maze1
	maze1 w = cave1
	maze1 s = maze2
	maze1 sw = maze1
	maze1 nw = maze1
	maze1 n = maze2
	maze1 ne = maze1
	maze1 e = maze1
	maze1 se = maze1
	maze2 se = maze3
	maze2 s = maze1
	maze2 sw = maze1
	maze2 w = maze2
	maze2 nw = maze2
	maze2 n = maze1
	maze2 ne = maze1
	maze2 e = maze2
	maze3 n = maze4
	maze3 ne = maze1
	maze3 e = maze2
	maze3 se = maze3
	maze3 s = maze2
	maze3 sw = maze2
	maze3 w = maze1
	maze3 nw = maze3
	maze4 ne = maze5
	maze4 e = maze4
	maze4 se = maze3
	maze4 s = maze4
	maze4 sw = maze2
	maze4 w = maze1
	maze4 nw = maze2
	maze4 n = maze3
	maze5 s = maze6
	maze5 sw = maze2
	maze5 w = maze3
	maze5 nw = maze2
	maze5 n = maze4
	maze5 ne = maze4
	maze5 e = maze1
	maze5 se = maze1
	maze6 e = tunnel1
	maze6 se = maze2
	maze6 s = maze5
	maze6 sw = maze4
	maze6 w = maze4
	maze6 nw = maze1
	maze6 n = maze2
	maze6 ne = maze3
	tunnel1 w = maze6
	tunnel2 w = tunnel1
	tunnel2 e = canyon_centre
	canyon_centre w = tunnel2
	canyon_centre n = canyon_north
	canyon_centre s = canyon_south
	canyon_south n = canyon_centre
	canyon_south se = cave2
	cave2 nw = canyon_south
	canyon_north s = canyon_centre
	canyon_north n = canyon_teleport
	canyon_teleport s = canyon_north
	hangar_teleport n = hangar
	hangar s = hangar_teleport
	hangar e = corridor19
	corridor19 w = hangar
	corridor19 e = computer_room
	computer_room w = corridor19
	airlock2 down = hangar
	airlock2 up = corridor14
	corridor13 e = corridor14
	corridor13 up = corridor16
	corridor14 w = corridor13
	corridor14 e = corridor15
	corridor14 down = airlock2
	corridor15 w = corridor14
	corridor15 up = corridor18
	corridor16 down = corridor13
	corridor16 e = corridor17
	corridor17 w = corridor16
	corridor17 e = corridor18
	corridor17 up = control_room2
	corridor18 w = corridor17
	corridor18 down = corridor15
	control_room2 down = corridor17

			// Location short descriptions

	control_room short_desc = "Control Room"
	corridor1 short_desc = "Corridor"
	corridor2 short_desc = "Corridor"
	corridor3 short_desc = "Corridor"
	office1 short_desc = "Office"
	office2 short_desc = "Office"
	lift_top short_desc = "Top of Lift"
	corridor4 short_desc = "Corridor"
	bar short_desc = "Bar"
	kitchen short_desc = "Kitchen"
	cargo_hold short_desc = "Cargo Hold"
	lift_centre short_desc = "Centre of Lift"
	explosive_store short_desc = "Store Room"
	corridor5 short_desc = "Corridor"
	corridor6 short_desc = "Corridor"
	chemical_store short_desc = "Store Room"
	corridor7 short_desc = "Corridor"
	corridor8 short_desc = "Corridor"
	storage_compartment short_desc = "Storage Compartment"
	corridor9 short_desc = "Corridor"
	locker short_desc = "Space Suit Locker"
	corridor10 short_desc = "Corridor"
	corridor11 short_desc = "Corridor"
	corridor12 short_desc = "Corridor"
	fridge short_desc = "Refridgeration Room"
	equipment_store short_desc = "Store Room"
	lift_bottom short_desc = "Bottom of Lift"
	airlock short_desc = "Airlock"
	crater short_desc = "Crater"
	cave_entrance short_desc = "Cave Entrance"
	cave1 short_desc = "Cave"
	maze1 short_desc = "Maze"
	maze2 short_desc = "Maze"
	maze3 short_desc = "Maze"
	maze4 short_desc = "Maze"
	maze5 short_desc = "Maze"
	maze6 short_desc = "Maze"
	tunnel1 short_desc = "Tunnel"
	tunnel2 short_desc = "Tunnel"
	canyon_centre short_desc = "Canyon Centre"
	canyon_south short_desc = "Canyon South"
	cave2 short_desc = "Cave"
	canyon_north short_desc = "Canyon North"
	canyon_teleport short_desc = "Teleport Cubicle"
	hangar_teleport short_desc = "Teleport Cubicle"
	hangar short_desc = "Hangar"
	corridor19 short_desc = "Corridor"
	computer_room short_desc = "Computer Room"
	airlock2 short_desc = "Airlock"
	corridor13 short_desc = "End of Corridor"
	corridor14 short_desc = "Corridor"
	corridor15 short_desc = "End of Corridor"
	corridor16 short_desc = "End of Corridor"
	corridor17 short_desc = "Corridor"
	corridor18 short_desc = "End of Corridor"
	control_room2 short_desc = "Control Room"

			// Location long descriptions

	control_room long_desc =
	"You are in the control room of the starship. To the west, the front "
	"window gives a spectacular view of the completely desolate, lifeless, "
	"airless and generally not very interesting surface of planet "
	"Betelgeuse Delta. To the east is the door leading to the rest of the "
	"ship. The control panel is blotched with large dead patches where "
	"the lights and dials have gone out."

	corridor1 long_desc =
	"This is a short corridor connecting the control room to the west with "
	"the gravity lift to the east. Another corridor leads north-east."

	corridor2 long_desc =
	"This is a corridor running around the top deck of the ship. To the "
	"north is a doorway and to the south is the gravity lift. The corridor "
	"extends east and southwest."

	corridor3 long_desc =
	"This is the east end of a short east-west corridor. To the north is "
	"a door."

	office1 long_desc =
	"This is a small undistinguished office. A doorway leads south into a "
	"corridor."

	office2 long_desc =
	"This is a large spacious office. On the wall is a picture of an "
	"exotic alien landscape."

	lift_top long_desc =
	"You are at the top of the gravity lift, an open shaft running "
	"vertically through all three decks of the ship and containing a "
	"field which neutralizes the ship's artificial gravity. Rungs run "
	"the length of the shaft by which people can pull themselves up and "
	"down. The shaft extends about six metres below you. A corridor "
	"leads west."

	corridor4 long_desc =
	"This is a short corridor connecting the kitchen to the west with "
	"the lift to the east. The bar is to the southeast and a doorway leads "
	"northeast."

	bar long_desc =
	"This is the most heavily frequented part of the ship. One wall is "
	"covered with racks, now sadly empty, for holding bottles of various "
	"kinds. A doorway leads northwest."

	kitchen long_desc =
	"You are in the ship's kitchen surrounded by devices for preparing "
	"food. A doorway leads east."

	cargo_hold long_desc =
	"You are standing on a catwalk overlooking the cargo hold which "
	"occupies much of the space in the middle of the ship. The hold is "
	"currently full of containers covered with cryptic markings, the "
	"nearest one close enough to touch but unfortunately for you "
	"sealed and designed to withstand anything short of a nuclear "
	"explosion. A doorway leads southwest."

	lift_centre long_desc =
	"This is the centre of the gravity lift. The shaft extends for about "
	"three metres up and down. A corridor leads west."

	explosive_store long_desc =
	"This room is used for storing explosives. A door leads east."

	corridor5 long_desc =
	"You are at the west end of a long corridor. A door to the west bears "
	"the sign \"DANGER - EXPLOSIVES\"."

	corridor6 long_desc =
	"You are in a corridor which continues to the west and northeast. "
	"The gravity lift is to the east. A door to the north bears the sign "
	"\"DANGER - HAZARDOUS CHEMICALS\"."

	chemical_store long_desc =
	"This room is used for storing chemical supplies. A door leads south."

	corridor7 long_desc =
	"This corridor leads around the lower deck of the ship. It continues "
	"southwest and southeast and another corridor leads north."

	corridor8 long_desc =
	"You are in a corridor which continues to the east and northwest. To "
	"the north is a door."

	storage_compartment long_desc =
	"You are in a small storage compartment. The only exit is south."

	corridor9 long_desc =
	"You are at the east end of an east-west corridor. To the south is the "
	"entrance to the airlock. To the east is a door with a damaged lock "
	"and a padlock fastened to it."

	locker long_desc =
	"You are in the ship's space suit storage locker. There is a door to "
	"the west."

	corridor10 long_desc =
	"This is a north-south corridor. To the north you can see the glow of "
	"the one-way neural barrier security system. You know that the field "
	"works by interfering with the nervous system of the target."

	corridor11 long_desc =
	"This is a north-south corridor. To the north is a doorway and another "
	"corridor leads west."

	corridor12 long_desc =
	"This is a short corridor connecting the refrigeration room to the "
	"west with another corridor to the east."

	fridge long_desc =
	"This is the refrigeration room where the ship's food supply was "
	"stored at 20 degrees below freezing. Fortunately for your comfort "
	"but unfortunately for your prospects of having an intact food supply "
	"for much longer, the temperature control appears to have been "
	"banjaxed when you blew up the door. Exit is east through the remains "
	"of said door."

	equipment_store long_desc =
	"This is a room used for storing various kinds of equipment. A "
	"doorway leads south."

	lift_bottom long_desc =
	"You are at the bottom of the gravity lift. The shaft extends up for "
	"about six metres. A corridor leads west."

	airlock long_desc =
	"This is the ship's airlock. The inner door is to the north and the "
	"outer door leads down to the surface. There is a keypad on the wall "
	"for typing in the access code to open the outer door."

	crater long_desc =
	"You are standing on the planet's surface in the crater in which the "
	"starship crash landed. The ship towers above you and can be entered "
	"by going up to the airlock door. The crater is ringed with jagged "
	"mountains but to the east you can see the entrance to a cave. There "
	"is a keypad beside the airlock door for typing the access code to "
	"open the door."

	cave_entrance long_desc =
	"You are in the entrance to an underground cave. To the west is an "
	"opening leading out into a large crater. A passage to the southeast "
	"leads deeper into the cave."

	cave1 long_desc =
	"You are in an underground cave. Passages lead northwest and east."

	maze1 long_desc =
	"You are in a maze of twisting underground passages."

	maze2 long_desc =
	"You are in a maze of twisting underground passages."

	maze3 long_desc =
	"You are in a maze of twisting underground passages."

	maze4 long_desc =
	"You are in a maze of twisting underground passages."

	maze5 long_desc =
	"You are in a maze of twisting underground passages."

	maze6 long_desc =
	"You are in a maze of twisting underground passages."

	tunnel1 long_desc =
	"You are in an underground tunnel which leads east-west."

	tunnel2 long_desc =
	"You are in an underground tunnel. You can see the gleam of starlight "
	"to the east. The tunnel continues to the west."

	canyon_centre long_desc =
	"You are in a deep canyon which runs north and south. You can see a "
	"cave entrance in the west wall of the canyon."

	canyon_south long_desc =
	"You are at the south end of the canyon. You can see a cave entrance "
	"to the southeast."

	cave2 long_desc =
	"You are in a small cramped cave. The cave exit is northwest."

	canyon_north long_desc =
	"You are at the north end of the canyon. A small metal structure "
	"stands to the north and can be entered by a door."

	canyon_teleport long_desc =
	"You are in a small teleport cubicle. Through a window set into the "
	"door you can see out into a canyon."

	hangar_teleport long_desc =
	"You are in a small teleport cubicle which opens into a spacecraft "
	"hangar to the north."

	hangar long_desc =
	"You are in a large spacecraft hangar, the type with a roof which can "
	"open to let ships land and take off and close so the place can be "
	"pressurized. There is a small spaceship standing in the middle of "
	"the chamber, the entrance to the airlock being a few metres above "
	"your head. A small cubicle is set into the south wall and a "
	"corridor leads east."

	corridor19 long_desc =
	"You are in a short east-west corridor."

	computer_room long_desc =
	"You are in a large room with gleaming metal walls, the place from "
	"which the operation of the base is supervised. The walls are lined "
	"with instruments of various kinds that you haven't a clue how to "
	"read. A corridor leads west."

	airlock2 long_desc =
	"You are in the airlock of a small spaceship. You can go down through "
	"the outer door or up through the inner door."

	corridor13 long_desc =
	"You are at the west end of a corridor. A ladder leads up."

	corridor14 long_desc =
	"You are in the middle of an east-west corridor. A hatch leads down "
	"into the airlock."

	corridor15 long_desc =
	"You are at the east end of a corridor. A ladder leads up."

	corridor16 long_desc =
	"You are at the west end of a corridor. A ladder leads down."

	corridor17 long_desc =
	"You are in the middle of an east-west corridor. A ladder leads up "
	"to a door."

	corridor18 long_desc =
	"You are at the east end of a corridor. A ladder leads down."

	control_room2 long_desc =
	"This is the control room of the spaceship. You can see the interior "
	"of the hangar through the front windows. A door leads down. A "
	"label beside the control panel says, THE AUTHORIZATION CODE TO "
	"ACTIVATE THE AUTOPILOT IS THE TENTH, ELEVENTH, TWELFTH AND "
	"THIRTEENTH DIGITS OF PI. TYPE IN THE NUMBER ON THE KEYPAD."

			// Special code to create some boxes nested inside each other

	i = 10
	box = create box
	box short_desc = "a box"
	box word_desc = "box"
	box moved = 1
	box weight = 100
	innerbox = box
	do
	{
		o = create box
		box in = o
		box = o
		box short_desc = "a box"
		box word_desc = "box"
		box moved = 1
		box weight = 100
		i = i - 1
	}
	while i

			// Position the outermost box in the first location

	box in = control_room
	box moved = 0
	box long_desc = "There is a large box sitting on the floor."

			// Only two objects start the game open

	drive is_open = 1
	bottle is_open = 1

			// Create the buttons for the teleport devices

	o = create button
	o weight = 9999
	o long_desc = "There is a button set into the wall."
	o word_desc = "button"
	o examine_desc = "You could try pressing it."
	o in = canyon_teleport

	o = create button
	o weight = 9999
	o long_desc = "There is a button set into the wall."
	o word_desc = "button"
	o examine_desc = "You could try pressing it."
	o in = hangar_teleport

			// Position all objects initially

	player in = control_room

	lamp in = fridge
	card in = innerbox
	torch in = innerbox
	herring in = kitchen
	safe in = office1
	detonator in = chemical_store
	ceramic_key in = locker
	suit in = locker
	explosive in = explosive_store
	mask in = explosive_store
	whisky in = bottle
	disk in = safe
	drive in = equipment_store
	book in = safe
	computer in = storage_compartment
	socket in = computer_room
	ladder in = equipment_store
	scrap in = cave2
	paper in = storage_compartment
	pan in = kitchen
	shovel in = equipment_store
	bottle in = bar
	rubble in = tunnel1
	desk in = office2
	tiger in = corridor19

			// Object short descriptions

	lamp short_desc = "an atomic lamp"
	card short_desc = "an American Express card"
	torch short_desc = "an oxy-acetylene torch"
	herring short_desc = "a red herring"
	detonator short_desc = "a detonator"
	plastic_key short_desc = "a plastic key"
	metal_key short_desc = "a metal key"
	ceramic_key short_desc = "a ceramic key"
	suit short_desc = "a space suit"
	explosive short_desc = "some plastic explosive"
	mask short_desc = "a gas mask"
	whisky short_desc = "some Scotch whisky"
	disk short_desc = "a floppy disk"
	drive short_desc = "a disk drive"
	book short_desc = "a book"
	computer short_desc = "a computer"
	ladder short_desc = "a ladder"
	scrap short_desc = "a piece of scrap metal"
	paper short_desc = "a sheet of paper"
	pan short_desc = "a saucepan"
	shovel short_desc = "a shovel"
	bottle short_desc = "a whisky bottle"

			// Object one-word names

	lamp word_desc = "lamp"
	card word_desc = "card"
	torch word_desc = "torch"
	herring word_desc = "herring"
	detonator word_desc = "detonator"
	plastic_key word_desc = "plastic key"
	metal_key word_desc = "metal key"
	ceramic_key word_desc = "ceramic key"
	suit word_desc = "space suit"
	explosive word_desc = "explosive"
	mask word_desc = "gas mask"
	whisky word_desc = "whisky"
	disk word_desc = "disk"
	drive word_desc = "disk drive"
	book word_desc = "book"
	computer word_desc = "computer"
	ladder word_desc = "ladder"
	scrap word_desc = "scrap metal"
	paper word_desc = "sheet of paper"
	pan word_desc = "saucepan"
	shovel word_desc = "shovel"
	bottle word_desc = "bottle"

			// Object long descriptions. Note that some objects will never need
			// long descriptions as they will be moved when the player sees
			// them for the first time.

	lamp long_desc = "An atomic lamp is sitting on a shelf."
	card moved = 1
	torch moved = 1
	herring long_desc = "There is a red herring on the counter."
	safe long_desc = "There is a large steel safe in the corner."
	detonator long_desc = "An object which you recognize as a detonator "
		"is sitting on a shelf."
	plastic_key moved = 1
	metal_key moved = 1
	ceramic_key long_desc = "There is a small ceramic key on a shelf."
	suit long_desc = "A space suit is hanging on a rack."
	explosive long_desc = "There is some plastic explosive on a shelf."
	mask long_desc = "A gas mask is hanging on a hook."
	whisky moved = 1
	disk moved = 1
	drive long_desc = "There is a disk drive here."
	book moved = 1
	computer long_desc = "There is a computer on a shelf."
	socket long_desc = "On one wall is a data communications socket."
	ladder long_desc = "There is a ladder leaning against the wall."
	scrap long_desc = "There is a piece of scrap metal lying in the "
		"corner."
	paper long_desc = "There is a sheet of paper lying on the floor."
	pan long_desc = "There is a saucepan on a counter."
	shovel long_desc = "A shovel is leaning against the wall."
	bottle long_desc = "Amazingly there is still a whisky bottle sitting "
		"on the counter."
	rubble long_desc = "A pile of rubble is blocking the passage to the "
		"east."
	desk long_desc = "There is a large, expensive-looking desk in the "
		"middle of the room."
	tiger long_desc = "A large tiger steps out in front of you and smiles. "
		"It doesn't actually look like it's baring its teeth in a "
		"threatening manner. It looks like it's smiling in "
		"happiness at the prospect of some fresh meat for the "
		"first time in ages. Looks like someone was a little "
		"over-enthusiastic in arranging to guard the premises while "
		"everyone was away."

			// Messages for examining objects

	lamp examine_desc = "This is a latest-model lamp powered by a built-in "
		"plutonium cell."
	card examine_desc = "This is an American Express card accepted nowhere "
		"in the entire known galaxy. For an explanation of its usefulness "
		"see \"So Long and Thanks For All the Fish\" by Douglas Adams."
	torch examine_desc = "This is an oxy-acetylene cutting torch with an "
		"integral fuel cell, capable of cutting through many metals."
	herring examine_desc = "It's just a red herring."
	safe examine_desc = "This huge massive safe must weigh at least half a "
		"ton. There is a keyhole in the front."
	detonator examine_desc = "This device can create the shock wave required "
		"to detonate modern plastic explosives."
	plastic_key examine_desc = "This is a key made from plastic. You open "
		"things with it."
	metal_key examine_desc = "This is a key made from metal. You open "
		"things with it."
	ceramic_key examine_desc = "This is a key made from ceramics. You open "
		"things with it."
	suit examine_desc = "This suit is designed to protect its wearer "
		"from the vacuum of space."
	explosive examine_desc = "This is a charge of plastic explosive of the "
		"type which can only be set off by a sharp shock wave."
	mask examine_desc = "This is a standard activated carbon filter gas mask "
		"which absorbs toxic substances from the air."
	whisky examine_desc = "The whisky is finest Scotch of a brand with which "
		"you are extremely familiar."
	disk examine_desc = "It's a standard 500-gigabyte 4-cm floppy disk."
	drive examine_desc = "It's a standard 500-gigabyte 4-cm floppy disk drive."
	book examine_desc = "It's a copy of Oolon Colluphid's philosophical "
		"blockbuster \"Who is this God Person Anyway?\"."
	computer examine_desc = "It's a small portable computer with 256 gigabytes "
		"of memory and an 11-gigaflops optical processor array. It also has "
		"a built-in screen and "
		"a cable for connection to a data communications socket. To use, "
		"connect it to a disk drive, put a boot disk in the drive and turn it "
		"on. The software on the disk will run automatically."
	socket examine_desc = "It's a standard 30-gigabaud optical data "
		"communications socket."
	ladder examine_desc = "It's a ladder. You climb things with it. Use it by "
		"putting it down in the appropriate place and typing GO UP."
	scrap examine_desc = "It's just some useless scrap metal which is why it "
		"was left lying in a cave in the first place."
	paper examine_desc = "It's part of a printout of a computer program. "
		"The number 7648 is scribbled on the back."
	pan examine_desc = "It's a saucepan. People cook things in it. "
		"Alternatively you could for example bash someone over the head with "
		"it if there was anyone around at the moment which there isn't but "
		"basically people use it for cooking."
	shovel examine_desc = "The shovel on closer examination actually turns "
		"out to be a portable interstellar spaceship in disguise. Ah no, "
		"only joking, it's just a shovel after all. Type DIG to use it."
	bottle examine_desc = "It's a Scotch whiskey bottle."
	rubble examine_desc = "It's a large mass of rubble collapsed from the "
		"ceiling, completely blocking the tunnel."
	desk examine_desc = "It's a large, imposing, uncluttered and expensive-"
		"looking desk."
	tiger examine_desc = "It's a large furry creature with four legs, a tail, "
		"black and orange stripes and lots of large sharp teeth."

			// Object weights

	lamp weight = 150
	card weight = 5
	torch weight = 160
	herring weight = 120
	safe weight = 9999
	detonator weight = 75
	plastic_key weight = 5
	metal_key weight = 7
	ceramic_key weight = 6
	suit weight = 400
	explosive weight = 80
	mask weight = 85
	whisky weight = 40
	disk weight = 7
	drive weight = 65
	book weight = 65
	computer weight = 300
	socket weight = 9999
	ladder weight = 300
	scrap weight = 300
	paper weight = 2
	pan weight = 110
	shovel weight = 200
	bottle weight = 60
	rubble weight = 9999
	desk weight = 9999
	tiger weight = 9999

			// Create doors between locations (all initially closed)

	control_room create_door 3
	corridor3 create_door 1
	corridor12 create_door 4
	corridor9 create_door 3
	corridor5 create_door 4
	corridor6 create_door 1
	storage_compartment create_door 2
	airlock create_door 10
	canyon_north create_door 1
	corridor17 create_door 9

			// Which locations are dark

	cave1 is_dark = 1
	maze1 is_dark = 1
	maze2 is_dark = 1
	maze3 is_dark = 1
	maze4 is_dark = 1
	maze5 is_dark = 1
	maze6 is_dark = 1
	tunnel1 is_dark = 1

			// Which locations are in vacuum

	crater is_vacuum = 1
	cave_entrance is_vacuum = 1
	cave1 is_vacuum = 1
	maze1 is_vacuum = 1
	maze2 is_vacuum = 1
	maze3 is_vacuum = 1
	maze4 is_vacuum = 1
	maze5 is_vacuum = 1
	maze6 is_vacuum = 1
	tunnel1 is_vacuum = 1
	tunnel2 is_vacuum = 1
	canyon_north is_vacuum = 1
	canyon_centre is_vacuum = 1
	canyon_south is_vacuum = 1
	cave2 is_vacuum = 1
	canyon_teleport is_vacuum = 1

			// Start off by describing initial location

	player describe_location 0
}
