#include	<string.h>
#include	<rwlib.h>
#include	"ins.h"

struct instruction
{
	int op;
	int i;
};

int file;
char **vocab;

char *typenames[] =
{
	"VOID",
	"INT",
	"STR",
	"OBJECT",
};

char *mnemonics[] =
{
	"JMP",
	"JF",
	"JT",
	"INT",
	"OR",
	"AND",
	"NOT",
	"REFLOCALVAR",
	"REFARG",
	"REFGLOBALVAR",
	"REFPROPERTY",
	"DEREF",
	"CALLPROC",
	"CALLFUNC",
	"ASSIGN",
	"DESTROY",
	"CREATE",
	"EXIT",
	"QUIT",
	"THIS",
	"RETPROC",
	"RETFUNC",
	"EXISTS",
	"OBJECT",
	"PRINTINT",
	"PRINTSTR",
	"SAVE",
	"LOAD",
	"MINUS",
	"ADD",
	"SUB",
	"MUL",
	"DIV",
	"MOD",
	"EQ",
	"NE",
	"GT",
	"LT",
	"GE",
	"LE",
	"OEQ",
	"ONE",
	"RANDOM",
	"IS",
	"NEXT",
};

char args[] =
{
	1,
	1,
	1,
	1,
	0,
	0,
	0,
	1,
	1,
	1,
	1,
	0,
	1,
	1,
	0,
	0,
	1,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	1,
	0,
};

readint ()
{
	int i;
	Read (file,&i,sizeof (int));
	return i;
}

main (int argc,char **argv)
{
	int n,i,j,k;
	instruction *I;
	static char buf[10240];

	if (argc != 2 || !strcmp (argv[1],"?"))
		perr ("Object-Oriented Adventure Disassembler" VERSION "\n"
				"Usage: oad filename");

	file = Open (argv[1]);

	Read (file,buf,4);
	if (memcmp (buf,"oas",4))
		perr ("Not an OASYS file");

	n = readint ();
	printf ("%d strings\n\n",n);
	while (--n >= 0)
	{
		i = readint ();
		Read (file,buf,i);
		buf[i] = 0;
		for (i=0 ; buf[i] ; i++)
			if (buf[i] < 32 || buf[i] > 126)
				buf[i] = '*';
		printf ("\"%s\"\n",buf);
	}
	putchar ('\n');

	n = readint ();
	printf ("%d variables\n\n",n);
	while (--n >= 0)
		printf ("%s\n",typenames[readint ()]);
	putchar ('\n');

	n = readint ();
	printf ("%d properties\n\n",n);
	while (--n >= 0)
		printf ("%s\n",typenames[readint ()]);
	putchar ('\n');

	n = readint ();
	printf ("%d words\n\n",n);
	vocab = new char *[n];
	for (i=0 ; i<n ; i++)
	{
		j = readint ();
		vocab[i] = new char[j+1];
		Read (file,vocab[i],j);
		vocab[i][j] = 0;
		printf ("%s\n",vocab[i]);
	}
	putchar ('\n');

	n = readint ();
	printf ("%d classes\n\n",n);
	while (--n >= 0)
	{
		putchar ('{');
		i = readint ();
		while (--i >= 0)
		{
			putchar ('{');
			j = readint ();
			while (--j >= 0)
			{
				printf (vocab[readint ()]);
				if (j)
					putchar (' ');
			}
			putchar ('}');
		}
		printf ("}\n");
	}
	putchar ('\n');

	n = readint ();
	printf ("%d methods\n\n",n);
	printf ("Init method = %d\n\n",readint ());
	printf ("Select addressee method = %d\n\n",readint ());
	while (--n >= 0)
	{
		printf ("Method %s\n\n",typenames[readint ()]);
		i = readint ();
		printf ("%d arguments\n\n",i);
		if (i)
		{
			do
			{
				j = readint ();
				k = readint ();
				printf ("Type %s Selector %d\n",typenames[j],k);
			}
			while (--i > 0);
			putchar ('\n');
		}
		i = readint ();
		printf ("%d variables\n\n",i);
		if (i)
		{
			do
				printf ("%s\n",typenames[readint ()]);
			while (--i > 0);
			putchar ('\n');
		}
		i = readint ();
		if (i)
		{
			putchar ('{');
			while (--i >= 0)
			{
				putchar ('{');
				j = readint ();
				while (--j >= 0)
				{
					k = readint ();
					if (k >= 0)
						printf (vocab[k]);
					else
						printf ("<%d>",~k);
					if (j)
						putchar (' ');
				}
				putchar ('}');
			}
			printf ("}\n\n");
		}
		printf ("Message %d\n\n",readint ());
		i = readint ();
		if (i)
		{
			I = new instruction[i];
			Read (file,I,i * sizeof (instruction));
			for (j=0 ; j<i ; j++)
			{
				int op = I[j].op;
				char *s = mnemonics[op];
				printf (s);
				if (args[op])
				{
					k = 16 - strlen (s);
					do
						putchar (' ');
					while (--k > 0);
					printf ("%d",I[j].i);
				}
				putchar ('\n');
			}
			delete I;
		}
		putchar ('\n');
	}

	return 0;
}
