#include <dos.h>
#include <string.h>
#include <graphics.h>
#include <direct.h>
#include <alloc.h>
#include <conio.h>
#include <dos.h>
#include <fcntl.h>
#include <io.h>
#include <mem.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys\stat.h>

#define TRUE 1
#define FALSE 0
#define IN 0
#define OUT 1
#define THICK 0
#define THIN 1
#define TEXT 0
#define IMAGE 1
#define SAVEBGD 1

#define ALTA 30
#define ALTB 48
#define ALTC 46
#define ALTD 32
#define ALTE 18
#define ALTF 33
#define ALTG 34
#define ALTH 35
#define ALTI 23
#define ALTJ 36
#define ALTK 37
#define ALTL 38
#define ALTM 50
#define ALTN 49
#define ALTO 24
#define ALTP 25
#define ALTQ 16
#define ALTR 19
#define ALTS 31
#define ALTT 20
#define ALTU 22
#define ALTV 47
#define ALTW 17
#define ALTX 45
#define ALTY 21
#define ALTZ 44

#define ALT1 120
#define ALT2 121
#define ALT3 122
#define ALT4 123
#define ALT5 124
#define ALT6 125
#define ALT7 126
#define ALT8 127
#define ALT9 128
#define ALT0 129

#define ALTMINUS  130
#define ALTPLUS   131

//GENERAL
void dlay(int ticks);
long getticks();
int altkey();
int ctrlkey();
int lshiftkey();
int rshiftkey();
int shiftkey();
void flushkeys();
unsigned char getvidmode();
unsigned char alt_to_asc(unsigned char);

//MCURSOR
extern int _MX;
extern int _MY;

void far interrupt MouseHandler(void);

class Mcursor {
	  int shown;
	  int current;
	  int xpos;
	  int ypos;
	  void mouse_interrupt();
	  void InstallHandler(unsigned mask,void far interrupt (*handler)(void)=MouseHandler);
	  void ClearHandler(void);
	  int m1;
	  int m2;
	  int m3;
	  int m4;
	  int button;
	  int disabled;
	  int pos_changed;
	  int lastx,lasty;
	  int y_changed;
	  int x_changed;
	  int eventMask;
	  int handler_installed;
	public:
	  ~Mcursor();
	  int  init();
	  void set();
	  void changeto(int);
	  void get_status();
	  void show();
	  void hide();
	  void set_hor_bounds(int,int);
	  void set_ver_bounds(int,int);
	  void conditional_off(int x1,int y1,int x2,int y2);
	  void position(int,int);
	  int  LBP();
	  int  RBP();
	  int  moved();
	  int  moved_y();
	  int  moved_x();
	  int  getcurrent();
	  int  mousex();
	  int  mousey();
	  int  mx();
	  int  my();
	  void unarm();
	  void arm();
	  int  LBDCLK();
	  long thistick;
	  long previoustick;
	  int doubleclicked;
	  };

#define UPARROW 1
#define DOT 2
#define PENCIL 3
#define CROSSHAIR 4
#define ARROW 5
#define FINGER 6
#define POINT 7
#define CLOCK 8
#define DISK 9
#define IBAR 10
#define PAINTCAN 11
#define HAND 12
#define ERASOR 13
#define GUNSIGHT 14
#define SCISSORS 15
#define JAWS 16

//POINT
class Point
{
	protected:
		int x,y,color;
		void far * background;
		long backgroundsize;
		char tempfile[MAXPATH];
		int image_is_on_disk;
	public:
		Point();
		~Point();
		void elim();
		int Getx();
		int Gety();
		int Getcolor();
		int write_background();
		int read_background();
		};


//GSTRING
void beep();
char *strdel(char *,int);
char *strins(char *,int,char);

class Gstring:public Point {
	protected:
		int xpos;
		int length;
		int strlength;
		int height;
		int ucase;
		char laststring[81];
		int shown,wasshown;
		int outlined,wasoutlined;
		int escape;
		int retrn;
		int tab;
		int uparrow;
		int dnarrow;
		int infgd;
		int inbgd;
		int firstchar;
		int curpos;
		int curson;
		void showcurs();
		void hidecurs();
		long last_tick;
		int clickcount;
	public:
		Gstring();
		~Gstring();
		void elim();
		void init(int,int,int,int,int savebgd=0);
		void reinit(int,int,int,int);
		void show();
		void input();
		void get_input();
		void get_form_input();
		void get_form_mouse_input();
		char *getstring();
		void reset();
		void preset(char *);
		int isshown();
		void check_for_blink();
		int returnhit();
		int escapehit();
		int uparrowhit();
		int dnarrowhit();
		int tabhit();
		void setincolors(int,int);
		int hit();
		void outline(int,int offset=0);
		void move(int,int);
		void hide();
		int Getx();
		int Gety();
		int is_ucase();
		int clicked();
		int LBDCLK();
		int Getlength();
		};



//LINE
class Line:public Point
{
	protected:
		int x2;
		int y2;
		int style;
	public:
		Line();
		~Line();
		int Getx2();
		int Gety2();
		int Getstyle();
		void init(int,int,int,int,int,int);
		void show();
		void outline();
		int starthit();
		int endhit();
		void end_to_start();
		void start_to_end();
		void swap_ends();
		void new_end(int,int);
		void new_start(int,int);
		};

//GTEXT
class Gtext:public Point
{
	protected:
		struct textsettingstype ts;
		int length;
		int height;
		int strlength;
		int fgd;
		int bgd;
		int size;
		char text[41];
		int shown,wasshown;
		int outlined,wasoutlined;
		long last_tick;
		int clickcount;
	public:
		Gtext();
		~Gtext();
		int Getlength();
		int Getstrlength();
		int Getsize();
		void init(int,int,char *,int,int,int,int savebgd=0);
		void show();
		void hide();
		void outline(int,int offset=0);
		void reinit(int,int,char *,int,int,int);
		int is_shown();
		int hit();
		int clicked();
		int LBDCLK();
		void move(int,int);
		char * Gettext();
		int Getfgd();
		int Getbgd();
		};

//COLORBUTTON
class Colorbutton:public Point
{
	protected:
		int color;
		int width;
		int height;
	public:
		void init(int,int,int,int,int);
		void show(int);
		int  clicked();
		int      hit();
		int getcolor();
		};

//COLSEBUTTON
class Closebutton:public Colorbutton
{
	public:
		void move(int,int);
		void  show();
		};

//ICON
class Icon:public Point
{
	protected:
		int state;
		int w,h;
		void far *picture;
		int shown,wasshown;
		int outlined,wasoutlined;
		char fn[9];
		char filename[13];
		long last_tick;
		int clickcount;
	public:
		Icon();
		~Icon();
		void init(int,int,char*,int savebgd=0);
		void reinit(int,int,char*);
		void freepicture();
		void show();
		void choose();
		int hit();
		int clicked();
		int ispressed();
		void outline(int,int offset=0);
		void hide();
		void move(int,int);
		char * Getfilename();
		int LBDCLK();
		int Getw();
		int Geth();
		};

//GCHECKBOX
class Gcheckbox:public Point
{
	protected:
		int checked;
		char desc[40];
		int length;
		int shown,wasshown;
		int outlined,wasoutlined;
		long last_tick;
		int clickcount;
	int bgd;
	public:
		Gcheckbox();
		~Gcheckbox();
		void init(int,int,char *,int savebgd=0);
		void reinit(int,int,char *);
		void show();
		void check();
		void uncheck();
		int is_checked();
		int hit();
		void outline(int,int offset=0);
		void hide();
		void move(int,int);
		char * Gettext();
		int clicked();
		int LBDCLK();
		void setbgd(int);
		};

//GRADIO
class Gradio:public Gcheckbox
{
	public:
		void show();
		void check();
		void uncheck();
		};

//ACTICON
class Acticon:public Icon
{
	protected:
		void far *picture[32];
		int state;
		int numpix;
	public:
		Acticon();
		~Acticon();
		void init(int,int,char*);
		void show(int);
		void choose();
		int ispressed();
		void animate(int);
		void backforth(int);
		};

//BUTTON
class Button:public Point
{
	protected:
		int state,sizex,sizey;
		char btntxt[40];
		int  file_text;
		void far *picture;
		void getpic(char*);
		int outlined,wasoutlined;
		int shown,wasshown;
		long last_tick;
		int clickcount;
		int w,h;
	public:
		Button();
		~Button();
		virtual void show();
		virtual void press();
		void init(int ptx,int pty,char* text,int,int savebgd=0);
		void reinit(int,int,char *,int);
		void freepicture();
		void resize(int,int,int savebgd=0);
		int hit();
		int pressed();
		void hide();
		void outline(int,int offset=0);
		void move(int,int);
		int Getformat();
		char * Getcontents();
		int clicked();
		int LBDCLK();
		int Getw();
		int Geth();
		};

//BITMAP
class Bitmap:public Point
{
	protected:
		int sizex,sizey;
		int size;
		void far *picture;
		int shown;
		int clickcount;
	long last_tick;
	public:
		Bitmap();
		~Bitmap();
		void init(int,int);
		void load(char *);
		void save(char *);
		void show_XOR();
		void show_COPY();
		void show_AND();
		void show_OR();
		void show_NOT();
		int is_shown();
		void hide();
		void moveto(int,int);
		int capture(int,int,int,int);
		int hit();
		int clicked();
		int LBDCLK();
		int LBSCLK();
		int xsize();
		int ysize();
		int bitmapx();
		int bitmapy();
		void changexy(int,int);
		};

//PANEL
class Panel:public Point
{
	protected:
		int w;
		int h;
		int in_or_out;
		int thick_or_thin;
		int shown,wasshown;
		int outlined,wasoutlined;
		long last_tick;
		int clickcount;
	int panelcolor;
	public:
		Panel();
		~Panel();
		virtual void show();
		void init(int,int,int,int,int,int,int savebgd=0);
		void reinit(int,int,int,int,int,int);
		void hide();
		int isshown();
		void outline(int,int offset=0);
		void move(int,int);
		int hit();
		void resize(int,int,int savebgd=0);
		int sizerhit();
		int Getw();
		int Geth();
		int clicked();
		int LBDCLK();
		int Getthick();
		int Getin();
		void setpanelcolor(int);
		};

//BEVEL
class Bevel:public Point
{
	private:
		int w;
		int h;
		int thick_or_thin;
		Panel *outerbevel;
		Panel *innerbevel;
		int outlined,wasoutlined;
		int shown,wasshown;
		long last_tick;
		int clickcount;
		int bevelcolor;
	public:
		Bevel();
		~Bevel();
		void init(int,int,int,int,int,int savebgd=0);
		void reinit(int,int,int,int,int);
		virtual void show();
		void hide();
		int isshown();
		void outline(int,int offset=0);
		void move(int,int);
		int hit();
		int sizerhit();
		void resize(int,int,int savebgd=0);
		int Getw();
		int Geth();
		int clicked();
		int LBDCLK();
		int Getthick();
		void setbevelcolor(int);
		};

//BUTTONBOX
class Buttonbox:public Point
{
	protected:
		Bevel *box;
		Button  *buttons[16];
		int outlined,wasoutlined;
		int shown,wasshown;
		int numbuttons;
		int w,h;
	public:
		Buttonbox();
		~Buttonbox();
		void init(int,int,int);
		void setbutton(int,char *);
		int hit();
		int moverhit();
		void show();
		void outline(int,int offset=0);
		void hide();
		void move(int,int);
		int buttoncount();
		int buttonhit(int);
		void buttonpress(int);
		void buttonshow(int);
		int isshown();
		};

//GWINDOW
class Gwindow:public Point
{
	protected:
		Closebutton *closebox;
		int                     w,h;
		int                     fgd,bgd;
		int                     tfgd,tbgd;
		int                     active;
		char            title[48];
		void            *beneath;
	public:
		Gwindow();
		~Gwindow();
		void init(int,int,int,int,int,int,int,int,char *);
		void show();
		void redraw();
		void hide();
		int      closeboxhit();
		int  sizecornerhit();
		int  titlebarhit();
		void resize();
		void move();
		int write_to_disk();
		int read_from_disk();
		int totalGwindows();
		};

//GMENU
typedef char gitemarray[80][10];


class Gmenu {
	protected:
		int on;
		int x,y,w,h;
		int num;
		gitemarray gitems;
		int menuchoice;
		int oldbarx,oldbary;
		void *ptr;
		void *menubar;
	public:
		Gmenu();
		~Gmenu();
		void init(int xloc,int yloc,int numentries,gitemarray gitem);
		int show();
		void hide();
		int isshown();
		};

//OPTION
class option:public Point {
	protected:
		int r_value;
		int selectable;
		int selected;
		char text[30];
		int width;
		int hl;
		int self_colored;
		int sfgd;
		int sbgd;
		int shfgd;
		int shbgd;
		int disabled;
		int disabled_fgd;
		int disabled_bgd;
		int divider;
		int underline;
		int underline_position;
		long last_tick;
		int clickcount;
	public:
		void init(int,int,char *,int);
		void set_highlight_attrib(int);
		void display(int,int,int);
		char * get_text();
		int is_selectable();
		int get_r_value();
		void set_width(int);
		int hit();
		int is_highlighted();
		void self_color(int,int,int,int);
		void unable(int,int);
		void reenable();
		int is_enabled();
		int is_divider();
		void adjust_pos_to_pulldown(int,int);
		int clicked();
		int LBDCLK();
		void show_deactivated();
		int _3d;
		};

//PULLDOWN
class pulldown:public Point {
	protected:
		friend class menubar;
		int nfg,nbg,hfg,hbg;
		int shown;
		int width,height;
		int num_options;
		int part_of_menubar;
		char hotkeys[20];
		int kbtrigger_index;
	public:
		option options[20];
		void init(int,int,int,int,int xpos=10,int ypos=10);
		void set_option(int,char *,int);
		void determine_width_height();
		void display();
	void position(int,int);
		int trackmenu();
		void hide();
		int is_shown();
		void adjust_option_widths();
		void adjust_pos_to_menubar(int);
		int is_part_of_menubar();
		};

//MENUBAR
class menubar:public Point {
	protected:
		option *titles[10];
		pulldown *pd[10];
		int nfg,nbg,hfg,hbg;
		int num_titles;
		char hotkeys[10];
		int kbtrigger_index;
	public:
		menubar();
		~menubar();
		int _3d;
		void make_3d();
		void init(int,int,int,int);
		void set_title(int,char *,pulldown *);
		void display();
		int trackbar();
		int hit();
		int mouse_triggered();
		int kb_triggered();
		int triggered();
		};

//GMENUBUTTON
class Gmenubutton {
	protected:
		int on;
		int x,y;
		int offfgd,offbgd;
		int onfgd,onbgd;
		char id[20];
	public:
		Gmenubutton();
		~Gmenubutton();
		void init(int xloc,int yloc,int ffgd,int fbgd,
		int nfgd,int nbgd,char txt[20]);
		void show();
		void press();
		int hit();
		};

//GPRINT
void gprintf(int xloc,int yloc,char *fmt,...);
void gprintc(int xloc, int yloc, char *fmt,...);
void gprintxy(int xloc,int yloc,char *fmt,...);

//SOUNDQ
#define TimerTick 0x8
#define noisemax 4096
#define ON 1
#define OFF 0

#define C 523
#define CS 554
#define D 587
#define DS 622
#define E 659
#define F 698
#define FS 740
#define G 784
#define GS 831
#define A 880
#define AS 932
#define B 988
#define C1 1046

#define SN 32
#define EN 63
#define QN 125
#define HN 250
#define WN 500

#define ENT 20
#define QNT 41
#define HNT 83

#define BN 30000,5
#define SR 30000,32
#define ER 30000,63
#define QR 30000,125
#define HR 30000,250
#define WR 30000,500
#define NM 30000,1

class SoundQ{
	protected:
		float speed_factor;
	public:
		SoundQ();
		~SoundQ();
		void play(int,int);
		void adjust_speed(float);
		};

typedef struct
{
  int duration;
  int freq;
} noise;

void empty_sound_queue();
void init_sound(void);
void restore_sound(void);
int submit_sound(int freq,int delay);
void interrupt soundsystem(...);

#ifndef _DAC256_
#define _DAC256_
typedef unsigned char DacPalette256[256][3];
#endif

//SCREEN
extern "C" void         _Cdecl vga256_driver();
//extern "C" void       _Cdecl svga256m_driver(void);
//extern "C" void               _Cdecl svga16_driver(void);
extern "C" void         _Cdecl egavga_driver(void);
//extern "C" void       _Cdecl vga256_driver(void);


class Screen {
	protected:
		static int huge alwayszero();
		static int huge alwaysone();
		static int huge alwaystwo();
		static int huge alwaysthree();
		static int huge alwaysfour();
		static int huge alwaysfive();
	public:
		Screen();
		~Screen();
//              int VGA_600_16();
		int VGA_480_16();
		int VGA_350_16();
		int VGA_200_16();
		int VGA_200_256();
//              int VGA_350_256();
//              int VGA_400_256();
//              int VGA_480_256();
//              int VGA_600_256();
		void fill(int);
		};

//SUPPORTING FUNCTIONS FOR USE WITH 3rd PARTY .BGI DRIVERS
//long imsize(int,int,int,int);


/*
//SCREEN
extern "C" void         _Cdecl vga256_driver();

class Screen {
	protected:
		static int huge alwayszero();
	public:
		Screen();
		~Screen();
		int VGA_480_16();
		int VGA_350_16();
		int VGA_200_16();
		int VGA_200_256();
		void fill(int);
		};
*/

//LISTBOX
struct optionrec {
	option *entry;
	int index;
	optionrec *next;
	optionrec *previous;
	};

class listbox:public Point {
	protected:
		optionrec *listroot;
		optionrec *listend;
		optionrec *currentsel;
		Bevel *box;
		Button *up,*down,*pup,*pdown;
		Panel *controlpanel;
		int should_show_controls;
		int should_save_bgd;
		int selected_index;
		char * selected_string;
		int option_string_length;
		int changed;
		int size_forced;
		int forced_width;
		int forced_height;
	public:
		listbox();
		~listbox();
		int part_of_structure;
		void init(int,int,int,int savebgd=0);
		void force_size(int,int);
		void set_highlight_position(int);
		void append_item(char *);
		void show();
		void show_options(int);
		void hide();
		void scroll_list_up();
		void scroll_list_down();
		int tracklist();
		int options_displayed;
		int options_in_list;
		int option_width;
		int shown;
		int nfg,nbg,hfg,hbg;
		int index_at_top;
		int index_at_bottom;
		int hit();
		int is_current_index();
		char *is_current_string();
		int is_selected_index();
		char *is_selected_string();
		int selection_changed();
		void deactivate();
		void reactivate();
		int active;
		};

//DIRBOX
int name_sort(const void *a,const void *b);
class dirbox:public Point {
	protected:
		Bevel *box;
		listbox *drive;
		listbox *directory;
		Button *OK;
		Button *CANCEL;
		char fullpath[MAXPATH];
		char returnpath[MAXPATH];
		char lastvalidpath[MAXPATH];
		Gstring *filename;
		int shown;
		int turn;
		char dirmask[13];
		int intnumber;
		void interrupt (*oldhandler)(...);
	public:
		dirbox();
		~dirbox();
		void show();
		void hide();
		char * trackdir();
		void print_current_path();
		void change_directory(char *);
		void fill_directory_list();
		void fill_drive_list();
		void set_mask(char *);
		static void interrupt _handler(...);
		};

//PALETTE
typedef char palette_rec[256][3];
class Palette{
	protected:
		void loadpalette(int start, int number, const palette_rec palette);
		void readpalette(int start, int number, palette_rec palette);
		void clrpalette(int start, int number);
		void fadepalettein(int start, int count, const palette_rec palette);
		void fadepaletteout(int start, int count);
		void wait_vbi();
	public:
		Palette();
		~Palette();
		void read();
		void write();
		void fadein();
		void fadeout();
		void clear();
		};

//MESSAGEBOX
#define MB_OK           0x0001
#define MB_CANCEL   0x0002
#define MB_OKCANCEL     0x0003
#define MB_YESNO        0x0004
#define ID_OK           1
#define ID_CANCEL       2
#define ID_YES          1
#define ID_NO           2

class messagebox:public Point {
	protected:
		Button *OK,*CANCEL,*YES,*NO;
		char bit;
		int border_color;
		int fill_color;
		int text_color;
		int OKbutton,CANCELbutton,YESbutton,NObutton;
		char *str;
	public:
		messagebox();
		~messagebox();
		int show(char *,char);
		void hide();
		};

int Messagebox(char *,char);

#define HORIZONTAL 0
#define VERTICAL 1
//SCROLLBAR
class scrollbar:public Point {
	protected:
		Button *thumbpad;
		Button *increase;
		Button *decrease;
		Panel *rect;
		int vertical;
		int width,height,length;
		int small_d,large_d;
		long minimum,maximum;
		long value;
		int changed;
		int _SCROLLWIDTH;
	public:
		void init(int,int,int,int,int,int,int scrollwidth=16);
		int get_scrollwidth();
		int button_widths();
		void show();
		int thumbpad_hit();
		int decrease_hit();
		int increase_hit();
		void track_scrollbar();
		long get_value();
		int value_changed();
		int hit();
		void set_small_d(int);
		void set_large_d(int);
		void set_minimum(long);
		void set_maximum(long);
		};

//PCX
#define PCX_COMP_FLAG 0xC0
#define PCX_COMP_MASK 0x3F
#define FILE_BUFFER_SIZE 16384

//**************************************************************************

typedef struct PCX_PALETTE
	{
	unsigned char red;
	unsigned char green;
	unsigned char blue;
	};

//*************************************************************************

typedef struct PCX_HEADER
	{
	unsigned char pcx_id;
	unsigned char version;
	unsigned char encoding;
	unsigned char bppixel;
	unsigned int start_X;
	unsigned int start_Y;
	unsigned int end_X;
	unsigned int end_Y;
	unsigned int resolution_X;
	unsigned int resolution_Y;
	PCX_PALETTE palette[16];
	unsigned char reserved;
	unsigned char nplanes;
	unsigned int bppscan;
	unsigned int palette_type;
	unsigned int screen_X;
	unsigned int screen_Y;
	unsigned char filler[54];
	};

//**************************************************************************

class PCX:public Point {
	protected:
		char pcxname[MAXPATH];
		int initial_palette;
		int is_256;
	public:
		int width;
		int depth;
	protected:
		int bytes;
		int mask;
		unsigned long page_offset;
		PCX_HEADER pcx_header;
		PCX_PALETTE *pcx_palette;
		unsigned char *saved_palette;
	public:
		PCX();
		~PCX();
		void init(char *,int,int);
		void show(int xpos=0,int ypos=0);
		void restore_palette();
		void unpackpcxfile();
		void readpcxline(char *,FILE *);
		int is_256_color();
		void save_initial_palette();
		void set_VGA_palette();
		void set_orig_palette();
		void Restore_initial_palette();
		void Set_16_Colors(unsigned char *);
		int PCX_Read();
		int PCX_Read_Init(FILE *);
		int PCX_Read_Line(FILE *,unsigned char *,int);
		void Put_EGA_Line(unsigned char *,int);
		void Set_PCX_Palette();
		};
