#include "d:\gui\gui.h"
#include "workshop.h"
#include <alloc.h>
#include <stdlib.h>
#include <conio.h>

//*********************************************************************
//		PROTOTYPES
//*********************************************************************

void set_screen_color();
void place_panel();
void place_bevel();
void place_radio();
void place_icon();
void place_string();
void place_button();
void place_line();
void place_text();

extern void redraw_screen();
extern void showmem();

//*********************************************************************
//		GLOBAL VARIABLES
//*********************************************************************

extern Screen screen;
extern Buttonbox toolbox;

extern panelrec *panelroot;
extern panelrec *currentpanel;
extern int numpanels;

extern bevelrec *bevelroot;
extern bevelrec *currentbevel;
extern int numbevels;

extern checkboxrec *checkboxroot;
extern checkboxrec *currentcheckbox;
extern int numcheckboxes;

extern Mcursor the_mouse;
extern int screencolor;

extern radiorec *radioroot;
extern radiorec *currentradio;
extern int numradios;

extern iconrec *iconroot;
extern iconrec *currenticon;
extern int numicons;

extern stringrec *stringroot;
extern stringrec *currentstring;
extern int numstrings;

extern buttonrec *buttonroot;
extern buttonrec *currentbutton;
extern int numbuttons;

extern Line line_info[100];
extern int numlines;

extern textrec *textroot;
extern textrec *currenttext;
extern int numtexts;

//*********************************************************************
//		SETSCREENCOLOR
//*********************************************************************

void set_screen_color()
{
	Bevel box;
	Gstring colornum;
	static int c=screencolor;
	Colorbutton cb[16];
	int i;
	Button OK;
	int ready=0;


	box.init(200,100,200,70,THICK,SAVEBGD);
	box.setbevelcolor(3);
	box.show();
	for(i=0;i<16;i++) {
		cb[i].init((10*i)+220,120,10,10,i);
		cb[i].show(0);
		}
	cb[c].show(15);
	OK.init(270,140,"  OK  ",TEXT);
	OK.show();

	while(!ready) {
		if(the_mouse.LBP()) {
			for(i=0;i<16;i++) {
				if(cb[i].hit()) {
					cb[c].show(0);
					cb[i].show(15);
					c=i;
					while(the_mouse.LBP());
					break;
					}
				}
			if(OK.hit()) {
				OK.press();
				while(the_mouse.LBP() && OK.hit());
				OK.show();
				if(OK.hit())
					ready=1;
				}
			}
		}
	screencolor=c;
	redraw_screen();
}

//*********************************************************************
//		PLACE_PANEL
//*********************************************************************

void place_panel()
{
	int ready=0;
	showmem();

	Bevel box;
	box.init(173,140,289,199,THICK,SAVEBGD);
	box.setbevelcolor(3);
	box.show();

	Panel panel1;
	panel1.init(192,232,130,48,IN,THIN);
	Panel panel2;
	panel2.init(191,290,253,30,IN,THIN);
	Panel panel3;
	panel3.init(337,232,107,49,IN,THIN);
	panel1.show();
	panel2.show();
	panel3.show();

	Button OK;
	OK.init(233,295,"  OK  ",TEXT);
	Button button1;
	button1.init(403,152,"PANEL",IMAGE);
	Button CANCEL;
	CANCEL.init(345,295,"CANCEL",TEXT);
	OK.show();
	button1.show();
	CANCEL.show();

	Gstring name;
	name.init(267,211,20,0);
	name.show();

	Gradio thick;
	thick.init(208,239,"Thick");
	Gradio thin;
	thin.init(208,262,"Thin");
	Gradio in;
	in.init(355,239,"In");
	Gradio out;
	out.init(355,262,"Out");
	thick.show();
	thin.show();
	thick.check();
	in.show();
	out.show();
	in.check();

	Gtext text1;
	text1.init(204,207,"Name:",0,3,1);
	Gtext text2;
	text2.init(283,160,"New Panel",15,3,1);
	text1.show();
	text2.show();

	Line lines[2];
	lines[0].init(188,183,450,183,8,1);
	lines[1].init(450,184,189,184,15,1);
	for(int numlines=0;numlines<2;numlines++)
		lines[numlines].show();

	name.get_form_mouse_input();
	if(name.escapehit()) {
		redraw_screen();
		return;
		}

	while(!ready) {
		if(kbhit()) {
			char ch=getch();
			if(ch==13) {
				ready=1;
				continue;
				}
			if(ch==27) {
				redraw_screen();
				return;
				}
			}
		if(the_mouse.LBP()) {
			if(name.hit()) {
				while(the_mouse.LBP());
				name.get_form_mouse_input();
				}
			if(in.hit()) {
				if(!in.is_checked()) {
					in.check();
					out.uncheck();
					while(the_mouse.LBP());
					}
				}
			if(out.hit()) {
				if(!out.is_checked()) {
					out.check();
					in.uncheck();
					while(the_mouse.LBP());
					}
				}
			if(thick.hit()) {
				if(!thick.is_checked()) {
					thick.check();
					thin.uncheck();
					while(the_mouse.LBP());
					}
				}
			if(thin.hit()) {
				if(!thin.is_checked()) {
					thin.check();
					thick.uncheck();
					while(the_mouse.LBP());
					}
				}
			if(OK.hit()) {
				OK.press();
				while(the_mouse.LBP() && OK.hit());
				OK.show();
				if(OK.hit())
					ready=1;
				box.hide();
				box.elim();
				showmem();
				}
			if(CANCEL.hit()) {
				CANCEL.press();
				while(the_mouse.LBP() && CANCEL.hit());
				CANCEL.show();
				if(CANCEL.hit()) {
					box.hide();
					box.elim();
					showmem();
					redraw_screen();
					return;
					}
				}
			}
		}
	showmem();
	if(panelroot==(panelrec *)NULL) {
		panelroot=new panelrec;
		panelroot->previous=panelroot->next=(panelrec *)NULL;
		panelroot->panel=new Panel;
		currentpanel=panelroot;
		}
	else {
		currentpanel=panelroot;
		while(currentpanel->next!=(panelrec *)NULL)
			currentpanel=currentpanel->next;
		currentpanel->next=new panelrec;
		currentpanel->next->previous=currentpanel;
		currentpanel->next->next=(panelrec *)NULL;
		currentpanel=currentpanel->next;
		currentpanel->panel=new Panel;
		}
	strcpy(currentpanel->name,name.getstring());

	the_mouse.changeto(CROSSHAIR);

	while(!the_mouse.LBP());
	int mx=the_mouse.mx();
	int my=the_mouse.my();
	currentpanel->panel->init(mx,my,20,20,!in.is_checked(),!thick.is_checked(),SAVEBGD);
	currentpanel->panel->show();
	numpanels++;
}

//*********************************************************************
//		PLACE_BEVEL
//*********************************************************************

void place_bevel()
{
	int ready=0;

	Bevel box;
	box.init(173,141,290,152,THICK,SAVEBGD);
	box.setbevelcolor(3);
	box.show();

	Panel panel1;
	panel1.init(192,232,101,48,IN,THIN);
	Panel panel2;
	panel2.init(305,232,137,48,IN,THIN);
	panel1.show();
	panel2.show();

	Button OK;
	OK.init(311,246,"  OK  ",TEXT);
	Button button1;
	button1.init(403,152,"BEVEL",IMAGE);
	Button CANCEL;
	CANCEL.init(379,246,"CANCEL",TEXT);
	OK.show();
	button1.show();
	CANCEL.show();

	Gstring name;
	name.init(267,211,20,0);
	name.show();

	Gradio thick;
	thick.init(208,239,"Thick");
	Gradio thin;
	thin.init(208,262,"Thin");
	thick.show();
	thin.show();
	thick.check();

	Gtext text1;
	text1.init(204,207,"Name:",0,3,1);
	Gtext text2;
	text2.init(283,160,"New Bevel",15,3,1);
	text1.show();
	text2.show();

	Line lines[2];
	lines[0].init(188,183,450,183,8,1);
	lines[1].init(450,184,189,184,15,1);
	for(int numlines=0;numlines<2;numlines++)
		lines[numlines].show();

	while(!ready) {
		name.get_form_mouse_input();
		if(name.escapehit()) {
			redraw_screen();
			return;
			}
		if(the_mouse.LBP()) {
			if(thick.hit()) {
				if(!thick.is_checked()) {
					thick.check();
					thin.uncheck();
					while(the_mouse.LBP());
					}
				}
			if(thin.hit()) {
				if(!thin.is_checked()) {
					thin.check();
					thick.uncheck();
					while(the_mouse.LBP());
					}
				}
			if(OK.hit()) {
				OK.press();
				while(the_mouse.LBP() && OK.hit());
				OK.show();
				if(OK.hit()) {
					box.hide();
					box.elim();
					ready=1;
					}
				}
			if(CANCEL.hit()) {
				CANCEL.press();
				while(the_mouse.LBP() && CANCEL.hit());
				CANCEL.show();
				if(CANCEL.hit()) {
					box.hide();
					box.elim();
					return;
					}
				}
			}
		}
	if(bevelroot==(bevelrec *)NULL) {
		bevelroot=new bevelrec;
		bevelroot->previous=bevelroot->next=(bevelrec *)NULL;
		bevelroot->bevel=new Bevel;
		currentbevel=bevelroot;
		}
	else {
		currentbevel=bevelroot;
		while(currentbevel->next!=(bevelrec *)NULL)
			currentbevel=currentbevel->next;
		currentbevel->next=new bevelrec;
		currentbevel->next->previous=currentbevel;
		currentbevel->next->next=(bevelrec *)NULL;
		currentbevel=currentbevel->next;
		currentbevel->bevel=new Bevel;
		}
	strcpy(currentbevel->name,name.getstring());

	the_mouse.changeto(CROSSHAIR);

	while(!the_mouse.LBP());
	int mx=the_mouse.mx();
	int my=the_mouse.my();
	currentbevel->bevel->init(mx,my,20,20,!thick.is_checked(),SAVEBGD);
	currentbevel->bevel->show();
	numbevels++;
}

//*********************************************************************
//		PLACE_CHECKBOX
//*********************************************************************

void place_checkbox()
{
	int ready=0;

	Bevel box;
	box.init(160,177,318,158,THICK,SAVEBGD);
	box.setbevelcolor(3);
	box.show();

	Panel panel1;
	panel1.init(180,289,279,32,IN,THIN);
	panel1.show();

	Button button1;
	button1.init(442,188,"CHECK",IMAGE);
	Button OK;
	OK.init(217,295,"   OK   ",TEXT);
	Button CANCEL;
	CANCEL.init(350,295," CANCEL ",TEXT);
	button1.show();
	OK.show();
	CANCEL.show();

	Gstring name;
	name.init(288,242,20,0);
	Gstring cont;
	cont.init(288,270,20,0);
	name.show();
	cont.show();

	Gtext text1;
	text1.init(271,195,"New Checkbox",15,3,1);
	Gtext text2;
	text2.init(226,239,"Name:",0,3,1);
	Gtext text3;
	text3.init(195,266,"Contents:",0,3,1);
	text1.show();
	text2.show();
	text3.show();

	Line lines[2];
	lines[0].init(172,218,463,218,8,1);
	lines[1].init(172,219,462,219,15,1);
	for(int numlines=0;numlines<2;numlines++)
		lines[numlines].show();

	name.get_form_mouse_input();
	if(name.escapehit()) {
		redraw_screen();
		return;
		}

	cont.get_form_mouse_input();
	if(cont.escapehit()) {
		redraw_screen();
		return;
		}

	while(!ready) {
		if(the_mouse.LBP()) {
			if(name.hit()) {
				while(the_mouse.LBP());
				name.get_form_mouse_input();
				if(name.escapehit()) {
					redraw_screen();
					return;
					}
				}
			if(cont.hit()) {
				while(the_mouse.LBP());
				cont.get_form_mouse_input();
				if(cont.escapehit()) {
					redraw_screen();
					return;
					}
				}
			if(OK.hit()) {
				OK.press();
				while(the_mouse.LBP() && OK.hit());
				OK.show();
				if(OK.hit()) {
					ready=1;
					box.hide();
					box.elim();
					continue;
					}
				}
			if(CANCEL.hit()) {
				CANCEL.press();
				while(the_mouse.LBP() && CANCEL.hit());
				CANCEL.show();
				if(CANCEL.hit()) {
					box.hide();
					box.elim();
					return;
					}
				}
			}
		}
	if(checkboxroot==(checkboxrec *)NULL) {
		checkboxroot=new checkboxrec;
		checkboxroot->previous=checkboxroot->next=(checkboxrec *)NULL;
		checkboxroot->checkbox=new Gcheckbox;
		currentcheckbox=checkboxroot;
		}
	else {
		currentcheckbox=checkboxroot;
		while(currentcheckbox->next!=(checkboxrec *)NULL)
			currentcheckbox=currentcheckbox->next;
		currentcheckbox->next=new checkboxrec;
		currentcheckbox->next->previous=currentcheckbox;
		currentcheckbox->next->next=(checkboxrec *)NULL;
		currentcheckbox=currentcheckbox->next;
		currentcheckbox->checkbox=new Gcheckbox;
		}

	strcpy(currentcheckbox->name,name.getstring());
	strcpy(currentcheckbox->text,cont.getstring());

	the_mouse.changeto(CROSSHAIR);

	while(!the_mouse.LBP());
	int mx=the_mouse.mx();
	int my=the_mouse.my();
	currentcheckbox->checkbox->init(mx,my,cont.getstring(),SAVEBGD);
	currentcheckbox->checkbox->show();
	numcheckboxes++;
}

//*********************************************************************
//		PLACE_RADIO
//*********************************************************************

void place_radio()
{
	int ready=0;

	Bevel box;
	box.init(160,177,318,158,THICK,SAVEBGD);
	box.setbevelcolor(3);
	box.show();

	Panel panel1;
	panel1.init(180,289,279,32,IN,THIN);
	panel1.show();

	Button button1;
	button1.init(442,188,"RADIO",IMAGE);
	Button OK;
	OK.init(217,295,"   OK   ",TEXT);
	Button CANCEL;
	CANCEL.init(350,295," CANCEL ",TEXT);
	button1.show();
	OK.show();
	CANCEL.show();

	Gstring name;
	name.init(288,242,20,0);
	Gstring cont;
	cont.init(288,270,20,0);
	name.show();
	cont.show();

	Gtext text1;
	text1.init(255,195,"New Radio Button",15,3,1);
	Gtext text2;
	text2.init(226,239,"Name:",0,3,1);
	Gtext text3;
	text3.init(195,266,"Contents:",0,3,1);
	text1.show();
	text2.show();
	text3.show();

	Line lines[2];
	lines[0].init(172,218,463,218,8,1);
	lines[1].init(172,219,462,219,15,1);
	for(int numlines=0;numlines<2;numlines++)
		lines[numlines].show();

	name.get_form_mouse_input();
	if(name.escapehit()) {
		redraw_screen();
		return;
		}
	cont.get_form_mouse_input();
	if(cont.escapehit()) {
		redraw_screen();
		return;
		}

	while(!ready) {
		if(the_mouse.LBP()) {
			if(name.hit()) {
				while(the_mouse.LBP());
				name.get_form_mouse_input();
				if(name.escapehit()) {
					redraw_screen();
					return;
					}
				}
			if(cont.hit()) {
				while(the_mouse.LBP());
				cont.get_form_mouse_input();
				if(cont.escapehit()) {
					redraw_screen();
					return;
					}
				}
			if(OK.hit()) {
				OK.press();
				while(the_mouse.LBP() && OK.hit());
				OK.show();
				if(OK.hit()) {
					ready=1;
					box.hide();
					box.elim();
					continue;
					}
				}
			if(CANCEL.hit()) {
				CANCEL.press();
				while(the_mouse.LBP() && CANCEL.hit());
				CANCEL.show();
				if(CANCEL.hit()) {
					box.hide();
					box.elim();
					return;
					}
				}
			}
		}
	if(radioroot==(radiorec *)NULL) {
		radioroot=new radiorec;
		radioroot->previous=radioroot->next=(radiorec *)NULL;
		radioroot->radio=new Gradio;
		currentradio=radioroot;
		}
	else {
		currentradio=radioroot;
		while(currentradio->next!=(radiorec *)NULL)
			currentradio=currentradio->next;
		currentradio->next=new radiorec;
		currentradio->next->previous=currentradio;
		currentradio->next->next=(radiorec *)NULL;
		currentradio=currentradio->next;
		currentradio->radio=new Gradio;
		}

	strcpy(currentradio->name,name.getstring());
	strcpy(currentradio->text,cont.getstring());

	the_mouse.changeto(CROSSHAIR);

	while(!the_mouse.LBP());
	int mx=the_mouse.mx();
	int my=the_mouse.my();
	currentradio->radio->init(mx,my,cont.getstring(),SAVEBGD);
	currentradio->radio->show();
	numradios++;
}

//*********************************************************************
//		PLACE_ICON
//*********************************************************************

void place_icon()
{
	int ready=0;

	Bevel box;
	box.init(160,177,318,158,THICK,SAVEBGD);
	box.setbevelcolor(3);
	box.show();

	Panel panel1;
	panel1.init(180,289,279,32,IN,THIN);
	panel1.show();

	Button button1;
	button1.init(442,188,"icon",IMAGE);
	Button OK;
	OK.init(217,295,"   OK   ",TEXT);
	Button CANCEL;
	CANCEL.init(350,295," CANCEL ",TEXT);
	button1.show();
	OK.show();
	CANCEL.show();

	Gstring name;
	name.init(288,242,20,0);
	Gstring cont;
	cont.init(288,270,20,0);
	name.show();
	cont.show();

	Gtext text1;
	text1.init(287,195,"New Icon",15,3,1);
	Gtext text2;
	text2.init(226,239,"Name:",0,3,1);
	Gtext text3;
	text3.init(195,266,"Contents:",0,3,1);
	text1.show();
	text2.show();
	text3.show();

	Line lines[2];
	lines[0].init(172,218,463,218,8,1);
	lines[1].init(172,219,462,219,15,1);
	for(int numlines=0;numlines<2;numlines++)
		lines[numlines].show();

	name.get_form_mouse_input();
	if(name.escapehit()) {
		redraw_screen();
		return;
		}
	cont.get_form_mouse_input();
	if(cont.escapehit()) {
		redraw_screen();
		return;
		}

	while(!ready) {
		if(name.hit()) {
			while(the_mouse.LBP());
			name.get_form_mouse_input();
			if(name.escapehit()) {
				redraw_screen();
				return;
				}
			}
		if(cont.hit()) {
			while(the_mouse.LBP());
			cont.get_form_mouse_input();
			if(cont.escapehit()) {
				redraw_screen();
				return;
				}
			}
		if(OK.hit()) {
			OK.press();
			while(the_mouse.LBP() && OK.hit());
			OK.show();
			if(OK.hit()) {
				ready=1;
				box.hide();
				box.elim();
				continue;
				}
			}
		if(CANCEL.hit()) {
			CANCEL.press();
			while(the_mouse.LBP() && CANCEL.hit());
			CANCEL.show();
			if(CANCEL.hit()) {
				box.hide();
				box.elim();
				return;
				}
			}
		}
	if(iconroot==(iconrec *)NULL) {
		iconroot=new iconrec;
		iconroot->previous=iconroot->next=(iconrec *)NULL;
		iconroot->icon=new Icon;
		currenticon=iconroot;
		}
	else {
		currenticon=iconroot;
		while(currenticon->next!=(iconrec *)NULL)
			currenticon=currenticon->next;
		currenticon->next=new iconrec;
		currenticon->next->previous=currenticon;
		currenticon->next->next=(iconrec *)NULL;
		currenticon=currenticon->next;
		currenticon->icon=new Icon;
		}

	strcpy(currenticon->name,name.getstring());
	strcpy(currenticon->filename,cont.getstring());

	the_mouse.changeto(CROSSHAIR);

	while(!the_mouse.LBP());
	int mx=the_mouse.mx();
	int my=the_mouse.my();
	showmem();
	currenticon->icon->init(mx,my,cont.getstring(),SAVEBGD);
	showmem();
	currenticon->icon->
	show();
	numicons++;
}

//*********************************************************************
//		PLACE_STRING
//*********************************************************************

void place_string()
{
	int ready=0;

	Bevel box;
	box.init(169,171,301,167,THICK,SAVEBGD);
	box.setbevelcolor(3);
	box.show();

	Panel panel1;
	panel1.init(347,261,103,60,IN,THIN);
	panel1.show();

	Button button1;
	button1.init(430,184,"gstring",IMAGE);
	Button OK;
	OK.init(370,267,"  OK  ",TEXT);
	Button CANCEL;
	CANCEL.init(371,295,"CANCEL",TEXT);
	button1.show();
	OK.show();
	CANCEL.show();

	Gstring name;
	name.init(283,241,20,0);
	Gstring len;
	len.init(283,268,2,0);
	name.show();
	len.show();

	Gcheckbox upper;
	upper.init(199,300,"Uppercase?");
	upper.setbgd(3);
	upper.show();

	Gtext text1;
	text1.init(275,189,"New Gstring",15,3,1);
	Gtext text2;
	text2.init(213,237,"Name:",0,3,1);
	Gtext text3;
	text3.init(198,265,"Length:",0,3,1);
	text1.show();
	text2.show();
	text3.show();

	Line lines[2];
	lines[0].init(184,216,453,216,8,1);
	lines[1].init(184,217,452,217,15,1);
	for(int numlines=0;numlines<2;numlines++)
		lines[numlines].show();

	name.get_form_mouse_input();
	if(name.escapehit()) {
		redraw_screen();
		return;
		}


	len.get_form_mouse_input();
	if(len.escapehit()) {
		redraw_screen();
		return;
		}


	while(!ready) {
		if(the_mouse.LBP()) {
			if(name.hit()) {
				while(the_mouse.LBP());
				name.get_form_mouse_input();
				}
			if(len.hit()) {
				while(the_mouse.LBP());
				len.get_form_mouse_input();
				}
			if(upper.hit()) {
				if(upper.is_checked())
					upper.uncheck();
				else
					upper.check();
				while(the_mouse.LBP());
				}
			if(OK.hit()) {
				OK.press();
				while(the_mouse.LBP() && OK.hit());
				OK.show();
				if(OK.hit()) {
					box.hide();
					box.elim();
					ready=1;
					}
				}
			if(CANCEL.hit()) {
				CANCEL.press();
				while(the_mouse.LBP() && CANCEL.hit());
				CANCEL.show();
				if(CANCEL.hit()) {
					box.hide();
					box.elim();
					return;
					}
				}
			}
		}
	if(stringroot==(stringrec *)NULL) {
		stringroot=new stringrec;
		stringroot->previous=stringroot->next=(stringrec *)NULL;
		stringroot->string=new Gstring;
		currentstring=stringroot;
		}
	else {
		currentstring=stringroot;
		while(currentstring->next!=(stringrec *)NULL)
			currentstring=currentstring->next;
		currentstring->next=new stringrec;
		currentstring->next->previous=currentstring;
		currentstring->next->next=(stringrec *)NULL;
		currentstring=currentstring->next;
		currentstring->string=new Gstring;
		}

	strcpy(currentstring->name,name.getstring());
	currentstring->length=atoi(len.getstring());

	the_mouse.changeto(CROSSHAIR);

	while(!the_mouse.LBP());
	int mx=the_mouse.mx();
	int my=the_mouse.my();
	currentstring->string->init(mx,my,atoi(len.getstring()),upper.is_checked(),SAVEBGD);
	currentstring->string->show();
	numstrings++;
}

//*********************************************************************
//		PLACE_BUTTON
//*********************************************************************

void place_button()
{
	int ready=0;

	Bevel box;
	box.init(175,148,288,183,THICK,SAVEBGD);
	box.setbevelcolor(3);
	box.show();

	Panel panel1;
	panel1.init(192,266,85,50,IN,THIN);
	Panel panel2;
	panel2.init(294,266,153,50,IN,THIN);
	panel1.show();
	panel2.show();

	Button button1;
	button1.init(424,162,"button",IMAGE);
	Button OK;
	OK.init(305,280,"  OK  ",TEXT);
	Button CANCEL;
	CANCEL.init(378,280,"CANCEL",TEXT);
	button1.show();
	OK.show();
	CANCEL.show();

	Gstring name;
	name.init(281,213,20,0);
	Gstring cont;
	cont.init(281,244,20,0);
	name.show();
	cont.show();

	Gradio text;
	text.init(210,277,"Text");
	Gradio img;
	img.init(210,297,"Image");
	text.show();
	img.show();
	text.check();

	Gtext text1;
	text1.init(279,170,"New Button",15,3,1);
	Gtext text2;
	text2.init(223,210,"Name:",0,3,1);
	Gtext text3;
	text3.init(192,241,"Contents:",0,3,1);
	text1.show();
	text2.show();
	text3.show();

	Line lines[2];
	lines[0].init(189,195,448,195,8,1);
	lines[1].init(189,196,448,196,15,1);
	for(int numlines=0;numlines<2;numlines++)
		lines[numlines].show();

	name.get_form_mouse_input();
	if(name.escapehit()) {
		redraw_screen();
		return;
		}

	cont.get_form_mouse_input();
	if(cont.escapehit()) {
		redraw_screen();
		return;
		}

	while(!ready) {
		if(the_mouse.LBP()) {
			if(name.hit()) {
				while(the_mouse.LBP());
				name.get_form_mouse_input();
				}
			if(cont.hit()) {
				while(the_mouse.LBP());
				cont.get_form_mouse_input();
				}
			if(text.hit()) {
				if(!text.is_checked()) {
					text.check();
					img.uncheck();
					while(the_mouse.LBP());
					}
				}
			if(img.hit()) {
				if(!img.is_checked()) {
					img.check();
					text.uncheck();
					while(the_mouse.LBP());
					}
				}
			if(OK.hit()) {
				OK.press();
				while(the_mouse.LBP() && OK.hit());
				OK.show();
				if(OK.hit()) {
					box.hide();
					box.elim();
					ready=1;
					}
				}
			if(CANCEL.hit()) {
				CANCEL.press();
				while(the_mouse.LBP() && CANCEL.hit());
				CANCEL.show();
				if(CANCEL.hit()) {
					box.hide();
					box.elim();
					return;
					}
				}
			}
		}
	if(buttonroot==(buttonrec *)NULL) {
		buttonroot=new buttonrec;
		buttonroot->previous=buttonroot->next=(buttonrec *)NULL;
		buttonroot->button=new Button;
		currentbutton=buttonroot;
		}
	else {
		currentbutton=buttonroot;
		while(currentbutton->next!=(buttonrec *)NULL)
			currentbutton=currentbutton->next;
		currentbutton->next=new buttonrec;
		currentbutton->next->previous=currentbutton;
		currentbutton->next->next=(buttonrec *)NULL;
		currentbutton=currentbutton->next;
		currentbutton->button=new Button;
		}

	strcpy(currentbutton->name,name.getstring());
	strcpy(currentbutton->text,cont.getstring());

	if(text.is_checked())
		currentbutton->format=TEXT;
	else
		currentbutton->format=IMAGE;

	the_mouse.changeto(CROSSHAIR);

	while(!the_mouse.LBP());
	int mx=the_mouse.mx();
	int my=the_mouse.my();
	if(text.is_checked())
		currentbutton->button->init(mx,my,cont.getstring(),TEXT,SAVEBGD);
	else
		currentbutton->button->init(mx,my,cont.getstring(),IMAGE,SAVEBGD);
	currentbutton->button->show();
	numbuttons++;
}

//*********************************************************************
//		PLACE_LINE
//*********************************************************************

void place_line()
{
	Bevel box;
	Colorbutton cb[16];
	Gradio thick,thin;
	Button OK;
	int ready=0;
	int lastx,lasty,mx,my;
	static int c=1;
	int s,rootx,rooty,endx,endy;
	int i;

	box.init(200,100,202,120,THICK,SAVEBGD);
	box.setbevelcolor(3);
	box.show();
	for(i=0;i<16;i++) {
		cb[i].init((10*i)+220,120,10,10,i);
		cb[i].show(0);
		}
	cb[c].show(15);
	thick.init(280,140,"Thick");
	thick.setbgd(3);
	thin.init(280,160,"Thin");
	thin.setbgd(3);
	thick.show();
	thin.show();
	thick.check();
	OK.init(275,185,"  OK  ",TEXT);
	OK.show();


	while(!ready) {
		if(the_mouse.LBP()) {
			for(i=0;i<16;i++) {
				if(cb[i].hit()) {
					cb[c].show(0);
					cb[i].show(15);
					c=i;
					while(the_mouse.LBP());
					}
				}
			if(thick.hit()) {
				if(!thick.is_checked()) {
					thick.check();
					thin.uncheck();
					}
				}
			if(thin.hit()) {
				if(!thin.is_checked()) {
					thin.check();
					thick.uncheck();
					}
				}
			if(OK.hit()) {
				OK.press();
				while(the_mouse.LBP() && OK.hit());
				OK.show();
				if(OK.hit())
					ready=1;
				}
			}
		}
	while(the_mouse.LBP());

	if(thin.is_checked())
		s=1;
	else
		s=3;

	redraw_screen();
	the_mouse.changeto(DOT);

	while(!the_mouse.LBP());
	mx=lastx=rootx=the_mouse.mx();
	my=lasty=rooty=the_mouse.my();

	setwritemode(XOR_PUT);
	setcolor(15);
	setlinestyle(1,0,s);
	the_mouse.hide();
	line(lastx,lasty,mx,my);
	the_mouse.show();
	while(the_mouse.LBP()) {
		if(the_mouse.mx()!=mx || the_mouse.my()!=my) {
			if(ctrlkey())
				the_mouse.position(the_mouse.mx(),my);
			if(altkey())
				the_mouse.position(mx,the_mouse.my());
			the_mouse.hide();
			line(lastx,lasty,mx,my);
			line(lastx,lasty,the_mouse.mx(),the_mouse.my());
			the_mouse.show();
			mx=the_mouse.mx();
			my=the_mouse.my();
			}
		}
	endx=mx;
	endy=my;
	line_info[numlines].init(rootx,rooty,endx,endy,c,s);
	line_info[numlines].show();
	numlines++;
}

//*********************************************************************
//		PLACE_TEXT
//*********************************************************************

void place_text()
{
	int ready=0;
	Colorbutton fg[16],bg[16];
	static int fgd=0;
	static int bgd=7;

	Bevel box;
	box.init(89,120,461,238,THICK,SAVEBGD);
	box.setbevelcolor(3);
	box.show();

	Panel panel1;
	panel1.init(114,253,106,71,IN,THIN);
	Panel panel2;
	panel2.init(276,302,230,39,IN,THIN);
	panel1.show();
	panel2.show();

	Button button1;
	button1.init(511,133,"text",IMAGE);
	Button OK;
	OK.init(299,312,"   OK   ",TEXT);
	Button CANCEL;
	CANCEL.init(411,312," CANCEL ",TEXT);
	button1.show();
	OK.show();
	CANCEL.show();

	Gstring name;
	name.init(206,189,20,0);
	Gstring cont;
	cont.init(206,218,40,0);
	name.show();
	cont.show();

	Gradio small;
	small.init(130,261,"Small");
	Gradio med;
	med.init(130,283,"Medium");
	Gradio large;
	large.init(130,304,"Large");
	small.show();
	med.show();
	large.show();
	small.check();

	Gtext text1;
	text1.init(283,135,"New Gtext",15,3,1);
	Gtext text2;
	text2.init(148,187,"Name:",0,3,1);
	Gtext text3;
	text3.init(117,215,"Contents:",0,3,1);
	text1.show();
	text2.show();
	text3.show();

	Line lines[2];
	lines[0].init(105,163,531,163,8,1);
	lines[1].init(105,164,531,164,15,1);
	for(int numlines=0;numlines<2;numlines++)
		lines[numlines].show();

	for(int i=0;i<16;i++) {
		fg[i].init((10*i)+315,250,10,10,i);
		fg[i].show(0);
		bg[i].init((10*i)+315,270,10,10,i);
		bg[i].show(0);
		}
	fg[fgd].show(15);
	bg[bgd].show(15);
	setcolor(0);
	gprintxy(285,251,"FGD");
	gprintxy(285,271,"BGD");

	name.get_form_mouse_input();
	if(name.escapehit()) {
		redraw_screen();
		return;
		}

	cont.get_form_mouse_input();
	if(cont.escapehit()) {
		redraw_screen();
		return;
		}

	while(!ready) {
		if(the_mouse.LBP()) {
			for(i=0;i<16;i++) {
				if(fg[i].hit()) {
					fg[fgd].show(0);
					fgd=i;
					fg[fgd].show(15);
					while(the_mouse.LBP());
					}
				if(bg[i].hit()) {
					bg[bgd].show(0);
					bgd=i;
					bg[bgd].show(15);
					while(the_mouse.LBP());
					}
				}
			if(name.hit()) {
				while(the_mouse.LBP());
				name.get_form_mouse_input();
				if(name.escapehit()) {
					redraw_screen;
					return;
					}
				}
			if(cont.hit()) {
				while(the_mouse.LBP());
				cont.get_form_mouse_input();
				if(cont.escapehit()) {
					redraw_screen();
					return;
					}
				}
			if(small.hit()) {
				if(!small.is_checked()) {
					small.check();
					med.uncheck();
					large.uncheck();
					}
				while(the_mouse.LBP());
				}
			if(med.hit()) {
				if(!med.is_checked()) {
					med.check();
					small.uncheck();
					large.uncheck();
					}
				while(the_mouse.LBP());
				}
			if(large.hit()) {
				if(!large.is_checked()) {
					large.check();
					small.uncheck();
					med.uncheck();
					}
				while(the_mouse.LBP());
				}
			if(OK.hit()) {
				OK.press();
				while(the_mouse.LBP() && OK.hit());
				OK.show();
				if(OK.hit()) {
					ready=1;
					box.hide();
					box.elim();
					continue;
					}
				}
			if(CANCEL.hit()) {
				CANCEL.press();
				while(the_mouse.LBP() && CANCEL.hit());
				CANCEL.show();
				if(CANCEL.hit()) {
					box.hide();
					box.elim();
					return;
					}
				}
			}
		}
	if(textroot==(textrec *)NULL) {
		textroot=new textrec;
		textroot->previous=textroot->next=(textrec *)NULL;
		textroot->text=new Gtext;
		currenttext=textroot;
		}
	else {
		currenttext=textroot;
		while(currenttext->next!=(textrec *)NULL)
			currenttext=currenttext->next;
		currenttext->next=new textrec;
		currenttext->next->previous=currenttext;
		currenttext->next->next=(textrec *)NULL;
		currenttext=currenttext->next;
		currenttext->text=new Gtext;
		}

	strcpy(currenttext->name,name.getstring());
	strcpy(currenttext->txt,cont.getstring());

	if(small.is_checked())
		currenttext->sz=1;
	else
	if(med.is_checked())
		currenttext->sz=2;
	else
	if(large.is_checked())
		currenttext->sz=3;

	the_mouse.changeto(CROSSHAIR);

	while(!the_mouse.LBP());
	int mx=the_mouse.mx();
	int my=the_mouse.my();
	currenttext->text->init(mx,my,cont.getstring(),fgd,bgd,currenttext->sz,SAVEBGD);
	currenttext->text->show();
	numtexts++;
}
