#include "d:\gui\gui.h"
#include "workshop.h"
#include <conio.h>
#include <stdlib.h>

//*************************************************************************
//		FUNCTION PROTOTYPES
//*************************************************************************

int modify_panel(panelrec *);
int modify_bevel(bevelrec *);
int modify_checkbox(checkboxrec *);
int modify_radio(radiorec *);
int modify_icon(iconrec *);
int modify_string(stringrec *);
int modify_button(buttonrec *);
int modify_text(textrec *);

extern redraw_screen();
extern showmem();

//*************************************************************************
//		GLOBAL VARIABLES
//*************************************************************************

extern panelrec *panelroot;
extern panelrec *currentpanel;
extern int numpanels;

extern bevelrec *bevelroot;
extern bevelrec *currentbevel;
extern int numbevels;

extern checkboxrec *checkboxroot;
extern checkboxrec *currentcheckbox;
extern int numcheckboxes;

extern radiorec *radioroot;
extern radiorec *currentradio;
extern int numradios;

extern iconrec *iconroot;
extern iconrec *currenticon;
extern int numicons;

extern stringrec *stringroot;
extern stringrec *curentstring;
extern int numstrings;

extern buttonrec *buttonroot;
extern buttonrec *currentbutton;
extern int numbuttons;

extern Line line_info[100];
extern int numlines;

extern textrec *textroot;
extern textrec *currenttext;
extern numtexts;

extern Mcursor the_mouse;

//*************************************************************************
//		MODIFY_PANEL
//*************************************************************************

int modify_panel(panelrec *the_panelrec)
{
	char ULX[4],ULY[4],W[4],H[4];
	int ready=0;

//*****   INITIALIZE THE DIALOG BOX   *****

	the_mouse.changeto(ARROW);
	Bevel box;
	box.init(128,117,343,247,THICK);
	box.show();

	Panel panel1;
	panel1.init(154,229,87,54,IN,THIN);
	Panel panel2;
	panel2.init(258,229,192,54,IN,THIN);
	Panel panel3;
	panel3.init(258,293,192,53,IN,THIN);
	Panel panel4;
	panel4.init(154,293,87,52,IN,THIN);
	panel1.show();
	panel2.show();
	panel3.show();
	panel4.show();

	Button button1;
	button1.init(429,129,"panel",IMAGE);
	Button OK;
	OK.init(275,309,"   OK   ",TEXT);
	Button CANCEL;
	CANCEL.init(361,309," CANCEL ",TEXT);
	button1.show();
	OK.show();
	CANCEL.show();

	Gstring name;
	name.init(219,152,20,0);
	name.preset(the_panelrec->name);
	Gstring ulx;
	ulx.init(219,181,3,1);
	itoa(the_panelrec->panel->Getx(),ULX,10);
	ulx.preset(ULX);
	Gstring uly;
	uly.init(219,209,3,1);
	itoa(the_panelrec->panel->Gety(),ULY,10);
	uly.preset(ULY);
	Gstring wd;
	wd.init(340,181,3,1);
	itoa(the_panelrec->panel->Getw(),W,10);
	wd.preset(W);
	Gstring ht;
	ht.init(340,209,3,1);
	itoa(the_panelrec->panel->Geth(),H,10);
	ht.preset(H);
	name.show();
	ulx.show();
	uly.show();
	wd.show();
	ht.show();

	Gradio thick;
	thick.init(163,240,"Thick");
	Gradio thin;
	thin.init(163,260,"Thin");
	Gradio in;
	in.init(163,304,"In");
	Gradio out;
	out.init(163,325,"Out");
	thick.show();
	thin.show();
	in.show();
	out.show();
	if(!the_panelrec->panel->Getthick())
		thick.check();
	else
		thin.check();
	if(!the_panelrec->panel->Getin())
		in.check();
	else
		out.check();

	Gcheckbox cv;
	cv.init(268,240,"Center Vertically");
	Gcheckbox ch;
	ch.init(268,260,"Center Horizontally");
	cv.show();
	ch.show();

	Gtext text1;
	text1.init(161,148,"Name:",0,7,1);
	Gtext text2;
	text2.init(168,176,"ULX:",0,7,1);
	Gtext text3;
	text3.init(168,205,"ULY:",0,7,1);
	Gtext text4;
	text4.init(280,175,"Width:",0,7,1);
	Gtext text5;
	text5.init(273,204,"Height:",0,7,1);
	text1.show();
	text2.show();
	text3.show();
	text4.show();
	text5.show();

//*****   INPUT LOOP   *****

	name.get_form_mouse_input();
	while(!ready) {
		if(the_mouse.LBP()) {
			if(name.hit()) {
				while(the_mouse.LBP());
				name.get_form_mouse_input();
				}
			if(ulx.hit()) {
				while(the_mouse.LBP());
				ulx.get_form_mouse_input();
				}
			if(uly.hit()) {
				while(the_mouse.LBP());
				uly.get_form_mouse_input();
				}
			if(wd.hit()) {
				while(the_mouse.LBP());
				wd.get_form_mouse_input();
				}
			if(ht.hit()) {
				while(the_mouse.LBP());
				ht.get_form_mouse_input();
				}
			if(thick.hit()) {
				if(!thick.is_checked()) {
					thick.check();
					thin.uncheck();
					}
				while(the_mouse.LBP());
				}
			if(thin.hit()) {
				if(!thin.is_checked()) {
					thin.check();
					thick.uncheck();
					}
				while(the_mouse.LBP());
				}
			if(in.hit()) {
				if(!in.is_checked()) {
					in.check();
					out.uncheck();
					}
				while(the_mouse.LBP());
				}
			if(out.hit()) {
				if(!out.is_checked()) {
					out.check();
					in.uncheck();
					}
				while(the_mouse.LBP());
				}
			if(cv.hit()) {
				if(cv.is_checked())
					cv.uncheck();
				else
					cv.check();
				while(the_mouse.LBP());
				}
			if(ch.hit()) {
				if(ch.is_checked())
					ch.uncheck();
				else
					ch.check();
				while(the_mouse.LBP());
				}
			if(OK.hit()) {
				OK.press();
				while(OK.hit() && the_mouse.LBP());
				OK.show();
				if((atoi(wd.getstring())<5) ||
				   (atoi(ht.getstring())<5)) {
					beep();
					continue;
					}
				if(OK.hit())
					ready=1;
				}
			if(CANCEL.hit()) {
				CANCEL.press();
				while(CANCEL.hit() && the_mouse.LBP());
				CANCEL.show();
				if(CANCEL.hit()) {
					redraw_screen();
					return 0;
					}
				}
			}//if LBP
		}//while !ready

	strcpy(the_panelrec->name,name.getstring());
	int newulx=atoi(ulx.getstring());
	int newuly=atoi(uly.getstring());
	int neww=atoi(wd.getstring());
	int newh=atoi(ht.getstring());
	int newthickorthin=thin.is_checked();
	int newinorout=out.is_checked();
	if(cv.is_checked())
		newuly=((getmaxy()/2)-(newh/2));
	if(ch.is_checked())
		newulx=((getmaxx()/2)-(neww/2));

	the_panelrec->panel->reinit(newulx,newuly,neww,newh,newinorout,newthickorthin);

	redraw_screen();
	return 1;
}

//*************************************************************************
//		MODIFY_BEVEL
//*************************************************************************

int modify_bevel(bevelrec *the_bevelrec)
{
	char ULX[4],ULY[4],W[4],H[4];
	int ready=0;

//*****   INITIALIZE THE DIALOG BOX   *****

	the_mouse.changeto(ARROW);
	Bevel box;
	box.init(128,117,344,231,THICK);
	box.show();

	Panel panel1;
	panel1.init(154,229,87,54,IN,THIN);
	Panel panel2;
	panel2.init(258,229,192,54,IN,THIN);
	Panel panel3;
	panel3.init(154,293,297,40,IN,THIN);
	panel1.show();
	panel2.show();
	panel3.show();

	Button button1;
	button1.init(429,129,"bevel",IMAGE);
	Button OK;
	OK.init(200,305,"   OK   ",TEXT);
	Button CANCEL;
	CANCEL.init(329,305," CANCEL ",TEXT);
	button1.show();
	OK.show();
	CANCEL.show();

	Gstring name;
	name.init(219,152,20,0);
	name.preset(the_bevelrec->name);
	Gstring ulx;
	ulx.init(219,181,3,1);
	itoa(the_bevelrec->bevel->Getx(),ULX,10);
	ulx.preset(ULX);
	Gstring uly;
	uly.init(219,209,3,1);
	itoa(the_bevelrec->bevel->Gety(),ULY,10);
	uly.preset(ULY);
	Gstring wd;
	wd.init(340,181,3,1);
	itoa(the_bevelrec->bevel->Getw(),W,10);
	wd.preset(W);
	Gstring ht;
	ht.init(340,209,3,1);
	itoa(the_bevelrec->bevel->Geth(),H,10);
	ht.preset(H);
	name.show();
	ulx.show();
	uly.show();
	wd.show();
	ht.show();

	Gradio thick;
	thick.init(163,240,"Thick");
	Gradio thin;
	thin.init(163,260,"Thin");
	thick.show();
	thin.show();
	if(!the_bevelrec->bevel->Getthick())
		thick.check();
	else
		thin.check();

	Gcheckbox cv;
	cv.init(268,240,"Center Vertically");
	Gcheckbox ch;
	ch.init(268,260,"Center Horizontally");
	cv.show();
	ch.show();

	Gtext text1;
	text1.init(161,148,"Name:",0,7,1);
	Gtext text2;
	text2.init(168,176,"ULX:",0,7,1);
	Gtext text3;
	text3.init(168,205,"ULY:",0,7,1);
	Gtext text4;
	text4.init(280,175,"Width:",0,7,1);
	Gtext text5;
	text5.init(273,204,"Height:",0,7,1);
	text1.show();
	text2.show();
	text3.show();
	text4.show();
	text5.show();

//*****   INPUT LOOP   *****

	name.get_form_mouse_input();
	while(!ready) {
		if(the_mouse.LBP()) {
			if(name.hit()) {
				while(the_mouse.LBP());
				name.get_form_mouse_input();
				}
			if(ulx.hit()) {
				while(the_mouse.LBP());
				ulx.get_form_mouse_input();
				}
			if(uly.hit()) {
				while(the_mouse.LBP());
				uly.get_form_mouse_input();
				}
			if(wd.hit()) {
				while(the_mouse.LBP());
				wd.get_form_mouse_input();
				}
			if(ht.hit()) {
				while(the_mouse.LBP());
				ht.get_form_mouse_input();
				}
			if(thick.hit()) {
				if(!thick.is_checked()) {
					thick.check();
					thin.uncheck();
					}
				while(the_mouse.LBP());
				}
			if(thin.hit()) {
				if(!thin.is_checked()) {
					thin.check();
					thick.uncheck();
					}
				while(the_mouse.LBP());
				}
			if(cv.hit()) {
				if(cv.is_checked())
					cv.uncheck();
				else
					cv.check();
				while(the_mouse.LBP());
				}
			if(ch.hit()) {
				if(ch.is_checked())
					ch.uncheck();
				else
					ch.check();
				while(the_mouse.LBP());
				}
			if(OK.hit()) {
				OK.press();
				while(OK.hit() && the_mouse.LBP());
				OK.show();
				if((atoi(wd.getstring())<5) ||
				   (atoi(ht.getstring())<5)) {
					beep();
					continue;
					}
				if(OK.hit())
					ready=1;
				}
			if(CANCEL.hit()) {
				CANCEL.press();
				while(CANCEL.hit() && the_mouse.LBP());
				CANCEL.show();
				if(CANCEL.hit()) {
					redraw_screen();
					return 0;
					}
				}
			}//if LBP
		}//while !ready

	strcpy(the_bevelrec->name,name.getstring());
	int newulx=atoi(ulx.getstring());
	int newuly=atoi(uly.getstring());
	int neww=atoi(wd.getstring());
	int newh=atoi(ht.getstring());
	int newthickorthin=thin.is_checked();
	if(cv.is_checked())
		newuly=((getmaxy()/2)-(newh/2));
	if(ch.is_checked())
		newulx=((getmaxx()/2)-(neww/2));

	the_bevelrec->bevel->reinit(newulx,newuly,neww,newh,newthickorthin);

	redraw_screen();
	return 1;
}

//*************************************************************************
//		MODIFY_CHECKBOX
//*************************************************************************

int modify_checkbox(checkboxrec * the_checkboxrec)
{
	char ULX[4],ULY[4],T[20];
	int ready=0;

//*****   INITIALIZE THE DIALOG BOX   *****

	the_mouse.changeto(ARROW);
	Bevel box;
	box.init(140,148,358,160,THICK);
	box.show();

	Panel panel1;
	panel1.init(156,256,327,37,IN,THIN);
	panel1.show();

	Button button1;
	button1.init(460,163,"check",IMAGE);
	Button OK;
	OK.init(224,265,"   OK   ",TEXT);
	Button CANCEL;
	CANCEL.init(342,265," CANCEL ",TEXT);
	button1.show();
	OK.show();
	CANCEL.show();

	Gstring name;
	name.init(245,174,20,1);
	name.preset(the_checkboxrec->name);
	Gstring cont;
	cont.init(245,202,20,1);
	cont.preset(the_checkboxrec->checkbox->Gettext());
	Gstring ulx;
	ulx.init(245,232,3,0);
	itoa(the_checkboxrec->checkbox->Getx(),ULX,10);
	ulx.preset(ULX);
	Gstring uly;
	uly.init(375,233,3,1);
	itoa(the_checkboxrec->checkbox->Gety(),ULY,10);
	uly.preset(ULY);
	name.show();
	cont.show();
	ulx.show();
	uly.show();

	Gtext text1;
	text1.init(185,171,"Name:",0,7,1);
	Gtext text2;
	text2.init(152,199,"Contents:",0,7,1);
	Gtext text3;
	text3.init(192,230,"ULX:",0,7,1);
	Gtext text4;
	text4.init(325,230,"ULY:",0,7,1);
	text1.show();
	text2.show();
	text3.show();
	text4.show();

//*****   INPUT LOOP   *****

	name.get_form_mouse_input();
	while(!ready) {
		if(the_mouse.LBP()) {
			if(name.hit()) {
				while(the_mouse.LBP());
				name.get_form_mouse_input();
				}
			if(ulx.hit()) {
				while(the_mouse.LBP());
				ulx.get_form_mouse_input();
				}
			if(uly.hit()) {
				while(the_mouse.LBP());
				uly.get_form_mouse_input();
				}
			if(cont.hit()) {
				while(the_mouse.LBP());
				cont.get_form_mouse_input();
				}
			if(OK.hit()) {
				OK.press();
				while(OK.hit() && the_mouse.LBP());
				OK.show();
				if(OK.hit())
					ready=1;
				}
			if(CANCEL.hit()) {
				CANCEL.press();
				while(CANCEL.hit() && the_mouse.LBP());
				CANCEL.show();
				if(CANCEL.hit()) {
					redraw_screen();
					return 0;
					}
				}
			}//if LBP
		}//while !ready

	strcpy(the_checkboxrec->name,name.getstring());
	int newulx=atoi(ulx.getstring());
	int newuly=atoi(uly.getstring());
	char * newtext=cont.getstring();
	the_checkboxrec->checkbox->reinit(newulx,newuly,newtext);

	redraw_screen();
	return 1;
}

//*************************************************************************
//		MODIFY_RADIO
//*************************************************************************

int modify_radio(radiorec *the_radiorec)
{
	char ULX[4],ULY[4],T[20];
	int ready=0;

//*****   INITIALIZE THE DIALOG BOX   *****

	the_mouse.changeto(ARROW);
	Bevel box;
	box.init(140,148,358,160,THICK);
	box.show();

	Panel panel1;
	panel1.init(156,256,327,37,IN,THIN);
	panel1.show();

	Button button1;
	button1.init(460,163,"radio",IMAGE);
	Button OK;
	OK.init(224,265,"   OK   ",TEXT);
	Button CANCEL;
	CANCEL.init(342,265," CANCEL ",TEXT);
	button1.show();
	OK.show();
	CANCEL.show();

	Gstring name;
	name.init(245,174,20,1);
	name.preset(the_radiorec->name);
	Gstring cont;
	cont.init(245,202,20,1);
	cont.preset(the_radiorec->radio->Gettext());
	Gstring ulx;
	ulx.init(245,232,3,0);
	itoa(the_radiorec->radio->Getx(),ULX,10);
	ulx.preset(ULX);
	Gstring uly;
	uly.init(375,233,3,1);
	itoa(the_radiorec->radio->Gety(),ULY,10);
	uly.preset(ULY);
	name.show();
	cont.show();
	ulx.show();
	uly.show();

	Gtext text1;
	text1.init(185,171,"Name:",0,7,1);
	Gtext text2;
	text2.init(152,199,"Contents:",0,7,1);
	Gtext text3;
	text3.init(192,230,"ULX:",0,7,1);
	Gtext text4;
	text4.init(325,230,"ULY:",0,7,1);
	text1.show();
	text2.show();
	text3.show();
	text4.show();

//*****   INPUT LOOP   *****

	name.get_form_mouse_input();
	while(!ready) {
		if(the_mouse.LBP()) {
			if(name.hit()) {
				while(the_mouse.LBP());
				name.get_form_mouse_input();
				}
			if(ulx.hit()) {
				while(the_mouse.LBP());
				ulx.get_form_mouse_input();
				}
			if(uly.hit()) {
				while(the_mouse.LBP());
				uly.get_form_mouse_input();
				}
			if(cont.hit()) {
				while(the_mouse.LBP());
				cont.get_form_mouse_input();
				}
			if(OK.hit()) {
				OK.press();
				while(OK.hit() && the_mouse.LBP());
				OK.show();
				if(OK.hit())
					ready=1;
				}
			if(CANCEL.hit()) {
				CANCEL.press();
				while(CANCEL.hit() && the_mouse.LBP());
				CANCEL.show();
				if(CANCEL.hit()) {
					redraw_screen();
					return 0;
					}
				}
			}//if LBP
		}//while !ready

	strcpy(the_radiorec->name,name.getstring());
	int newulx=atoi(ulx.getstring());
	int newuly=atoi(uly.getstring());
	char * newtext=cont.getstring();

	the_radiorec->radio->reinit(newulx,newuly,newtext);

	redraw_screen();
	return 1;
}

//*************************************************************************
//		MODIFY_ICON
//*************************************************************************

int modify_icon(iconrec *the_iconrec)
{
	char ULX[4],ULY[4],T[20];
	int ready=0;

//*****   INITIALIZE THE DIALOG BOX   *****

	the_mouse.changeto(ARROW);
	Bevel box;
	box.init(128,90,342,215,THICK);
	box.show();

	Panel panel2;
	panel2.init(258,172,192,54,IN,THIN);
	Panel panel3;
	panel3.init(153,239,297,50,IN,THIN);
	panel2.show();
	panel3.show();

	Button button1;
	button1.init(431,104,"icon",IMAGE);
	Button OK;
	OK.init(209,253,"   OK   ",TEXT);
	Button CANCEL;
	CANCEL.init(318,253," CANCEL ",TEXT);
	button1.show();
	OK.show();
	CANCEL.show();

	Gstring name;
	name.init(203,118,20,1);
	name.preset(the_iconrec->name);
	Gstring ulx;
	ulx.init(203,181,3,0);
	itoa(the_iconrec->icon->Getx(),ULX,10);
	ulx.preset(ULX);
	Gstring uly;
	uly.init(203,217,3,0);
	itoa(the_iconrec->icon->Gety(),ULY,10);
	uly.preset(ULY);
	Gstring cont;
	cont.init(203,149,20,1);
	char filename[13];
	strcpy(filename,the_iconrec->icon->Getfilename());
	cont.preset(filename);
	name.show();
	ulx.show();
	uly.show();
	cont.show();

	Gcheckbox cv;
	cv.init(268,182,"Center Vertically");
	Gcheckbox ch;
	ch.init(268,203,"Center Horizontally");
	cv.show();
	ch.show();

	Gtext text1;
	text1.init(146,117,"Name:",0,7,1);
	Gtext text2;
	text2.init(155,179,"ULX:",0,7,1);
	Gtext text3;
	text3.init(155,215,"ULY:",0,7,1);
	Gtext text6;
	text6.init(146,146,"Cont:",0,7,1);
	text1.show();
	text2.show();
	text3.show();
	text6.show();

//*****   INPUT LOOP   *****

	name.get_form_mouse_input();
	while(!ready) {
		if(the_mouse.LBP()) {
			if(name.hit()) {
				while(the_mouse.LBP());
				name.get_form_mouse_input();
				}
			if(ulx.hit()) {
				while(the_mouse.LBP());
				ulx.get_form_mouse_input();
				}
			if(uly.hit()) {
				while(the_mouse.LBP());
				uly.get_form_mouse_input();
				}
			if(cont.hit()) {
				while(the_mouse.LBP());
				cont.get_form_mouse_input();
				}
			if(cv.hit()) {
				if(cv.is_checked())
					cv.uncheck();
				else
					cv.check();
				while(the_mouse.LBP());
				}
			if(ch.hit()) {
				if(ch.is_checked())
					ch.uncheck();
				else
					ch.check();
				while(the_mouse.LBP());
				}
			if(OK.hit()) {
				OK.press();
				while(OK.hit() && the_mouse.LBP());
				OK.show();
				if(OK.hit())
					ready=1;
				}
			if(CANCEL.hit()) {
				CANCEL.press();
				while(CANCEL.hit() && the_mouse.LBP());
				CANCEL.show();
				if(CANCEL.hit()) {
					redraw_screen();
					return 0;
					}
				}
			}//if LBP
		}//while !ready

	strcpy(the_iconrec->name,name.getstring());
	int newulx=atoi(ulx.getstring());
	int newuly=atoi(uly.getstring());
	char * newtext=cont.getstring();
	if(cv.is_checked())
		newuly=((getmaxy()/2)-(the_iconrec->icon->Getw()/2));
	if(ch.is_checked())
		newulx=((getmaxx()/2)-(the_iconrec->icon->Geth()/2));

	the_iconrec->icon->reinit(newulx,newuly,newtext);

	redraw_screen();
	return 1;
}

//*************************************************************************
//		MODIFY_STRING
//*************************************************************************

int modify_string(stringrec *the_stringrec)
{
	char ULX[4],ULY[4],T[20];
	int ready=0;

//*****   INITIALIZE THE DIALOG BOX   *****

	the_mouse.changeto(ARROW);
	Bevel box;
	box.init(140,148,358,160,THICK);
	box.show();

	Panel panel1;
	panel1.init(156,256,327,37,IN,THIN);
	panel1.show();

	Button button1;
	button1.init(460,163,"gstring",IMAGE);
	Button OK;
	OK.init(303,265,"   OK   ",TEXT);
	Button CANCEL;
	CANCEL.init(393,265," CANCEL ",TEXT);
	button1.show();
	OK.show();
	CANCEL.show();

	Gstring name;
	name.init(245,174,20,1);
	name.preset(the_stringrec->name);
	Gstring len;
	len.init(245,202,2,0);
	char L[3];
	itoa(the_stringrec->string->Getlength(),L,10);
	len.preset(L);
	Gstring ulx;
	ulx.init(245,232,3,0);
	itoa(the_stringrec->string->Getx(),ULX,10);
	ulx.preset(ULX);
	Gstring uly;
	uly.init(375,233,3,1);
	itoa(the_stringrec->string->Gety(),ULY,10);
	uly.preset(ULY);
	name.show();
	len.show();
	ulx.show();
	uly.show();

	Gcheckbox uc;
	uc.init(167,269,"Uppercase");
	uc.show();
	if(the_stringrec->string->is_ucase())
		uc.check();

	Gtext text1;
	text1.init(185,171,"Name:",0,7,1);
	Gtext text2;
	text2.init(169,199,"Length:",0,7,1);
	Gtext text3;
	text3.init(192,230,"ULX:",0,7,1);
	Gtext text4;
	text4.init(325,230,"ULY:",0,7,1);
	text1.show();
	text2.show();
	text3.show();
	text4.show();

//*****   INPUT LOOP   *****

	name.get_form_mouse_input();
	while(!ready) {
		if(the_mouse.LBP()) {
			if(name.hit()) {
				while(the_mouse.LBP());
				name.get_form_mouse_input();
				}
			if(ulx.hit()) {
				while(the_mouse.LBP());
				ulx.get_form_mouse_input();
				}
			if(uly.hit()) {
				while(the_mouse.LBP());
				uly.get_form_mouse_input();
				}
			if(len.hit()) {
				while(the_mouse.LBP());
				len.get_form_mouse_input();
				}
			if(uc.hit()) {
				if(uc.is_checked())
					uc.uncheck();
				else
					uc.check();
				while(the_mouse.LBP());
				}
			if(OK.hit()) {
				OK.press();
				while(OK.hit() && the_mouse.LBP());
				OK.show();
				if(OK.hit())
					ready=1;
				}
			if(CANCEL.hit()) {
				CANCEL.press();
				while(CANCEL.hit() && the_mouse.LBP());
				CANCEL.show();
				if(CANCEL.hit()) {
					redraw_screen();
					return 0;
					}
				}
			}//if LBP
		}//while !ready

	strcpy(the_stringrec->name,name.getstring());
	int newulx=atoi(ulx.getstring());
	int newuly=atoi(uly.getstring());
	int newlen=atoi(len.getstring());

	the_stringrec->string->reinit(newulx,newuly,newlen,uc.is_checked());

	redraw_screen();
	return 1;
}

//*************************************************************************
//		MODIFY_BUTTON
//*************************************************************************

int modify_button(buttonrec *the_buttonrec)
{
	char ULX[4],ULY[4],T[20];
	int ready=0;

//*****   INITIALIZE THE DIALOG BOX   *****

	the_mouse.changeto(ARROW);
	Bevel box;
	box.init(128,90,345,228,THICK,SAVEBGD);
	box.show();

	Panel panel1;
	panel1.init(154,239,82,49,IN,THIN);
	Panel panel2;
	panel2.init(258,172,192,54,IN,THIN);
	Panel panel3;
	panel3.init(258,239,193,49,IN,THIN);
	panel1.show();
	panel2.show();
	panel3.show();

	Button button1;
	button1.init(431,104,"button",IMAGE);
	Button OK;
	OK.init(274,253,"   OK   ",TEXT);
	Button CANCEL;
	CANCEL.init(360,253," CANCEL ",TEXT);
	button1.show();
	OK.show();
	CANCEL.show();

	Gstring name;
	name.init(203,118,20,1);
	name.preset(the_buttonrec->name);
	Gstring ulx;
	ulx.init(203,181,3,0);
	itoa(the_buttonrec->button->Getx(),ULX,10);
	ulx.preset(ULX);
	Gstring uly;
	uly.init(203,217,3,0);
	itoa(the_buttonrec->button->Gety(),ULY,10);
	uly.preset(ULY);
	Gstring cont;
	cont.init(203,149,20,1);
	cont.preset(the_buttonrec->button->Getcontents());
	name.show();
	ulx.show();
	uly.show();
	cont.show();

	Gradio text;
	text.init(163,247,"Text");
	Gradio img;
	img.init(163,267,"Image");
	text.show();
	img.show();
	if(the_buttonrec->button->Getformat()==TEXT)
		text.check();
	else
		img.check();

	Gcheckbox cv;
	cv.init(268,182,"Center Vertically");
	Gcheckbox ch;
	ch.init(268,203,"Center Horizontally");
	cv.show();
	ch.show();

	Gtext text1;
	text1.init(146,117,"Name:",0,7,1);
	Gtext text2;
	text2.init(155,179,"ULX:",0,7,1);
	Gtext text3;
	text3.init(155,215,"ULY:",0,7,1);
	Gtext text6;
	text6.init(146,146,"Cont:",0,7,1);
	text1.show();
	text2.show();
	text3.show();
	text6.show();

//*****   INPUT LOOP   *****

	name.get_form_mouse_input();
	while(!ready) {
		if(the_mouse.LBP()) {
			if(name.hit()) {
				while(the_mouse.LBP());
				name.get_form_mouse_input();
				}
			if(ulx.hit()) {
				while(the_mouse.LBP());
				ulx.get_form_mouse_input();
				}
			if(uly.hit()) {
				while(the_mouse.LBP());
				uly.get_form_mouse_input();
				}
			if(cont.hit()) {
				while(the_mouse.LBP());
				cont.get_form_mouse_input();
				}
			if(cv.hit()) {
				if(cv.is_checked())
					cv.uncheck();
				else
					cv.check();
				while(the_mouse.LBP());
				}
			if(ch.hit()) {
				if(ch.is_checked())
					ch.uncheck();
				else
					ch.check();
				while(the_mouse.LBP());
				}
			if(text.hit()) {
				if(!text.is_checked()) {
					text.check();
					img.uncheck();
					}
				while(the_mouse.LBP());
				}
			if(img.hit()) {
				if(!img.is_checked()) {
					img.check();
					text.uncheck();
					}
				while(the_mouse.LBP());
				}
			if(OK.hit()) {
				OK.press();
				while(OK.hit() && the_mouse.LBP());
				OK.show();
				if(OK.hit()) {
					box.hide();
					box.elim();
					ready=1;
					}
				}
			if(CANCEL.hit()) {
				CANCEL.press();
				while(CANCEL.hit() && the_mouse.LBP());
				CANCEL.show();
				if(CANCEL.hit()) {
					box.hide();
					box.elim();
					return 0;
					}
				}
			}//if LBP
		}//while !ready

	strcpy(the_buttonrec->name,name.getstring());
	int newulx=atoi(ulx.getstring());
	int newuly=atoi(uly.getstring());
	char * newtext=cont.getstring();
	if(cv.is_checked())
		newuly=((getmaxy()/2)-(the_buttonrec->button->Geth()/2));
	if(ch.is_checked())
		newulx=((getmaxx()/2)-(the_buttonrec->button->Getw()/2));

	the_buttonrec->button->reinit(newulx,newuly,newtext,img.is_checked());
	redraw_screen();
	return 1;
}

//**************************************************************************
//		MODIFY_TEXT
//**************************************************************************

int modify_text(textrec *the_textrec)
{
	char ULX[4],ULY[4],T[20];
	int fgd,bgd;
	int size;
	int ready=0;
	Colorbutton fg[16],bg[16];

//*****   INITIALIZE THE DIALOG BOX   *****

	the_mouse.changeto(ARROW);

	Bevel box;
	box.init(115,141,471,279,THICK);
	box.show();

	Panel panel1;
	panel1.init(137,339,187,61,IN,THIN);
	Panel panel2;
	panel2.init(137,248,104,80,IN,THIN);
	Panel panel3;
	panel3.init(348,339,213,63,IN,THIN);
	Panel panel4;
	panel4.init(250,248,312,80,IN,THIN);
	panel1.show();
	panel2.show();
	panel3.show();
	panel4.show();

	Button OK;
	OK.init(368,360,"   OK   ",TEXT);
	Button CANCEL;
	CANCEL.init(462,359," CANCEL ",TEXT);
	Button textbutton;
	textbutton.init(551,152,"text",IMAGE);
	OK.show();
	CANCEL.show();
	textbutton.show();

	Gstring name;
	name.init(227,167,20,0);
	name.preset(the_textrec->name);
	Gstring cont;
	cont.init(227,197,40,0);
	cont.preset(the_textrec->text->Gettext());
	Gstring ulx;
	ulx.init(227,227,3,0);
	itoa(the_textrec->text->Getx(),ULX,10);
		ulx.preset(ULX);
	Gstring uly;
	uly.init(338,227,3,0);
	itoa(the_textrec->text->Gety(),ULY,10);
	uly.preset(ULY);
	name.show();
	cont.show();
	ulx.show();
	uly.show();

	Gradio small;
	small.init(152,261,"Small");
	Gradio med;
	med.init(152,282,"Medium");
	Gradio large;
	large.init(152,303,"Large");
	small.show();
	med.show();
	large.show();
	size=the_textrec->text->Getsize();
	switch(size) {
		case 1: small.check();
				break;
		case 2: med.check();
				break;
		case 3: large.check();
		}

	Gcheckbox cv;
	cv.init(143,377,"Center Vertically");
	Gcheckbox ch;
	ch.init(143,350,"Center Horizontally");
	cv.show();
	ch.show();

	Gtext text1;
	text1.init(168,164,"Name:",0,7,1);
	Gtext text2;
	text2.init(136,194,"Contents:",0,7,1);
	Gtext text3;
	text3.init(176,224,"ULX:",0,7,1);
	Gtext text4;
	text4.init(290,224,"ULY:",0,7,1);
	text1.show();
	text2.show();
	text3.show();
	text4.show();

	setcolor(0);
	settextjustify(LEFT_TEXT,TOP_TEXT);
	settextstyle(0,0,1);
	gprintxy(265,268,"Foreground:");
	gprintxy(265,298,"Background:");

	for(int i=0;i<16;i++) {
		fg[i].init(370+(10*i),267,10,10,i);
		bg[i].init(370+(10*i),297,10,10,i);
		fg[i].show(0);
		bg[i].show(0);
		}
	fgd=the_textrec->text->Getfgd();
	bgd=the_textrec->text->Getbgd();
	fg[fgd].show(15);
	bg[bgd].show(15);

//*****   INPUT LOOP   *****

	name.get_form_mouse_input();
	while(!ready) {
		if(the_mouse.LBP()) {
			for(i=0;i<16;i++) {
				if(fg[i].hit()) {
					fg[fgd].show(0);
					fgd=i;
					fg[fgd].show(15);
					while(the_mouse.LBP());
					continue;
					}
				if(bg[i].hit()) {
					bg[bgd].show(0);
					bgd=i;
					bg[bgd].show(15);
					while(the_mouse.LBP());
					continue;
					}
				}
			if(name.hit()) {
				while(the_mouse.LBP());
				name.get_form_mouse_input();
				}
			if(ulx.hit()) {
				while(the_mouse.LBP());
				ulx.get_form_mouse_input();
				}
			if(uly.hit()) {
				while(the_mouse.LBP());
				uly.get_form_mouse_input();
				}
			if(cont.hit()) {
				while(the_mouse.LBP());
				cont.get_form_mouse_input();
				}
			if(cv.hit()) {
				if(cv.is_checked())
					cv.uncheck();
				else
					cv.check();
				while(the_mouse.LBP());
				}
			if(ch.hit()) {
				if(ch.is_checked())
					ch.uncheck();
				else
					ch.check();
				while(the_mouse.LBP());
				}
			if(small.hit()) {
				if(!small.is_checked()) {
					small.check();
					med.uncheck();
					large.uncheck();
					}
				while(the_mouse.LBP());
				}
			if(med.hit()) {
				if(!med.is_checked()) {
					med.check();
					small.uncheck();
					large.uncheck();
					}
				while(the_mouse.LBP());
				}
			if(large.hit()) {
				if(!large.is_checked()) {
					large.check();
					med.uncheck();
					small.uncheck();
					}
				while(the_mouse.LBP());
				}
			if(OK.hit()) {
				OK.press();
				while(OK.hit() && the_mouse.LBP());
				OK.show();
				if(OK.hit())
					ready=1;
				}
			if(CANCEL.hit()) {
				CANCEL.press();
				while(CANCEL.hit() && the_mouse.LBP());
				CANCEL.show();
				if(CANCEL.hit()) {
					redraw_screen();
					return 0;
					}
				}
			}//if LBP
		}//while !ready

	strcpy(the_textrec->name,name.getstring());
	int newulx=atoi(ulx.getstring());
	int newuly=atoi(uly.getstring());
	char * newtext=cont.getstring();
	if(cv.is_checked()) {
		settextstyle(0,0,size);
		newuly=((getmaxy()/2)-(textheight("H")/2));
		settextstyle(0,0,1);
		}
	if(ch.is_checked()) {
		settextstyle(0,0,size);
		newulx=((getmaxx()/2)-((textwidth(newtext))/2));
		settextstyle(0,0,1);
		}
	if(small.is_checked())
		size=1;
	else
	if(med.is_checked())
		size=2;
	else
	if(large.is_checked())
		size=3;

	the_textrec->text->reinit(newulx,newuly,newtext,fgd,bgd,size);

	redraw_screen();
	return 1;
}
