/*  SuperVGA demo program for Turbo C */
/*      By: Thomas Design             */
/*      August 3, 1989                */

#include <math.h>
#include <graphics.h>
#include <alloc.h>
#include <stdlib.h>
#include "PAR16.H"                    /* pick up the main BGI defines */
#include "PAR16DET.H"                 /* pick up autodetect */

  int    g_driver,  g_mode, g_error;

/*---------------------- Setup graphics ------------------------*/
void initialize()
{
  int x;
  float hue,sat,val;
    installuserdriver("PAR16",DetectPAR16);
    g_driver = DETECT;                 /* must have this line to use User Driver */
    initgraph(&g_driver,&g_mode,"");
    g_error = graphresult();
    if (g_error != 0) {
       printf("%s \n",grapherrormsg(g_error));
       exit(1);
    }
}

void sinepas()
{
    int          x1, x2, y2, y1x2, indx1, indx, istep, iq;
    double       angle;
    int          color;
    int          xcon,xmax,ymax;
    initialize();
x1 = getmaxy()/2;
y1x2 = getmaxy()/2;
x2 = getmaxx();
y2 = getmaxy();
xcon = getmaxx()/2;
xmax = getmaxx();
ymax = getmaxy();
istep = 1; iq = 1; angle = 0;
color = 1;
indx  = indx1 = 0;
angle = -3.1415;
setcolor(2);
do {
    x1 = (cos(angle) * xcon) + xcon;
    y2 = y2 + istep;
    angle = angle + 0.03;
    if (angle > 3.1415) angle = - 3.1415;
    y1x2 = y1x2 + iq;
    if ((y1x2 < 10))  iq =  1;
    if ((y1x2 > ymax)) iq = -1;
    if (y2 < 10)  istep =  1;
    if (y2 > ymax) istep = -1;
    x2 = y1x2 + (sin(angle) * 45);
    line(x1, y1x2, x2, y2);
    indx  = ++indx;
    indx1 = ++indx1;
    if (indx1 == 2000) {
       indx1 = indx = 0;
       cleardevice();
    }
    if (indx > 15) indx = 1;
  } while (!kbhit()) ;
}

main()
{
    sinepas();
    getch();
    restorecrtmode();
}
