//========================================================================
//  The following routines have been uploaded to the Borland Forum BPROGB
//  on CompuServe by the Technical Support staff.  They are provided as a
//  courtesy and not as part of a Borland product; and, as such, are
//  provided without the assurance of technical support or any specific
//  guarantees.
//========================================================================
// =======================================================================
//  stream.cpp
//
//	This file functions required for creating a user defined class
//	for streaming. The project file lists which files are required so
// that you do not need to link in the Turbo Vision library.
//	This allows you to have persistent objects in any of your
//	applications, plus the screen is not cleared at the end of the
//	program as is done with Turbo Vision applications. Note that the
// source code to TV is not included in this zip file. Either modify
// the path to the TV source files in the project file, or link in
// TV.LIB.
//
//	Get the document TI1023 from either the BBS, (408) 439-9096, or
//	from our TechFax service, (800) 822-4269, for more information
//	on streaming and persistent objects.
//
//	Designed for use with Turbo Vision 1.03 ( which comes with BC 3.1 ).
//
// =======================================================================

#define Uses_ipstream
#define Uses_opstream
#define Uses_ofpstream
#define Uses_ifpstream
#define Uses_pstream

#define Uses_TStreamableClass
#define Uses_TStreamable
#define Uses_fpstream

#include <tv.h>
#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <iostream.h>
#include <stream.h>

extern unsigned _sktlen = 4048 ;
const char * const near TMine::name = "TMine" ;

void TMine::write( opstream& os)
{
	os << x << y ;
}

void *TMine::read( ipstream& is)
{
	is >> x >> y ;
	return this ;
}

inline ipstream& operator >> ( ipstream& is, TMine& cl )
    { return is >> (TStreamable&)cl; }
inline ipstream& operator >> ( ipstream& is, TMine*& cl )
    { return is >> (void *&)cl; }

inline opstream& operator << ( opstream& os, TMine& cl )
    { return os << (TStreamable&)cl; }
inline opstream& operator << ( opstream& os, TMine* cl )
    { return os << (TStreamable *)cl; }

TStreamableClass RMine( TMine::name,
			TMine::build,
			__DELTA(TMine)
		      );

// output data to the stream
int write( int row, int column )
{
	TMine writeObj ;
	ofpstream ofps ;

	ofps.open( "dlg.sav", ios::app ) ;

	writeObj.assign( row, column ) ;
	writeObj.draw() ;
	ofps << writeObj ;

	return 0 ;
}

// Get data from the stream
int read( void )
{

	TMine readObj ;
	ifpstream ifps ;

	ifps.open( "dlg.sav" ) ;

	// This allows us to loop through a stream of unknown size
	// by setting a pointer to the eng of the stream.
	ifps.seekg( 0, ios::end ) ;
	streampos ifpsEnd = ifps.tellg() ;
	// Go to the begining of the stream
	ifps.seekg( 0 ) ;
	// Loop through the stream
	while ( ifpsEnd != ifps.tellg() )
	{
		ifps >> readObj ;
		readObj.draw() ;
	}
	return 0 ;
}

int main( void )
{
	ofpstream ofps ;

	// Delete the old stream
	ofps.open( "dlg.sav", ios::trunc ) ;
	ofps.close() ;

	// Write items to a stream
	cout << "\nData written to stream" << endl ;
	write( 35, 1000 ) ;
	write( 1, 2 ) ;
	write( 4, 3 ) ;
	write( 24, 142 ) ;
	write( 100, 200 ) ;
	// Read the items from the stream
	cout << "Data read from stream" << endl ;
	read() ;

	cout << "Press any key to end." << endl ;

	getch() ;

	return 0 ;
}

   /*
  DISCLAIMER: You have the right to use this technical information
  subject to the terms of the No-Nonsense License Statement that
  you received with the Borland product to which this information
  pertains.
     */
