//========================================================================
//  The following example routines have been provided by the Technical
//  Support staff at Borland International.  They are provided as a
//  courtesy and not as part of a Borland product, and as such, are
//  provided without the assurance of technical support or any specific
//  guarantees.
//========================================================================
//  Turbo Vision - Creating a Popup menu
//
//  - This sample code demonstrates one method of creating a simple
//  pop-up menu using class TMenuBox.
//
//  - If the popup menu is inserted into the desktop (or another view),
//  then the handleEvent procedure of that view must be prepared to
//  recieve the commands generated by the menu (and to close the menu)
//
//  - If the popup menu is invoked using execView, then you will have to
//  derive from TMenuBox and override Tapplication::handleEvent to do some
//  useful chore as a result of the menu selection. You will have to execView
//  the menu for it to be deleted automatically after a menu option is
//  selected.
//------------------------------------------------------------------------
#define Uses_TKeys
#define Uses_TEvent
#define Uses_TGroup
#define Uses_opstream
#define Uses_ipstream

#define Uses_MsgBox
#define Uses_TApplication
#define Uses_TButton
#define Uses_TMenuView
#define Uses_TKeys
#define Uses_TDeskTop
#define Uses_TDialog

#define Uses_TMenu
#define Uses_TMenuBar
#define Uses_TMenuBox
#define Uses_TMenuItem
#define Uses_TStaticText
#include <tv.h>
#include <stdlib.h>
#include <String.h>
#include <ctype.h>
#include <Assert.h>
#include "e:\comp\bc31\tvision\demos\gadgets.h"

//========================================================================
//  global data
//------------------------------------------------------------------------
const cmAbout   = 100;  // User selected menu item 'About'
const cmPopup   = 101;  // User selected menu item 'Popup'
const cmOne     = 102;  // User selected popup item one
const cmTwo     = 103;  // User selected popup item two

//========================================================================
//  class definitions
//------------------------------------------------------------------------

class TMyMenuBox : public TMenuBox {
	public:
	TMyMenuBox( const TRect& bounds, TMenu *aMenu, TMenuView *aParentMenu) :
	TMenuBox( bounds, aMenu, aParentMenu) {
		state |= sfShadow;
		options |= ofPreProcess;
	}
	void handleEvent( TEvent& event ) ;
	ushort TMyMenuBox::execute() ;

} ;

void TMyMenuBox::handleEvent( TEvent& event )
{
	// This function is never called when TMyMenuBox is modal
}

ushort TMyMenuBox::execute()
{
     int result  ;

     result = TMenuView::execute() ;
     return result;
}


class TApp : public TApplication {
    //  main application class

public:
    TApp();
    ~TApp() {
	delete heap ; }

    // virtual functions to be locally redefined
    static TMenuBar *initMenuBar( TRect r );
    void handleEvent( TEvent &event );
    THeapView *heap ;

    // declare new functions
    void AboutDialog();
    void Popup();
    void idle() ;
};



void TApp::idle()
{
    TProgram::idle();
    heap->update();
}

//========================================================================
//  implementation of TApp
//------------------------------------------------------------------------
TApp::TApp() : TProgInit( TApplication::initStatusLine,
		    TApp::initMenuBar, TApplication::initDeskTop )
{
    // default status line and desk top
    TRect r = getExtent() ;
    r.a.x = r.b.x - 13 ;
    r.a.y = r.b.y -1 ;
    heap = new THeapView( r ) ;
    insert( heap ) ;
}

//------------------------------------------------------------------------
// define menu bar
//------------------------------------------------------------------------
TMenuBar *TApp::initMenuBar( TRect r )
{
    r.b.y = r.a.y + 1;
    return( new TMenuBar( r, new TMenu(
	*new TMenuItem( "~A~bout", cmAbout, kbAltA, hcNoContext, 0,
	new TMenuItem( "P~o~pup", cmPopup, kbAltO, hcNoContext, 0 )
	))));
}

//------------------------------------------------------------------------
// event-handler
//------------------------------------------------------------------------
void TApp::handleEvent( TEvent &event )
{
    if( event.what == evCommand )
    {
	switch( event.message.command )
	{
	    case cmAbout:       // display the about box
		AboutDialog();
		clearEvent( event );
		break;
	    case cmPopup:       // display modal popup menu
		Popup();
		clearEvent( event );
		break;
	    case cmOne:         // received from modless popup
		messageBox( "Item 1 selected", mfOKButton );
		clearEvent( event );
		break;
	    case cmTwo:         // received from modless popup
		messageBox( "Item 2 selected", mfOKButton );
		clearEvent( event );
		break;

	    default:
		break ;
	}
    }
    TApplication::handleEvent( event );
}

//------------------------------------------------------------------------
// create modal About dialog box
//------------------------------------------------------------------------
void TApp::AboutDialog()
{
    // the About box reminds the user what is being demonstrated
    TDialog *pd = new TDialog( TRect( 0, 0, 35, 12 ), "About" );
    if( validView( pd ) )
    {
        pd->options |= ofCentered;
        pd->insert ( new TStaticText( TRect( 1, 2, 34, 7 ),
                "\003Turbo Vision Example\n\003\n"
		"\003Creating a Modal Popup Menu\n\003\n"
                "\003Borland Technical Support" ) );
        pd->insert( new TButton( TRect( 3, 9, 32, 11 ), "~O~k",
                                cmOK, bfDefault ) );
	deskTop->execView( pd );
    }
    destroy( pd );
}

//------------------------------------------------------------------------
//  display a modal popup menu
//------------------------------------------------------------------------
void TApp::Popup()
{
    // the rectangle will be sized to fit the item text
    TRect bounds( 0, 0, 0, 0 );

    // for clarity, we'll create separately the menu to
    // insert into the menubox
    TMenu *theMenu = new TMenu (
	    *new TMenuItem( "Item ~1~", cmOne, kbAltG, hcNoContext, "Alt-G",
	    new TMenuItem ( "Item ~2~", cmTwo, kbAltH, hcNoContext, "Alt-H",
            new TMenuItem ( "E~x~it", cmQuit, kbAltX, hcNoContext, "Alt-X"
        ) ) ) );

    // now create the menu with no parent
    TMyMenuBox *mb = new TMyMenuBox( bounds, theMenu, 0 );

    // however, if we don't specify appropriate bounds, we must do
    // something to ensure it is appropriately positioned on the desktop
    mb->options |= ofCentered;

    // then make sure it's valid and execute it
    int result = 0 ;
    if( validView( mb ) )
    {
	result = deskTop->execView( mb );
	destroy( mb ) ;
    }
    delete theMenu ;
    // Create an event for the TApp handleEvent
    TEvent event ;
    event.what = evCommand ;
    event.message.command = result ;
    putEvent( event ) ;
    clearEvent( event ) ;
}

//========================================================================
int main(void)
{
    // now for the tought stuff
    TApp myApp;
    myApp.run();
    return 0;
}
