#if !defined (ERRORdotH)
#define ERRORdotH


//*****
//***** Error reporting class.
//*****

class ErrorReporter
{
  void (*reportFunc)(char *errorString);    // function used to report error
public:
  ErrorReporter();
  void operator << (char *errorString);     // report an error
  inline void reporter(void (*func)(char *str));
};

extern ErrorReporter errorReporter;



/**************************************************************************
*  Function:    ErrorReporter::reporter
*
*  Purpose:     Change the current reporting function.
*
*  Entry:       func = Pointer to the new reporting function.
*
*  Exit:        N/A
**************************************************************************/

inline void ErrorReporter::reporter(void (*func)(char *str))
{
  reportFunc = func;
}


#endif
