#if !defined (FILEdotH)
#define FILEdotH


#include <stdio.h>
#include "portable.h"


//*****
//***** File manipulation class.
//*****

class File
{
  FILE *fp;
  char fName[PATH_MAX];
  unsigned numErrors;
  int reportErrors;
public:
  File(void);
  File(char *filename, char *mode);
  ~File(void);
  inline unsigned status(void);			// returns true on error
  int read(void *buf, biguint bytes);           // returns 0 on error
  int write(void *buf, biguint bytes);          // returns 0 on error
  int seek(bigint offset, int whence);          // returns 0 on error
  inline int rewind(void);			// returns 0 on error
  biguint position(void);                       // returns 0xFFFFFFFF on error
  biguint size(void);                           // returns 0 on error
  inline int eof(void);                         // returns true if at EOF
  int open(char *filename, char *mode);		// returns 0 on error
  int close(void);				// returns 0 on error
  int gets(char *str, int maxChars);		// returns 0 on error
  inline void quiet(void)               { reportErrors=0; }
  inline void noisy(void)               { reportErrors=1; }
};



/**************************************************************************
*  Function:    File::status
*
*  Purpose:     Return a code indicating whether or not an error has
*               occurred, and reset the number of errors to 0.
*
*  Entry:       N/A
*
*  Exit:        Returns non-zero if an error has occurred.
**************************************************************************/

inline unsigned File::status(void)
{
  unsigned errors;

  errors = numErrors;			// store numErrors
  numErrors = 0;			// reset numErrors to zero
  return (errors);			// return old numErrors
}



/**************************************************************************
*  Function:    File::rewind
*
*  Purpose:     Seek to the beginning of the file.
*
*  Entry:       N/A
*
*  Exit:        Returns 0 on error.
**************************************************************************/

inline int File::rewind(void)
{
  return (seek(0, SEEK_SET));
}



/**************************************************************************
*  Function:    File::eof
*
*  Purpose:     Determine if the file is at EOF or not.
*
*  Entry:       N/A
*
*  Exit:        Returns non-zero if the file is at EOF.
**************************************************************************/

inline int File::eof(void)
{
  return (feof(fp));
}



#endif
