#if !defined(PORTABLEdotH)
#define PORTABLEdotH


/****
***** Deal with protected and real mode compilers.
****/

#if defined(__TURBOC__)                               /* Borland */
  #define _near                 near
  #define _far                  far
  #define _huge                 huge
#elif defined(__GNUC__)                               /* GNU */
  #define _near
  #define _far
  #define _huge
  #define PROTECTED_MODE_32
#else                                                 /* who knows? */
  #define _near                 near
  #define _far                  far
  #define _huge                 huge
#endif


/****
***** Standardize variable type names.
****/

#if defined(__TURBOC__)                               /* Borland */
  typedef long                  bigint;
  typedef unsigned long         biguint;
#elif defined(__GNUC__)                               /* GNU */
  #define bigint                int
  #define biguint               unsigned
#else                                                 /* who knows? */
  #if sizeof(int)==4
    typedef int                 bigint;
    typedef unsigned            biguint;
  #else
    typedef long                bigint;
    typedef unsigned long       biguint;
  #endif
#endif


/****
***** Standardize file macros.
****/

#if defined(__TURBOC__)                               /* Borland */
  #include <dir.h>
  #define PATH_MAX              MAXPATH
  #define DRIVE_MAX             MAXDRIVE
  #define DIR_MAX               MAXDIR
  #define FILE_MAX              MAXFILE
  #define EXT_MAX               MAXEXT
#elif defined(__GNUC__)                               /* GNU */
  #include <sys/param.h>
  #define PATH_MAX              MAXPATHLEN
  #define DRIVE_MAX             3
  #define DIR_MAX               66
  #define FILE_MAX              9
  #define EXT_MAX               5
#else                                                 /* who knows? */
  #define PATH_MAX              80
  #define DRIVE_MAX             3
  #define DIR_MAX               66
  #define FILE_MAX              9
  #define EXT_MAX               5
#endif


/****
***** Standardize error macros.
****/

#if defined(__TURBOC__)                               /* Borland */
  #define ERROR_ZERO            EZERO
  #define ERROR_NOT_SAME        ENOTSAM
#else                                                 /* who knows? */
  #define ERROR_ZERO            0
  #define ERROR_NOT_SAME        17
#endif


/****
***** Standardize string macros.
****/

#if defined(__TURBOC__)                               /* Borland */
  #define STRING_UPPER(s)       strupr(s)
  #define STRING_CMP_I(s1,s2)   stricmp(s1,s2)
#else                                                 /* who knows? */
  char *STRING_UPPER(char *s);
  int STRING_CMP_I(char *s1, char *s2);
#endif


/****
***** Standardize the memory management macros.
****/

#if defined(__TURBOC__)                               /* Borland */
  #include <alloc.h>
  #define ALLOC_MEM(b)          farmalloc(b)
  #define FREE_MEM(p)           farfree(p)
#else                                                 /* who knows? */
  #define ALLOC_MEM(b)          malloc(b)
  #define FREE_MEM(p)           free(p)
#endif


/****
***** Standardize the file name splitting/merging functions.
****/

#if defined(__TURBOC__)                               /* Borland */
  #define FN_SPLIT(path,drive,dir,name,ext) \
                                fnsplit(path,drive,dir,name,ext)
  #define FN_MERGE(path,drive,dir,name,ext) \
                                fnmerge(path,drive,dir,name,ext)
#else                                                 /* who knows? */
  void FN_SPLIT(char *path, char *drive, char *dir, char *fname, char *ext);
  void FN_MERGE(char *path, char *drive, char *dir, char *fname, char *ext);
#endif


/****
***** Standardize the memory management functions.
****/

extern void _far *(*resAllocMem)(biguint bytes);

                                       

#endif
