// *************************************************************** //
// Filename:    SDIBar.cpp                                         //
//                                                                 //
// Date:        November 26, 1993                                  //
//                                                                 //
// Description:                                                    //
// *************************************************************** //
#include "SDIBar.h"

// --------------------------------------------------------------- //
// SDIBarWindow constructor                                       //
// --------------------------------------------------------------- //
TSDIBarWindow::TSDIBarWindow() :
  TWindow(0, 0, 0)
{
}

// --------------------------------------------------------------- //
// SDIBarWindow destructor                                        //
// --------------------------------------------------------------- //
TSDIBarWindow::~TSDIBarWindow()
{
}

// --------------------------------------------------------------- //
// GetClassName                                                    //
// --------------------------------------------------------------- //
char *TSDIBarWindow::GetClassName()
{
  return "SDIBarClass";
}

// --------------------------------------------------------------- //
// GetWindowClass                                                  //
// --------------------------------------------------------------- //
void TSDIBarWindow::GetWindowClass(WNDCLASS &wc)
{
  TWindow::GetWindowClass(wc);
  wc.hbrBackground = (HBRUSH)GetStockObject(LTGRAY_BRUSH);
}

// --------------------------------------------------------------- //
// SetupWindow                                                     //
// --------------------------------------------------------------- //
void TSDIBarWindow::SetupWindow()
{
  TWindow::SetupWindow();
  // put new stuff here
  TSDIBarApp *app = TYPESAFE_DOWNCAST(GetApplication(), TSDIBarApp);
  app->StatusBar->SetText("In SetupWindow");
}

// --------------------------------------------------------------- //
// CleanupWindow                                                   //
// --------------------------------------------------------------- //
void TSDIBarWindow::CleanupWindow()
{
  // put new stuff here
  TWindow::CleanupWindow();
}

// --------------------------------------------------------------- //
// Response table for SDIBarWindow                                //
// --------------------------------------------------------------- //
DEFINE_RESPONSE_TABLE1(TSDIBarWindow, TWindow)
  EV_WM_PAINT,
  EV_WM_SIZE,
  EV_COMMAND(ID_HAPPY, IdHappy),
END_RESPONSE_TABLE;


// --------------------------------------------------------------- //
// Draw3DRect                                                      //
// --------------------------------------------------------------- //
void Draw3DRect(TDC &dc, TRect &rect, TPen Hilite, TPen Shadow)
{
  dc.SelectObject(Hilite);
  dc.MoveTo(rect.left, rect.bottom);
  dc.LineTo(rect.left, rect.top);
  dc.LineTo(rect.right, rect.top);
  dc.MoveTo(rect.right-1, rect.top);
  dc.LineTo(rect.right-1, rect.bottom-1);
  dc.LineTo(rect.left+1, rect.bottom-1);
  dc.RestorePen();

  dc.SelectObject(Shadow);
  dc.MoveTo(rect.left+1, rect.bottom-1);
  dc.LineTo(rect.left+1, rect.top+1);
  dc.LineTo(rect.right-1, rect.top+1);
  dc.MoveTo(rect.right, rect.top);
  dc.LineTo(rect.right, rect.bottom);
  dc.LineTo(rect.left, rect.bottom);
  dc.RestorePen();
}

// --------------------------------------------------------------- //
// WM_PAINT                                                        //
// --------------------------------------------------------------- //
void TSDIBarWindow::EvPaint()
{
  TPaintDC dc(HWindow);
  TRect rect;

  GetClientRect(rect);
  rect.right--;
  rect.bottom--;
  Draw3DRect(dc, rect, GetStockPen(WHITE_PEN), GetStockPen(BLACK_PEN));
}

// --------------------------------------------------------------- //
// WM_SIZE                                                         //
// --------------------------------------------------------------- //
void TSDIBarWindow::EvSize(UINT, TSize &)
{
  Invalidate(TRUE);
}


// --------------------------------------------------------------- //
// IDHappy                                                         //
// --------------------------------------------------------------- //
void TSDIBarWindow::IdHappy()
{
  MessageBox("Have a happy day!", "Joy", MB_OK);
}
