/*
**
** "Skipper" Flat File C++ OOP Database System.
**
** (c)1992 C.A.M. Technical Systems,
**
** Programmer and System Engineer : C. McNiel.
**
*/

#define MAXINSERTIONS 20
#define MAXKEYLENGTH 10
#define MAXRECORDSIZE 80
#define DEBUG


#include <fstream.h>


#ifndef MAXINSERTIONS
	#error MAXINSERTIONS needs to be defined prior to inclusion.
#endif
#ifndef MAXRECORDSIZE
	#error MAXRECORDSIZE needs to be defined prior to inclusion.
#endif
#ifndef MAXKEYLENGTH
	#error MAXKEYLENGTH needs to be defined prior to inclusion.
#endif

extern char *VERRCODE[];


/*
**	"Class" Definitions.
*/

#ifdef __DLL__

#define Export _export

#else

#define Export /**/

#endif


class Export Master

	{
	private:

	unsigned int Dups,AutoAlign,AutoPack;
	unsigned int RecSize;
	unsigned int KeyLen;
	unsigned int KeyOff;    /*  RECORD control variables               */
	fstream HFile;          /*  DataBase Stream                        */
	char FileName[13];
	int ErrState;  			/*  Error status of Data Base              */
	int Insertions;         /*  Number of insertions since last pack   */
	unsigned long Records;  /*  Records in database since last pack    */
	unsigned long LastKey;
	int LastOp,Deleteds;    /*  Last database operation  performed     */
	char TempRecord[MAXRECORDSIZE];

	int Sort(char *);


	public:

	Master(char *, unsigned int, unsigned int, unsigned int);

		int OpenDB(char *, unsigned int, unsigned int, unsigned int);
		int CloseDB(void);
		int Insert(void *);
		int LookUp(char *,void *);
		int CheckInserts(char *,void *);
		int Extract(char *,void *);
		int Delete(char *);
		int Align(void);
		int GetNext(void *);
		int GetPrev(void *);
		int Remove(void);
		int StepNext(void *);
		int StepPrev(void *);
		int Sort_Routine(const void *, const void *);
		int State(void) { return ErrState; };
		int ClearState(void) { return ErrState = 0; }
		int Duplicates(void) { return Dups = 0; }
		int NoDuplicates(void) { return Dups = 1; }
		int AlignOff(void) { return AutoAlign = 1; };
		int AlignOn(void) { return AutoAlign = 0; };
		int PackOff(void) { return AutoPack = 1; };
		int PackOn(void) { return AutoPack = 0; };
		char* Version(void) { return "\nSkipper Version 1.15B\n"; };
		int PackDB(void);

		#ifdef DEBUG

		char* VERROR(void) { return VERRCODE[ErrState]; };

		#endif

	~Master();

	};

int Srt (const void*,const void*);

extern unsigned int KEYLEN,KEYOFF;
