#ifndef _BREAK_H
#define _BREAK_H
//============================================================================
//
//  BREAK.H
//
//  Source include file for class BreakTrap
//  Serial++ Library SPP.LIB Ver. 1.10
//
//  Copyright (c) 1991,1992 Cortlandt Technologies, All rights reserved.
//
//	 Cortlandt Technologies, P.O. Box 195, Pleasantville NY 10570
//
//  Please direct all inquiries to the above address,
//  or via Compuserve: 71066,155
//
//============================================================================

	struct BreakAnchor;

	class BreakTrap
		{
		private:

		BreakAnchor     *ba;

		static void capture(void);
		static void release(void);

		public:

		BreakTrap(void);		// first occurence sets trap
						// subsequent one point

		~BreakTrap(void);		// deletes instance
						// if owner, releases trap

		void reset(void);		// clear flag

		int isBreak(void);		// true when flag set

		unsigned int breakCt(void);	// counts accumulated hits

		int isCaptured(void);		// true if trap set

		int isOwner(void);		// true if this instance
														 // is owner of trap

		int operator()(void);		// true if trap is set and
						// flag is true;
						// resets flag
		};

//============================================================================
#endif
