// SR_LLIST.H
//
//      Header file for Stage Research Linked List manager.
//
//  Author:  Carlton Guc
//    Date:  4/5/94
//
//                 

typedef struct {
    HANDLE  hNextHandle;
    HANDLE  hPrevHandle;
    WORD    wLocked;
    BYTE    vElement;
    } LINKEDLISTELEMENT, FAR *LPLINKEDLISTELEMENT;

typedef struct {
    char    szName[128];
    char    bEOF;
    WORD    wVersion;
    WORD    wSize;
    WORD    wElementTotal;
    HANDLE  hFirstEntry;
    HANDLE  hLastEntry;
    } LINKEDLIST, FAR *LPLINKEDLIST;


HANDLE WINAPI _loadds StageStartLinkedList (WORD wSize, LPSTR lpszTitle, WORD wVersion);
BOOL WINAPI _loadds StageStopLinkedList (HANDLE hHandle);
WORD WINAPI _loadds StageAddLinkedListElement (HANDLE hHandle, void FAR *lpVoid);
WORD WINAPI _loadds StageInsertLinkedListElement (HANDLE hHandle, void FAR *lpVoid, WORD wElement);
BOOL WINAPI _loadds StageDeleteLinkedListElement (HANDLE hHandle, WORD wElement);
BOOL WINAPI _loadds StageReplaceLinkedListElement (HANDLE hHandle, void FAR *lpVoid, WORD wElement);
void FAR * WINAPI _loadds StageGetLinkedListElement (HANDLE hHandle, WORD wElement);
BOOL WINAPI _loadds StageReleaseLinkedListElement (HANDLE hHandle, WORD wElement);
BOOL WINAPI _loadds StageWriteLinkedListToFile (HANDLE hHandle, LPSTR lpFilename);
BOOL WINAPI _loadds StageReadLinkedListFromFile (HANDLE hHandle, LPSTR lpFilename);
WORD WINAPI _loadds StageGetLinkedListCount (HANDLE hHandle);
BOOL WINAPI _loadds StageRestartLinkedList (HANDLE hHandle);


  