// SR_SOUND.H
//  Header for Stage Research Sound playing DLL

#ifndef __SR_SOUND
#define __SR_SOUND

#include <mmsystem.h>

// MCI Defines when message is posted to parent window.
#define MCI_PLAYING     1
#define MCI_STOPPING    2
#define MCI_PAUSING     3
#define MCI_CUEING      4
#define MCI_LOADING     5


// Errors possible
#define ERROR_WAVE_NO_FILE          1
#define ERROR_WAVE_NOT_WAVE         2
#define ERROR_WAVE_CORRUPTED        3 
#define ERROR_WAVE_MEMORY           4
#define ERROR_WAVE_READING          5
#define ERROR_WAVE_NOT_PCM          6
#define ERROR_WAVE_NOT_SUPPORTED    7
#define ERROR_WAVE_NO_DATA          8
#define ERROR_WAVE_NO_OUTPUT        9
#define ERROR_WAVE_PREPARE_HEADER   10 

// Possible effect for WAVE image
#define WAVE_EFFECT_REVERSE         1


// WAV Status
#define STAGE_WAV_LOADED            0
#define STAGE_WAV_PLAYING           1
#define STAGE_WAV_STOPPED           2
#define STAGE_WAV_PAUSED            3
#define STAGE_WAV_DONE              4

// Data Types
typedef struct waveInst {
    HANDLE hWaveInst;
    HANDLE hWaveHdr;
    HANDLE hWaveData;
} WAVEINST, FAR *LPWAVEINST;

typedef struct {
    char            szWavFile[256];
    HMMIO           hWavOnDisk;
    HANDLE          hStageWav;
    MMCKINFO        mmckinfoParent;
    MMCKINFO        mmckinfoSubchunk;
    HANDLE          hFormat;
    LPWAVEFORMAT    lpFormat;
    HANDLE          hWavData;
    HPSTR           lpWavData;
    HANDLE          hWavHdr;
    LPWAVEHDR       lpWavHdr;
    HWAVEOUT        hWavOut;
    WORD            wStatus;
    } STAGEWAV, FAR *LPSTAGEWAV;

// Function prototypes
void _loadds Interchange(HPSTR, HPSTR, WORD);
void _loadds cleanup(LPWAVEINST lpWaveInst);
BOOL WINAPI _loadds WaveEffectReverse (HPSTR, DWORD, WORD); 
UINT WINAPI _loadds StageWaveLoadEffect(HWND, LPSTR, WORD);
VOID WINAPI _loadds StageWaveDone (UINT, LONG);
BOOL WINAPI _loadds StageWaveStop (void);
BOOL WINAPI _loadds StageWavePause (void);
UINT WINAPI _loadds StageWavePlay (void); 
BOOL WINAPI _loadds StageWaveUnload (void);
BOOL WINAPI _loadds StageWaveDeviceProc (HWND hDlg, UINT message, UINT wParam, LONG lParam);
BOOL WINAPI _loadds StageWaveProc (HWND hDlg, UINT message, UINT wParam, LONG lParam);

BOOL WINAPI _loadds StageWavDeviceCaps (HWND);
BOOL WINAPI _loadds StageWavCaps (HWND, LPSTR);
HANDLE WINAPI _loadds StageWavLoad (LPSTR lpWavfile, WORD FAR *wReturn);
WORD WINAPI _loadds StageWavPlay (HWND hWnd, HANDLE hStageWav, UINT uDevice);
BOOL WINAPI _loadds StageWavDone (WPARAM wParam, LPARAM lParam);
BOOL WINAPI _loadds StageWavPause (HANDLE hStageWav);
BOOL WINAPI _loadds StageWavStop (HANDLE hStageWav);
BOOL WINAPI _loadds StageWavUnload (HANDLE FAR *hStageWav);

DWORD WINAPI _loadds StageLoadWAVE (HWND hWndNotify, LPSTR lpszWAVEFileName);
DWORD WINAPI _loadds  StageCueWAVE (void);
DWORD WINAPI _loadds StagePlayWAVE (void);
DWORD WINAPI _loadds StageStopWAVE (void);
DWORD WINAPI _loadds StagePauseWAVE (void);
void WINAPI _loadds StageShowMCIError (DWORD dwError);





#endif



