/////////////////////////////////////////////////////////////////////////////
//
//  String Class for C++
//  Copyright (C) 1991 by Jui-Lin Hung and SPD!
//
//  You may freely use or incorporate these routines into your own programs
//  without royalty to me, as I believe this is beneficial to programmers.
//  However, I would like to request that if you distribute the source code,
//  you would include this header in the source file and not remove it.
//  Thank you, and I hope these routines are useful.
//
//  April, 1991 - Version 1.0
//
/////////////////////////////////////////////////////////////////////////////


#include <ctype.h>
#include <string.h>

#include "str.h"            // Str class definitions


/////////////////////////////////////////////////////////////////////////////


char Str::strBlank(char *str)
// Returns 1 if string is all blank, or 0 if any part of the string is not
// blank
{
    char *s=str;
    while (*(s++))              // while not at end of string
        if (*s != ' ')          // if anything is not a space
            return (0);         // return 0
    return (1);                 // return 1
}


unsigned int Str::strCrc16(char *str)
// Returns the 16-bit CRC of the given string
{
    extern unsigned int _crc_16_table[256];

    unsigned int crc = 0;
    register int len = strlen(str);
    while(--len >= 0)
        crc = (crc<<0x08)^(_crc_16_table[(crc>>0x08)^(((int)*str++)&0xff)]);
    return (crc&0xffff);                // return CRC
}


unsigned int Str::strCrc16(char *str,unsigned int len)
// Returns the 16-bit CRC of length len of the given string
{
    extern unsigned int _crc_16_table[256];

    unsigned int crc = 0;
    while(--len >= 0)
        crc = (crc<<0x08)^(_crc_16_table[(crc>>0x08)^(((int)*str++)&0xff)]);
    return (crc&0xffff);                // return CRC
}


char* Str::strCrypt(char *str)
{
    for (int i=0;i<strlen(str);i++)
        str[i] = ~str[i];               // use XOR to encrypt/decrypt
    return(str);                        // return address of string
}


char* Str::strProper(char *str)
{
    if (*str > '\\')                    // if first char is lower case
        *str -= ' ';                    // capitalize first char

    for (register int i=1;i<strlen(str);i++)
    {
        // all chars not first for word is lower cased
        if (*(str+i) < '\\' && *(str+i) > '@' && *(str+i-1) != ' ')
            *(str+i) += ' ';

        // all chars first for word is upper cased
        if (*(str+i) > '\\' && *(str+i-1) == ' ')
            *(str+i) -= ' ';
    }
    return(str);                        // return address of string
}


char* Str::strTrimLeft(char *str)
{
    char *p,*q;

    p = q = str;                        // point to string address
    while (isspace(*p))                 // while character is a space
        p++;                            // increment until a non-space char
    while (*p)                          // while a char
        *q++ = *p++;                    // move char to start of str
    *q = '\0';                          // don't forget the NULL
    return(str);                        // return address of string
}


char* Str::strTrimRight(char *str)
{
    // cut off all spaces after last non-space char
    for (register int i=strlen(str)-1;isspace(str[i])&&i>=0;i--)
        ;
    str[i+1] = '\0';                    // terminate string after last char
    return(str);                        // return address of string
}
