/////////////////////////////////////////////////////////////////////////////
//
//  String Class for C++
//  Copyright (C) 1991 by Jui-Lin Hung and SPD!
//
//  You may freely use or incorporate these routines into your own programs
//  without royalty to me, as I believe this is beneficial to programmers.
//  However, I would like to request that if you distribute the source code,
//  Thank you, and I hope these routines are useful.
//
//  April, 1991 - Version 1.0
//
/////////////////////////////////////////////////////////////////////////////


#ifndef __STR_H
#define __STR_H

#ifndef __CRC16_H
    #include "crc16.h"
#endif


/////////////////////////////////////////////////////////////////////////////


class Str {
private:
public:
    // Member functions
    char strBlank(char *);          // Returns 1 if string is blank
    unsigned int strCrc16(char *);  // Returns the 16-bit CRC
    unsigned int strCrc16(char *,unsigned int)  // Returns the 16-bit CRC
    char *strCrypt(char *);         // Returns the XOR crypted string
    char *strProper(char *);        // Returns The String Properly Capitalized
    char *strTrimLeft(char *);      // Trims whitespace off left of string
    char *strTrimRight(char *);     // Trips whitespace off right of string

    // Inline functions
    char *strTrimBoth(char *str)    // Trims whitespace off right and left
        {
            return(strTrimLeft(strTrimRight(str)));
        }
};


#endif // __STR_H
