/*  Project switch
    Borland International
    Copyright  1993. All Rights Reserved.

    SUBSYSTEM:    switch.exe Application
    FILE:         swtchapp.cpp
    AUTHOR:       Bruneau Babet


    OVERVIEW
    ========
    Source file for implementation of switchApp (TApplication).      
*/


#include <owl\owlpch.h>
#pragma hdrstop


#include "swtchapp.h"
#include "swtchabd.h"                        // Definition of about dialog.


//{{switchApp Implementation}}


//
// Build a response table for all messages/commands handled
// by the application.
//
DEFINE_RESPONSE_TABLE1(switchApp, TApplication)
//{{switchAppRSP_TBL_BEGIN}}
    EV_COMMAND(CM_FILENEW, CmFileNew),
    EV_COMMAND(CM_FILEOPEN, CmFileOpen),
    EV_COMMAND(CM_FILECLOSE, CmFileClose),
    EV_COMMAND(CM_HELPABOUT, CmHelpAbout),
    EV_COMMAND(CM_CONFIGUREDIALOG, HandleConfigureDialog),
    EV_COMMAND_ENABLE(CM_CONFIGUREDIALOG, HandleConfigureDialogCmdEnable),

    EV_COMMAND(CM_CLOSECONFIGUREDIALOG, HandleCloseConfigureDialog),
    EV_COMMAND_ENABLE(CM_CLOSECONFIGUREDIALOG, HandleCloseConfigureDialogCmdEnable),

    EV_COMMAND(BITMAP_1, CmBitmap1),
    EV_COMMAND(BITMAP_2, CmBitmap2),
    EV_COMMAND(BITMAP_3, CmBitmap3),
    EV_COMMAND(BITMAP_4, CmBitmap4),

    EV_MESSAGE(WM_SETUPUI, HandleWMSetupUI ),
//{{switchAppRSP_TBL_END}}
END_RESPONSE_TABLE;


//
// FrameWindow must be derived to override Paint for Preview and Print.
//
class SDIDecFrame : public TDecoratedFrame {
public:
    SDIDecFrame (TWindow *parent, const char far *title, TWindow *clientWnd, BOOL trackMenuSelection = FALSE, TModule *module = 0) :
            TDecoratedFrame(parent, title, clientWnd, trackMenuSelection, module)
      {  }
    ~SDIDecFrame ()
      {  }
};


//////////////////////////////////////////////////////////
// switchApp
// =====
//
switchApp::switchApp () : TApplication("switch")
{

    // Common file file flags and filters for Open/Save As dialogs.  Filename and directory are
    // computed in the member functions CmFileOpen, and CmFileSaveAs.
    FileData.Flags = OFN_FILEMUSTEXIST | OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT;
    FileData.SetFilter("All Files (*.*)|*.*|");

    // INSERT>> Your constructor code here.
	 cfgDialog = NULL;
}


switchApp::~switchApp ()
{
	 // INSERT>> Your destructor code here.

}


void switchApp::SetupSpeedBar (TDecoratedFrame *frame)
{
	 static TControlBar* cb = NULL;

	 if ( !cb )
	 {
		 cb = new TControlBar(frame);
		 frame->Insert(*cb, TDecoratedFrame::Top);
	 }

	 TGadget *gadget = cb->FirstGadget();
	 while ( gadget )
	 {
		 TGadget *tmpgadget = gadget;
		 gadget = cb->NextGadget( *gadget );		
		 cb->Remove( *tmpgadget );
	 }

	 if ( !cfgDialog  || ( cfgDialog && !cfgDialog->IsWindow() ) )
	 {
		 //
		 // Create default toolbar New and associate toolbar buttons with commands.
		 //
		 cb->Insert(*new TButtonGadget(CM_FILENEW, CM_FILENEW));
		 cb->Insert(*new TButtonGadget(CM_FILEOPEN, CM_FILEOPEN));
		 cb->Insert(*new TButtonGadget(CM_FILESAVE, CM_FILESAVE));
		 cb->Insert(*new TSeparatorGadget(6));
		 cb->Insert(*new TButtonGadget(CM_EDITCUT, CM_EDITCUT));
		 cb->Insert(*new TButtonGadget(CM_EDITCOPY, CM_EDITCOPY));
		 cb->Insert(*new TButtonGadget(CM_EDITPASTE, CM_EDITPASTE));
		 cb->Insert(*new TSeparatorGadget(6));
		 cb->Insert(*new TButtonGadget(CM_EDITUNDO, CM_EDITUNDO));
		 cb->Insert(*new TSeparatorGadget(6));
		 cb->Insert(*new TButtonGadget(CM_EDITFIND, CM_EDITFIND));
		 cb->Insert(*new TButtonGadget(CM_EDITFINDNEXT, CM_EDITFINDNEXT));

	 }
	 else
	 {
		 cb->Insert(*new TButtonGadget(BITMAP_1, BITMAP_1));
		 cb->Insert(*new TButtonGadget(BITMAP_2, BITMAP_2));
		 cb->Insert(*new TSeparatorGadget(6));
		 cb->Insert(*new TButtonGadget(BITMAP_3, BITMAP_3));
		 cb->Insert(*new TButtonGadget(BITMAP_4, BITMAP_4));
	 }
	 cb->LayoutSession();
	 
	 // Add fly-over help hints.
	 cb->SetHintMode(TGadgetWindow::EnterHints);

    if ( cb && cb->IsWindow() )
		 cb->Invalidate();

	 //
	 if ( frame && frame->IsWindow() )
	 	 frame->SetFocus();
}


//////////////////////////////////////////////////////////
// switchApp
// =====
// Application intialization.
//
void switchApp::InitMainWindow ()
{
    Client = new TWindow(0, "");
    SDIDecFrame *frame = new SDIDecFrame(0, GetName(), Client, TRUE);

    nCmdShow = nCmdShow != SW_SHOWMINIMIZED ? SW_SHOWNORMAL : nCmdShow;

    //
    // Assign ICON w/ this application.
    //
    frame->SetIcon(this, IDI_SDIAPPLICATION);

    //
    // Menu associated with window and accelerator table associated with table.
    //
    frame->AssignMenu(SDI_MENU);
    
    //
    // Associate with the accelerator table.
    //
    frame->Attr.AccelTable = SDI_MENU;

    SetupSpeedBar(frame);

    TStatusBar *sb = new TStatusBar(frame, TGadget::Recessed,
                                    TStatusBar::CapsLock        |
                                    TStatusBar::NumLock         |
                                    TStatusBar::ScrollLock      |
                                    TStatusBar::Overtype);
    frame->Insert(*sb, TDecoratedFrame::Bottom);
  
    MainWindow = frame;

    //
    // Windows 3-D controls.
    //
    EnableCtl3d(TRUE);
}


//////////////////////////////////////////////////////////
// switchApp
// ===========
// Menu File New command
void switchApp::CmFileNew ()
{
}


//////////////////////////////////////////////////////////
// switchApp
// ===========
// Menu File Open command
void switchApp::CmFileOpen ()
{
    //
    // Display standard Open dialog box to select a file name.
    //
    *FileData.FileName = 0;
    if (Client->CanClose())
        if (TFileOpenDialog(MainWindow, FileData).Execute() == IDOK)
            OpenFile();
}


void switchApp::OpenFile (const char *fileName)
{
    if (fileName)
        lstrcpy(FileData.FileName, fileName);

}


//////////////////////////////////////////////////////////
// switchApp
// =====
// Menu File Close command
void switchApp::CmFileClose ()
{
}


//////////////////////////////////////////////////////////
// switchApp
// ===========
// Menu Help About switch.exe command
void switchApp::CmHelpAbout ()
{
    //
    // Show the modal dialog.
    //
    switchAboutDlg(MainWindow).Execute();
}



//////////////////////////////////////////////////////////
// switchApp
// ===========
// Toolbar active while settings dialog is active
void switchApp::CmBitmap1 ()
{
	 MessageBeep(-1);
}

//////////////////////////////////////////////////////////
// switchApp
// ===========
// Toolbar active while settings dialog is active
void switchApp::CmBitmap2 ()
{
	 MessageBeep(-1);
}


//////////////////////////////////////////////////////////
// switchApp
// ===========
// Toolbar active while settings dialog is active
void switchApp::CmBitmap3 ()
{
	 MessageBeep(-1);
}


//////////////////////////////////////////////////////////
// switchApp
// ===========
// Toolbar active while settings dialog is active
void switchApp::CmBitmap4 ()
{
	 MessageBeep(-1);
}



int OwlMain (int , char* [])
{
    switchApp     App;
    int             result;

    result = App.Run();

    return result;
}

void switchApp::HandleConfigureDialog ()
{
	 // INSERT>> Your code here.
	 // Configure Dialog Menu has been selected!
	 if ( !cfgDialog  || !cfgDialog->IsWindow() )
	 {
		  cfgDialog = new TModelessDialog( GetMainWindow() );
		  cfgDialog->Create();
	 }
}


void switchApp::HandleConfigureDialogCmdEnable (TCommandEnabler &tce)
{
	 // INSERT>> Your code here.
	 // Configure Dialog command enabler
	 if ( !cfgDialog || !cfgDialog->IsWindow() )
		tce.Enable( TRUE );
	 else
		tce.Enable( FALSE );
}


void switchApp::HandleCloseConfigureDialog ()
{
	 // INSERT>> Your code here.
	 // Configure Dialog Menu has been selected!
	 if ( cfgDialog  &&  cfgDialog->IsWindow() )
	 {
    	 cfgDialog->PostMessage( WM_CLOSE, 0, 0 );
	 }
}


void switchApp::HandleCloseConfigureDialogCmdEnable (TCommandEnabler &tce)
{
	 // INSERT>> Your code here.
	 // Configure Dialog command enabler
	 if ( !cfgDialog || !cfgDialog->IsWindow() )
		tce.Enable( FALSE );
	 else
		tce.Enable( TRUE );
}


LRESULT switchApp::HandleWMSetupUI( WPARAM, LPARAM )
{
	 TDecoratedFrame *frame = TYPESAFE_DOWNCAST( GetMainWindow(),
    					                              TDecoratedFrame );
    if ( frame )
    {
	 	 SetupSpeedBar( frame );
	 	if ( !cfgDialog || !cfgDialog->IsWindow() )
          frame->AssignMenu(SDI_MENU);
      else
          frame->AssignMenu(SDI_MENU_WITH_DIALOG);
	 }
	 return 0;
}

