#if !defined(__swtchapp_h)              // Sentry, use file only if it's not already included.
#define __swtchapp_h

/*  Project switch
    Borland International
    Copyright  1993. All Rights Reserved.

    SUBSYSTEM:    switch.exe Application
    FILE:         swtchapp.h
    AUTHOR:       Bruneau Babet


    OVERVIEW
    ========
    Class definition for switchApp (TApplication).      
*/


#include <owl\owlpch.h>
#pragma hdrstop

#include <owl\statusba.h>
#include <owl\controlb.h>
#include <owl\buttonga.h>
#include <owl\opensave.h>

#include "tmdlssdl.h"

#include "swtchapp.rh"            // Definition of all resources.


// User defined message to update tool bar...
const UINT WM_SETUPUI = WM_USER + 0x1000;


//{{TApplication = switchApp}}
class switchApp : public TApplication {
private:
	 TWindow *Client;                                 // Client window for the frame.
	 TOpenSaveDialog::TData FileData;                 // Data to control open/saveas standard dialog.

	 TModelessDialog *cfgDialog;			// Configuration Dialog pointer

private:
	 void SetupSpeedBar(TDecoratedFrame *frame);

public:
    switchApp ();
    virtual ~switchApp ();

    void OpenFile (const char *fileName = 0);
//{{switchAppVIRTUAL_BEGIN}}
public:
    virtual void InitMainWindow();
//{{switchAppVIRTUAL_END}}

//{{switchAppRSP_TBL_BEGIN}}
protected:
    void CmFileNew ();
    void CmFileOpen ();
    void CmFileClose ();
    void CmHelpAbout ();
    void HandleConfigureDialog ();
    void HandleConfigureDialogCmdEnable (TCommandEnabler &tce);

    void HandleCloseConfigureDialog ();
    void HandleCloseConfigureDialogCmdEnable (TCommandEnabler &tce);

	 void CmBitmap1();
	 void CmBitmap2();
	 void CmBitmap3();
	 void CmBitmap4();

    LRESULT HandleWMSetupUI( WPARAM, LPARAM );

//{{switchAppRSP_TBL_END}}
  DECLARE_RESPONSE_TABLE(switchApp);
};    //{{switchApp}}


#endif                                      // __swtchapp_h sentry.
