// bxstrtch.cpp: Demonstrates scrollable windows in graphics mode. 
// A scrollable window will appear which will allow you to inter-
// actively alter the size of a box by using the scroll bars. 
// Alternatively, you can use the arrow, and shift-arrow keys 
// to change the size of the box. To quit the program use ALT-X. 

#include "math.h"
#include "gscroll.h"

class BoxStretcher : public Swso {
public:
  int BoxWd, BoxHt, MaxWd, MaxHt;
  BoxStretcher(int Ba, int Fa, ColorPak &Cp);
  virtual void SetSize(int W, int H);
  virtual void Draw(void);
  virtual void Redraw(void);
  virtual void SendScrollPosn(void);
  virtual void RcvScrollPosn(float P, BarOrient Which);
  virtual void OnKeyStroke(MsgPkt &M);
};

BoxStretcher::BoxStretcher(int Ba, int Fa, ColorPak &Cp)
// Initializes the box stretcher object 
: Swso(Ba, Fa, Cp)
{
  BoxWd = 0; BoxHt = 0;
}

void BoxStretcher::SetSize(int W, int H)
// Sets the size of the window and the start and maximum dimensions
// of the box 
{
  Swso::SetSize(W, H);
  MaxWd = Window->Panel->Interior->Wd; 
  MaxHt = Window->Panel->Interior->Ht;
  if (BoxWd > MaxWd) BoxWd = MaxWd; 
  if (BoxHt > MaxHt) BoxHt = MaxHt; 
}

void BoxStretcher::Draw(void)
// Draws a rectangle centered in the interior of Panel 
{
  Swso::Draw();
  Mouse.Hide();
  setcolor(3);
  setwritemode(XOR_PUT);
  Rso *Wi = Window->Panel->Interior;
    rectangle(Wi->Xul+Wi->Wd / 2 - BoxWd / 2,
              Wi->Yul+Wi->Ht / 2 - BoxHt / 2, 
              Wi->Xul+Wi->Wd / 2 + BoxWd / 2,
              Wi->Yul+Wi->Ht / 2 + BoxHt / 2);
  setwritemode(COPY_PUT);
  Mouse.Show();
}

void BoxStretcher::Redraw(void)
// Due to the inherited Redraw method drawing the box
// twice, and because it's drawn via XOR, we need to 
// draw the box again to make it visible. That's the
// reason for the call to Draw below. 
{
  Swso::Redraw();
  Draw();
}

void BoxStretcher::SendScrollPosn(void)
// Sends message to slide bars to update their positions relative
// to the size of the box 
{
  HzSlide->RcvScrollPosn(float(BoxWd)/float(MaxWd),HzOrient);
  VtSlide->RcvScrollPosn(float(BoxHt)/float(MaxHt),VtOrient);
}

void BoxStretcher::RcvScrollPosn(float P, BarOrient Which)
// Based on the value of P, which should be between 0 and 1, 
// set the size of the box 
{
  Draw();   // Erase old position of box 
  if (Which == HzOrient)
     BoxWd = ceil(P * MaxWd);
     else BoxHt = ceil(P * MaxHt);
  Draw();   // Draw new box 
}

void BoxStretcher::OnKeyStroke(MsgPkt &M)
// Resizes the box according to the keys pressed  
{
  switch(M.Code) {
    case UpKey:
      Draw(); 
      if (BoxHt > 0) BoxHt--;
      Draw();
      SendScrollPosn();   // Update bar position 
    break;
    case DownKey:
      Draw(); 
      if (BoxHt < MaxHt) BoxHt++;
      Draw();
      SendScrollPosn();
    break;
    case LeftKey:
      Draw(); 
      if (BoxWd > 0) BoxWd--;
      Draw();
      SendScrollPosn();
    break;
    case RightKey:
      Draw(); 
      if (BoxWd < MaxWd) BoxWd++;
      Draw(); 
      SendScrollPosn();
    break;
    case ShiftRight:
      Draw(); 
      if ((BoxWd+MaxWd / 8) < MaxWd) 
         BoxWd += MaxWd / 8; else BoxWd = MaxWd;
      Draw(); 
      SendScrollPosn();
    break;
    case ShiftLeft:
      Draw(); 
      if (BoxWd > (MaxWd / 8))
         BoxWd -= MaxWd / 8; else BoxWd = 0;
      Draw(); 
      SendScrollPosn();
    break;
    case ShiftDnKey: 
      Draw(); 
      if ((BoxHt+MaxHt / 8) < MaxHt)
         BoxHt += MaxHt / 8; else BoxHt = MaxHt;
      Draw(); 
      SendScrollPosn();
    break;
    ShiftUpKey:
      Draw(); 
      if (BoxHt > (MaxHt / 8))
        BoxHt -= MaxHt / 8; else BoxHt = 0;
      Draw(); 
      SendScrollPosn();
    break;
    default: Swso::OnKeyStroke(M);
  }
}

BoxStretcher *Bs;
MsgPkt M;
int Gd, Gm;
main()
{
  Gd = DETECT;
  Setup(MouseOptional, Gd, Gm, "\\tcpp\\bgi", SANS_SERIF_FONT);
  FullScrn->Panel->Clear(' ', 0x70);
  Bs = new BoxStretcher(Relief + 3, Closeable, GrphColors);
  Bs->SetSize(301, 151);
  Bs->Open(FullScrn, 75, 75);
  // Set size of box to quarter of window size 
  Bs->BoxWd = Bs->Window->Panel->Interior->Wd / 2;
  Bs->BoxHt = Bs->Window->Panel->Interior->Ht / 2;
  Bs->Draw();
  Bs->SendScrollPosn();
  MainEventLoop();
  CleanUp();
}

