// dialogue.cpp: Dialog box methods

#include <string.h>
#include "dialogue.h"

// -------------------- CmndButton methods --------------------

CmndButton::CmndButton(char *T, ColorPak &Cp)
: Wso(0x00, 0x00, Cp)
{
  strncpy(Text, T, 6);
  Text[6] = 0;  // Ensure null termination
  SetSize(8,1); // Command buttons are always 8 characters long 
  SelectStat = False;
}

void CmndButton::Draw(void)
{
  Wso::Draw();
  Panel->HzWrtB(0, 0, "<      >");
  Panel->HzWrtB((7-strlen(Text)) / 2 + 1, 0, Text);
}

void CmndButton::Prompt(void)
{
  Wso::Prompt();
  Panel->FillB(0,0,Panel->Interior->Wd,1,Panel->Colors.Pc,1);
}

void CmndButton::UnPrompt(void)
{
  if (Active) {
    Panel->FillB(0,0,Panel->Interior->Wd,1,Panel->Colors.Wc,1);
    Wso::UnPrompt();
  }
}

void CmndButton::Activate(MsgPkt &M)
{
  Base->SwitchFocus(M);
  M.RtnCode = Close; // Effectively tells base to close 
}

// --------------------- DlgBox Methods -------------------

void DlgBox::SetSize(int W, int H)
{
  Wso::SetSize(W, H+2);
}

void DlgBox::Draw(void)
{
  int Y;

  Mouse.Hide();
  Wso::Draw();
  // Draw rule two lines from the bottom 
  Y = Panel->Frame->Ht - 3;
  Panel->Frame->Fill(0, Y, 1, 1, 0xC3, Panel->Colors.Bc);
  Panel->Frame->Fill(1, Y, Panel->Frame->Wd-2, 1,
                     0xC4, Panel->Colors.Bc);
  Panel->Frame->Fill(Panel->Frame->Wd-1, Y, 1, 1,
                     0xB4, Panel->Colors.Bc);
  Mouse.Show();
}

// ------------------ MsgBox Methods ------------------------- 

MsgBox::MsgBox(char *T, int Ba, int Fa, ColorPak &Cp)
: DlgBox(Ba, Fa, Cp)
{
  strncpy(Text, T, 39); Text[39] = 0; // Ensure null termination
  SetSize(Panel->TextWidth(T)+2, Panel->TextHeight(3));
  OKButton = new CmndButton("OK", Cp);
}

void MsgBox::Open(Iso *B, int X, int Y)
{
  DlgBox::Open(B, X, Y);
  OKButton->Open(this, 
                 Panel->Frame->Wd - OKButton->Panel->Frame->Wd-4,
                 Panel->Frame->Ht-2);
}

void MsgBox::Draw(void)
{
  DlgBox::Draw();
  // Write message to dialog box 
  Panel->HzWrt(1, 1, Text, 0);
}

