// Dialogue box class definitions: dialogue.h

#ifndef H_DIALOGUE
#define H_DIALOGUE

#include "wsotxscr.h"

class CmndButton : public Wso { // A command button for dialog boxes
public:
  char Text[7];
  int SelectStat;
  CmndButton(char *T, ColorPak &Cp);
  virtual void Draw(void);
  virtual void Activate(MsgPkt &M);
  virtual void Prompt(void);
  virtual void UnPrompt(void);
};

class DlgBox : public Wso { // A dialog box class
public:
  DlgBox(int Ba, int Fa, ColorPak &Cp) : Wso(Ba, Fa, Cp) { ; }
  virtual void SetSize(int W, int H); 
  virtual void Draw(void);
};

class MsgBox : public DlgBox { // A message box class
public: 
  char Text[40];
  CmndButton *OKButton;
  MsgBox(char *T, int Ba, int Fa, ColorPak &Cp);
  virtual void Open(Iso *B, int X, int Y);
  virtual void Draw(void);
};

#endif
