// expense2.cpp -- The object-oriented version of the travel
// expense program
#include <stdio.h>
#include <string.h>

class Expense {             // The trip expense object type
public:
  char TripName[80], Date[80];
  int Mileage, Cost, Fringe;
  void AskQuestions(void);
  void CheckWithBoss(void);
};

Expense ExRec[20];
int ExCount, I;

void Expense::AskQuestions(void)
// This function gathers data for the expense object
{
  printf("Please enter the name of your trip: ");
  scanf("%s", TripName);
  printf("Which date did you leave (mo/day/year)? ");
  scanf("%s", Date);
  printf("Enter the number of miles for your trip: ");
  scanf("%d", &Mileage);
  printf("Enter the cost of your trip: ");
  scanf("%d", &Cost);
  printf("Enter the cost of your meals and entertainment: ");
  scanf("%d", &Fringe);
}

void Expense::CheckWithBoss(void)
// The boss is very tough. He won't approve every trip.
{
  if (!stricmp(TripName,"Hawaii") || !stricmp(TripName,"Tahiti"))
    printf("%s: You are fired for trying to sneak this one by\n",
           TripName);
  else if (Cost/4 < Fringe)
    printf("The fringe expenses for the %s trip are too high\n",
           TripName);
  else
    printf("The %s trip is ok\n", TripName);
}

int main(int, char *)
{
  printf("How many trips did you take? ");
  scanf("%d", &ExCount);
  for (I=0; I<ExCount; I++)   // Get expense data for each employee
    ExRec[I].AskQuestions();
  for (I=0; I<ExCount; I++)   // Write out the boss's response
    ExRec[I].CheckWithBoss();
  return 0;
}

