// expense3.cpp -- The object-oriented version of the travel
// expense program that uses inheritance to handle executive
// employees differently
//
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <conio.h>

class Expense {             // The trip expense object type
public:
  char TripName[80], Date[80];
  int Mileage, Cost, Fringe;
  virtual void AskQuestions(void);   // Use virtual because we'll
  virtual void CheckWithBoss(void);  // override in ExecutiveExp
};

class ExecutiveExp : public Expense {
public:
  int Rating;
  virtual void AskQuestions(void);   // The virtual keyword is
  virtual void CheckWithBoss(void);  // optional here
};

void Expense::AskQuestions(void)
// This function gathers data for the expense object
{
  printf("Please enter the name of your trip: ");
  scanf("%s", TripName);
  printf("Which date did you leave (mo/day/year)? ");
  scanf("%s", Date);
  printf("Enter the number of miles for your trip: ");
  scanf("%d", &Mileage);
  printf("Enter the cost of your trip: ");
  scanf("%d", &Cost);
  printf("Enter the cost of your meals and entertainment: ");
  scanf("%d", &Fringe);
}

void Expense::CheckWithBoss(void)
// The boss is very tough. He won't approve every trip.
{
  if (!stricmp(TripName,"Hawaii") || !stricmp(TripName,"Tahiti"))
    printf("%s: You are fired for trying to sneak this one by\n",
           TripName);
  else if (Cost / 4 < Fringe)
    printf("The fringe expenses for the %s trip are too high\n",
           TripName);
  else
    printf("The %s trip is ok\n", TripName);
}

void ExecutiveExp::AskQuestions(void)
// This function gathers data for the executive expense object
{
  Expense::AskQuestions();   // Call the inherited version
  printf("How would you rate the trip (0-10)? ");
  scanf("%d", &Rating);
}

void ExecutiveExp::CheckWithBoss(void)
// The boss is very easy on executives
{
  if (Cost / 2 < Fringe)
    printf("Watch it. You're not having enough fun!\n");
}

Expense *ExRec[20];      // Array of pointers to base class type
int ExCount, I;
unsigned char Executive; // True is user is an executive

int main(int, char *)
{
  // Determine if the user is an executive or not. If so,
  // use the ExecutiveExp class.
  printf("Are you an executive (y/n) ");
  if (toupper(getch()) == 'Y') Executive = 1; else Executive = 0;
  printf("\nHow many trips did you take? ");
  scanf("%d", &ExCount);
  // Allocate enough objects, of the correct type, for the
  // number of trips taken. Which objects get placed in the
  // array depend on whether the user is an executive or not.
  for (I=0; I<ExCount; I++)
    if (Executive)
      ExRec[I] = new ExecutiveExp;
    else
      ExRec[I] = new Expense;
  // The following are polymorphic calls. We use the same
  // call to reference ExecutiveExp and Expense objects.
  for (I=0; I<ExCount; I++)   // Get expense data for each object
    ExRec[I]->AskQuestions();
  for (I=0; I<ExCount; I++)   // Write out the boss's response
    ExRec[I]->CheckWithBoss();
  return 0;

}

