// fsounit.cpp: FSO Class Implementation

#include "fsounit.h"

Fso::Fso(int Ba, int Fa, ColorPak &Cp)
// Sets up the frame and border attributes and assigns the three
// Rso's (Frame, Interior, and Overall) to NULL. The Rso's should be 
// initialized by a derived class. 
{
  Bwd      = Ba & 0x000f;        // Unpack the border width 
  Bstyle   = (Ba >> 4) & 0x000f; // and the border type     
  Fattr    = Fa;
  Colors   = Cp;
  Frame    = NULL;               // Must be set by derived 
  Interior = NULL;               // class
  Overall  = NULL;
}

int Fso::IsSwappable(void) { return (Fattr & Swappable) != 0; }

int Fso::IsCloseable(void) { return (Fattr & Closeable) != 0; }

int Fso::IsStretchable(void) 
{
  return (Fattr & Stretchable) && IsSwappable(); 
}

int Fso::HasShadow(void) { return (Fattr & AnyShadow) != 0; }

int Fso:: OnFrame(int X, int Y)
{ 
  return Frame->Contains(X, Y); 
}

int Fso::OnInterior(int X, int Y)
{ 
  return Interior->Contains(X, Y); 
}

int Fso::OnBorder(int X, int Y)
{ 
  return Frame->Contains(X,Y) && !Interior->Contains(X,Y); 
}

int Fso::OnCloseButton(int /*X*/, int /*Y*/)
// Checks to see if the location X,Y resides on close button.
// Fso's don't have a close button, but a derived type might.
{
  return False;
}

int Fso::Touches(Fso *F) 
{ 
  return Overall->Touches(F->Overall); 
}

// The following screen transfer routines use the interior 
// rectangle. Also, the attributes can be defaulted to their 
// stored values.

void Fso::Scroll(ScrollDir Sd, int Amt) 
{ 
  Interior->Scroll(Sd, Amt); 
}

void Fso::HzWrt(int X, int Y, char *Str, char Attr)
{
  if (Attr == 0) Attr = Colors.Wc;
  Interior->HzWrt(X, Y, Str, Attr);
}

void Fso::HzWrtB(int X, int Y, char *Str)
{ 
  Interior->HzWrtB(X,Y,Str); 
}

void Fso::Fill(int X, int Y, int W, int H, char Ch, char Attr)
{
  if (Attr == 0) Attr = Colors.Wc;
  Interior->Fill(X, Y, W, H, Ch, Attr);
}

void Fso::FillB(int X, int Y, int W, int H, char Ch, char Opt)
{
  Interior->FillB(X, Y, W, H, Ch, Opt);
}

void Fso::Box(int X, int Y, int W, int H,  char Ba, char Attr)
{
  if (Attr == 0) Attr = Colors.Bc;
  if (Ba == 0) Ba = (Bstyle << 4) + Bwd;
  Interior->Box(X, Y, W, H, Ba, Attr);
}

// The default arrangement is for the rectangles to be on 
// top of one another as given in these default SetSize and 
// SetLocn routines

void Fso::SetSize(int W, int H) 
{
  Interior->SetSize(W, H);
  Frame->SetSize(W, H);
  Overall->SetSize(W, H);
}

void Fso::SetLocn(int Xl, int Yl) 
{
  Frame->SetLocn(Xl, Yl);
  Overall->SetLocn(Xl, Yl);
  Interior->SetLocn(Xl, Yl);
}




