// gbutntst.cpp: Tests the graphics buttons.
// Press on Exit button to quit or type ALT-X key combination. 

#include <string.h>
#include "grphscrn.h"
#include "gbutton.h"

void ChangeTextAction(Wso *Src, MsgPkt &)
// Changes the text on a button 
{
  TextButton *Tb = (TextButton *)Src;
  if (!strcmp(Tb->Str, "Press"))
    strcpy(Tb->Str, "Press Again");
    else strcpy(Tb->Str, "Press");
  Tb->ChangeText(Tb->Str, Tb->Font);
}

// ---------- Some routines to draw icon ----------- 

void DrawRightArrow(Wso *Src)
// Draws a right arrow icon 
{
  int MidX, MidY;
  Mouse.Hide();
  MidX = Src->Panel->Interior->Xul + Src->Panel->Interior->Wd / 2;
  MidY = Src->Panel->Interior->Yul + Src->Panel->Interior->Ht / 2;
  setcolor(ForeGround(Src->Panel->Colors.Wc));
  moveto(MidX+6,MidY+6);
  lineto(MidX+6,MidY-6);
  lineto(MidX-2,MidY-6);
  lineto(MidX-2,MidY-10);
  lineto(MidX-8,MidY);
  lineto(MidX-2,MidY+10);
  lineto(MidX-2,MidY+6);
  lineto(MidX+6,MidY+6);
  setfillstyle(SOLID_FILL,ForeGround(Src->Panel->Colors.Wc));
  floodfill(MidX,MidY,ForeGround(Src->Panel->Colors.Wc));
  Mouse.Show();
}

void DrawLeftArrow(Wso *Src)
// Draws a left arrow icon 
{
  int MidX, MidY;
  Mouse.Hide();
  MidX = Src->Panel->Interior->Xul + Src->Panel->Interior->Wd / 2;
  MidY = Src->Panel->Interior->Yul + Src->Panel->Interior->Ht / 2;
  setcolor(ForeGround(Src->Panel->Colors.Wc));
  moveto(MidX-6,MidY+6);
  lineto(MidX-6,MidY-6);
  lineto(MidX+2,MidY-6);
  lineto(MidX+2,MidY-10);
  lineto(MidX+8,MidY);
  lineto(MidX+2,MidY+10);
  lineto(MidX+2,MidY+6);
  lineto(MidX-6,MidY+6);
  setfillstyle(SOLID_FILL,ForeGround(Src->Panel->Colors.Wc));
  floodfill(MidX,MidY,ForeGround(Src->Panel->Colors.Wc));
  Mouse.Show();
}

main()
{
  TextButton *ExitButton;
  IconButton *LeftButton;
  IconButton *RightButton;
  TextButton *ChangeButton;
  TextButton *CloseButton;
  int Gd, Gm;

  Gd = DETECT;
  Setup(MouseOptional, Gd, Gm, "\\tcpp\\bgi", SANS_SERIF_FONT);
  FullScrn->Panel->Clear(' ', 0x70);
  LeftButton = new IconButton(DrawLeftArrow, Relief+3,
     Swappable, GrphColors, NoOp);
  RightButton = new IconButton(DrawRightArrow, Relief+3,
     Swappable, GrphColors, NoOp);
  ExitButton = new TextButton("Exit", "roman", Relief+3,
     Swappable, GrphColors, ExitAction);
  ChangeButton = new TextButton("Press", "roman", Relief+3,
     Swappable+OutlineMove, GrphColors, ChangeTextAction);
  CloseButton = new TextButton("Close Me", "roman", Relief+3,
     Swappable+OutlineMove+Closeable, GrphColors, NoOp);

  LeftButton->Open(FullScrn, 20, 20);   // Buttons default to 25 by 25 
  RightButton->Open(FullScrn, 70, 20);  // pixels in size 
  ExitButton->SetSize(25, 40);
  ExitButton->Open(FullScrn, 200, 20);
  ChangeButton->SetSize(100, 50);
  ChangeButton->Open(FullScrn, 150, 125);
  CloseButton->SetSize(75, 25);
  CloseButton->Open(FullScrn, 250, 250);
  MainEventLoop();
  CleanUp();
}


