// gbutton.cpp: Graphics button class implementations

#include <string.h>
#include "gbutton.h"

// ----------------------- TextButton ----------------------- 

TextButton::TextButton(char *S, char *F, int Ba, int Fa,
                       ColorPak &Cp, ActionProc A)
: Wso(Ba, Fa, Cp)
{
  strcpy(Str, S);
  strcpy(Font, F);
  SetSize(25, 25);  // Default size  
  Action = A;
}

void TextButton::ChangeText(char *S, char *F)
// Re-displays the text on a button with the new string S and
// the new font F 
{
  strcpy(Str, S);
  strcpy(Font, F);
  Draw();
}

void TextButton::Draw(void)
// Scales and writes the text within a button 
{
  if (*Str == 0) return;
  Rso *Pint = Panel->Interior;
  setusercharsize(1,1,1,1);
  setusercharsize(Pint->Wd, textwidth(Str),
                  Pint->Ht, textheight(Str) * 4 / 3);
  // Clear out where text is to appear 
  Mouse.Hide();
  Pint->Fill(0, 0, Pint->Wd, Pint->Ht, ' ', Panel->Colors.Wc);
  // Write the text centered on the face of the button 
  setviewport(Pint->Xul,Pint->Yul,Pint->Xlr,Pint->Ylr,True);
  setcolor(ForeGround(Panel->Colors.Wc));
  settextjustify(CENTER_TEXT, CENTER_TEXT);
  outtextxy(Pint->Wd/2+2, Pint->Ht/2, Str);
  // Restore clip region to whole screen 
  setviewport(0, 0, getmaxx(), getmaxy(), True);
  Mouse.Show();
}

void TextButton::Activate(MsgPkt &M)
// Performs the buttons action if the object is currently
// selected, else the button is de-selected 
{
  if (Active) {
    Wso::Activate(M);
    Action(this, M);
  }
  else Leave(M);
}

// ----------------------- IconButton -------------------------- 

IconButton::IconButton(DrawProc D, int Ba, int Fa, 
                       ColorPak &Cp, ActionProc A)
: Wso(Ba, Fa, Cp)
{
  SetSize(25, 25);  // Default size  
  DrawIcon = D;
  Action = A;
}

void IconButton::Draw(void)
// Draws the icon in the button's interior after calling
// the inherited version of Draw 
{
  Wso::Draw();
  DrawIcon(this);
}

void IconButton::Activate(MsgPkt &M)
// Performs the buttons action if the object is currently
// selected, else the button is de-selected 
{
  if (Active) {
     Wso::Activate(M);
     Action(this, M);
  }
  else Leave(M);
}

// ------------- Common button actions defined ----------- 

void NoOp(Wso *, MsgPkt &)
// A sample action that doesn't do anything 
{
  ;
}

void ExitAction(Wso *, MsgPkt &M)
// A sample action that causes the window system to shutdown 
{
  M.RtnCode = ShutDown;
}

