// gbutton.h: Graphics button class definitions

#ifndef H_GBUTTON
#define H_GBUTTON

#include "grphscrn.h"

typedef void (*ActionProc)(Wso *Src, MsgPkt &M);
typedef void (*DrawProc)(Wso *Src);

class TextButton : public Wso {
public:
  ActionProc Action;
  char Str[80];
  char Font[80];
  TextButton(char *S, char *F, int Ba, int Fa, 
             ColorPak &Cp, ActionProc A);
  virtual void Draw(void);
  virtual void Activate(MsgPkt &M); 
  virtual void ChangeText(char *S, char *F);
};

class IconButton : public Wso {
public:
  ActionProc Action;
  DrawProc DrawIcon;
  IconButton(DrawProc D, int Ba, int Fa, ColorPak &Cp, ActionProc A);
  virtual void Draw(void);
  virtual void Activate(MsgPkt &M); 
};

// ---------------- Some common button actions -------------- 

void NoOp(Wso *Src, MsgPkt &M);
void ExitAction(Wso *Src, MsgPkt &M);

#endif


