// gfsounit.h: Provides graphics mode "frames" that are used in
// the Iso screen objects. A frame consists of an interior, panel,
// and overall object. 

#ifndef H_GFSOUNIT
#define H_GFSOUNIT

#include "fsounit.h"
#include "grsounit.h"

class Gfso : public Fso { // A graphics frame screen object 
public:
  char *SaveBuff, *SwapBuff;
  unsigned SaveSize;
  Grso *CloseBox;
  int HeaderHt;
  Gfso(int Ba, int Fa, ColorPak &Cp);
  virtual ~Gfso(void);
  virtual void SetSize(int W, int H); 
  virtual void SetLocn(int Xl, int Yl); 
  virtual void DrawFrame(char Ba, char Attr); 
  virtual void Clear(char Ch, char Attr);
  virtual void GetImage(Rect *C);
  virtual void PutImage(Rect *C);
  virtual void Swap(Rect *C, XfrDirn Xd);
  virtual int  OnCloseButton(int X, int Y);
  virtual int  TextWidth(char *Str);
  virtual int  TextHeight(int N);
};

class Gskel : public Fso { // Graphics skeleton
public:
  Gskel(ColorPak &Cp);
  virtual void DrawFrame(char Ba, char Attr);
  virtual void Swap(Rect *C, XfrDirn Xd);
};

#endif

