// gmenutst.cpp: Implements pull-down, tear-away menus in graphics 
// mode. This program is very similar to the text mode program
// in Chapter 11.

#include "string.h"
#include "grphscrn.h"
#include "msounit.h"

void ExitAction(Wso *, MsgPkt &M)
{
  M.RtnCode = ShutDown;
}

void NoAction(Wso *, MsgPkt &) { ; }

void PopupAction(Wso *Src, MsgPkt &M)
// Pop-up a window with the name of the object written in it 
{
  Wso *B;
  char Label[80];

  strcpy(Label, ((Meso *)(Src))->Name);
  strcat(Label, " Action");

  ((Meso *)Src)->OnClose(M);         // Close pull-down window 
  M.Code = M.RtnCode;
  FullScrn->SubMgr->EventStep(M);
  // Open pop-up window 
  B = new Wso(Relief+3, WindowStyle-BorderPrompt, GrphColors);
  B->SetSize(B->Panel->TextWidth(Label), B->Panel->TextHeight(2));
  B->Open(FullScrn, 300, 100); // Hard coded location of pop-up window 
  B->Panel->HzWrt(0, 0, Label, 0);
  B->SwitchFocus(M);
  M.RtnCode = Idle; M.Code = Idle;
  do {                          // Wait until a person closes window 
    B->SubMgr->EventStep(M);    // or pressed ALT-X. 
    M.Code = M.RtnCode;
  } while (!((M.Code == ShutDown) ||
             (B->Active && M.Code == Close && 
             M.Focus == ((Iso *)(B)))));
  if (M.Code == Close) {
     B->OnClose(M);
     Mouse.WaitForEvent(MouseUp, M.Mx, M.My);
     M.RtnCode = Idle;
  }
  delete B;
}

// Horizontal pulldown menu
Pmeso *FileBut;
Dmso *FileMenu;
MesoList *FileMList;
Meso *NewBut;
Meso *OpenBut;
Meso *SaveBut;
Meso *CloseBut;
Meso *VtExitBut;
// Edit menu 
Pmeso *EditBut;
Dmso *EditMenu;
MesoList *EditMList;
Meso *CutBut;
Meso *CopyBut;
Meso *PasteBut;
// Action menu 
Pmeso *ActionBut;
Dmso *PanicMenu;
MesoList *PanicMList;
Meso *PanicBut;
Meso *CalmBut;
// Main header menu 
Pmso *Hm;
MesoList *HzMenuList;

int Gd, Gm;
int GmenuStyle;
main()
{
  Gd = DETECT;
  Setup(MouseRequired, Gd, Gm, "\\tcpp\\bgi", SANS_SERIF_FONT);
  GmenuStyle = WindowStyle - BorderPrompt;

  // Allocate and setup the menu system 
  FileMList = new MesoList();
  NewBut = new Meso("New", PopupAction);
  FileMList->Append(NewBut);
  OpenBut = new Meso("Open", PopupAction);
  FileMList->Append(OpenBut);
  SaveBut = new Meso("Save", PopupAction);
  FileMList->Append(SaveBut);
  CloseBut = new Meso("Close", PopupAction);
  FileMList->Append(CloseBut);
  VtExitBut = new Meso("Exit", ExitAction);
  FileMList->Append(VtExitBut);
  FileMenu = new Dmso(FileMList, 90, Relief+3, GmenuStyle, GrphColors);

  EditMList = new MesoList();
  CutBut = new Meso("Cut", PopupAction);
  EditMList->Append(CutBut);
  CopyBut = new Meso("Copy", PopupAction);
  EditMList->Append(CopyBut);
  PasteBut = new Meso("Paste", PopupAction);
  EditMList->Append(PasteBut);
  EditMenu = new Dmso(EditMList, 90, Relief+3, GmenuStyle, GrphColors);

  PanicMList = new MesoList();
  PanicBut = new Meso("Panic", PopupAction);
  PanicMList->Append(PanicBut);
  CalmBut = new Meso("Don't Panic", PopupAction);
  PanicMList->Append(CalmBut);
  PanicMenu = new Dmso(PanicMList, 90, Relief+3, GmenuStyle, GrphColors);

  HzMenuList = new MesoList;
  FileBut = new Pmeso("File", FileMenu);
  HzMenuList->Append(FileBut);
  EditBut = new Pmeso("Edit", EditMenu);
  HzMenuList->Append(EditBut);
  ActionBut = new Pmeso("Panic", PanicMenu);
  HzMenuList->Append(ActionBut);
  Hm = new Pmso(HzMenuList, 300, 200, 20, 0x33, GmenuStyle, GrphColors);

  // Draw a background to the screen 
  Hm->Open(FullScrn, 0, 0);
  Hm->Inner->Panel->Clear(' ', 0x70);
  MainEventLoop();
  CleanUp();
}
