// grphscrn.cpp:  A set of utilities used in the graphics 
// applications in Chapters 13 and 14 

#include <stdio.h>
#include "grphscrn.h"

Wso *FullScrn;
MsgPkt StartMsg;

void Setup(int MouseOpt, int &GDriver, int &GMode,
           char *DriverPath, unsigned Font)
// Configures the graphics screen and mouse. Gmode is the graphics mode
// to use. It should be one of QP's constants defined in MsGraph. MouseOpt
// can be one of the options listed at the {ning of this file.
// FontPath and FontStyle specify the font to be used in the application.
// It also sets up the FullScrn object which will be the root window for
// all windows on the screen. 
{
  int ErrCode;

  initgraph(&GDriver,&GMode,DriverPath);
  ErrCode = graphresult();
  if (ErrCode != grOk) {
    printf("Graphics error: %s",grapherrormsg(ErrCode));
    exit(1);   
  }
  if (MouseOpt != NoMouse) {
     // Setup mouse according to graphics mode used 
     if (getmaxx() == 320) Mouse.Setup(LowResGr);
     else if (GDriver == HERCMONOHI) Mouse.Setup(HerculesGr);
     else Mouse.Setup(Graphics);
     if ((!Mouse.SetupOK()) && (MouseOpt == MouseRequired)) {
	 closegraph();
	 printf("Unable to initialize mouse.");
	 exit(1);
     }
  }
  settextstyle(Font,HORIZ_DIR,4);
  FullScrn = new Wso(0x00, 0x00, MonoColors);
  FullScrn->SetSize(getmaxx(),getmaxy());
  StartMsg = NullMsg;
}

void MainEventLoop(void)
// Starts up the main event loop by calling the FullScrn object's
// EventLoop method. But first, set the focus to the top Iso. 
{
  if (FullScrn->SubMgr->Top != NULL)
     FullScrn->SubMgr->Top->SwitchFocus(StartMsg);
  FullScrn->SubMgr->EventLoop(StartMsg);
}

void CleanUp(void)
// Restore screen to its default mode and turn off the mouse 
{
  delete FullScrn;
  Mouse.TurnOff();
  closegraph();
}

