#include "grsounit.h"

// grsounit.cpp: Graphics-Based Rectangular Screen Object Definitions
// These routines use the built-in rectangle to clip the 
// transfers. They also take care of the mouse cursor as well.  

Grso::Grso(void)
// Initializes a Grso object. Note: It saves the height of the current
// font being used. This font style is assumed to be the currently
// registered font while this Grso object is being used. 
: Rso(0, 0, 0, 0)
{
  TxtHt = ::textheight("H") * 4 / 3;
}

void Grso::HzWrt(int X, int Y, char *Str, char Attr)
// Writes a string to a Grso object. The string is clipped to
// the boundaries of the object. The text is displayed using
// the foreground color of the Attr parameter. The region below
// the text is cleared using the background color of Attr. 
{
  int W, H; 
  viewporttype Vp;

  getviewsettings(&Vp);
  W = TextWidth(Str);
  setviewport(Xul,Yul,Xlr,Ylr,1);
  H = TextHeight(1);
  FillB(X, Y, W, H, Attr, 1);
  Mouse.Hide();
  setcolor(ForeGround(Attr));
  outtextxy(X, Y, Str);
  setviewport(Vp.left, Vp.top, Vp.right, Vp.bottom, Vp.clip);
  Mouse.Show();
}

void Grso::HzWrtB(int X, int Y, char *Str)
// Writes a string to this object. The string is clipped. Note that
// this routine does not clear the space where the text is displayed
// and that it uses the current drawing color--whatever it may be. 
{
  viewporttype Vp;
  getviewsettings(&Vp);
  setviewport(Xul,Yul,Xlr,Ylr,1);
  Mouse.Hide();
  outtextxy(X, Y, Str);
  Mouse.Show();
  setviewport(Vp.left, Vp.top, Vp.right, Vp.bottom, Vp.clip);
}

void Grso::Fill(int X, int Y, int W, int H,  char, char Attr)
// Fills a region with a particular color. Note: The unnamed
// parameter, which should be the fill character, is ignored.
{
  if (((H == 1) && HzClip(X, Y, W)) ||
      ((W == 1) && VtClip(X, Y, H)) ||
      (VtClip(X,Y,H) && HzClip(X,Y,W)))  {
     Mouse.Hide();
     setfillstyle(SOLID_FILL,BackGround(Attr));
     bar(Xul+X, Yul+Y, Xul+X+W-1, Yul+Y+H-1);
     Mouse.Show();
  }
}

void Grso::FillB(int X, int Y, int W, int H, char Ch, char)
// Fills a region. Note: This interpretation is different than
// its text-mode counterpart in trsounit.cpp. The last parameter,
// which is the Opt parameter, is ignored.
{
  Fill(X, Y, W, H, ' ', Ch);
}

void Grso::Box(int X, int Y, int W, int H, char Ba, char Attr)
// Draws a box
{
  unsigned char Bw, Bs, B;
  int I, Xs, Ys, Xf, Yf;

  Bw = Ba & 0x000f;          // Unpack the border width
  Bs = (Ba >> 4) & 0x000f;   // and the border style
  if ((Bs > 0) && (Bs < 4)) {
     Mouse.Hide();
     if (Bs == 1) {
	for (I = 0; I < Bw; I++) {
	  setcolor(ForeGround(Attr));
	  rectangle(Xul+X, Yul+Y, Xul+X+W-1, Yul+Y+H-1);
	  X++; Y++; W -= 2; H -= 2;
	}
     }
     else { // Use a 3D style
       if ((Bs << 4) == Recessed) {
	  B = ForeGround(Attr);
	  Attr = BackGround(Attr) + (B << 4);
       }
       Xs = X+Xul; Xf = Xs + W - 1;
       Ys = Y+Yul; Yf = Ys + H - 1;
       for (I = 0; I < Bw; I++) {
	 setcolor(BackGround(Attr));
	 moveto(Xs+I, Yf-I);
	 lineto(Xs+I, Ys+I);
	 lineto(Xf-I, Ys+I);
	 setcolor(ForeGround(Attr));
	 moveto(Xf-I, Ys+I+1);
	 lineto(Xf-I, Yf-I);
	 lineto(Xs+I+1, Yf-I);
       }
     }
     Mouse.Show();
  }
}

int Grso::TextWidth(char *Str)
// Returns the pixel width of a string 
{
  return ::textwidth(Str);
}

int Grso::TextHeight(int N)
// Returns the pixel height of N rows of text 
{
  return TxtHt*N;
}


