// gscroll.h: Provides classes to draw scroll bars and scroll bar 
// windows in graphics mode 

#ifndef H_GSCROLL
#define H_GSCROLL

#include "grphscrn.h"

const int HzScrollMove = 0xfe00;
const int VtScrollMove = 0xfe01;
const int BorderWd = 3;   // Border width is three pixels 

enum BarOrient { HzOrient, VtOrient };

class Slider : public Wso {
public:
  // Correction: Pg 367, Cp passed by reference, not
  //             by pointer as in book
  Slider(ColorPak &Cp);
  virtual void Move(int X, int Y);
  virtual void OnMouseEnter(MsgPkt &M);
  virtual void OnMouseLeave(MsgPkt &M);
  virtual void OnMouseDown(MsgPkt &M);
  virtual void OnKeyStroke(MsgPkt &M);
};

class ScrollBar : public Wso {
public:
  BarOrient Orientation;
  Slider *Slide;
  char InhibitMessage;
  ScrollBar(BarOrient Orient, ColorPak &Cp);
  virtual void SetSize(int W, int H);
  virtual void Open(Iso *B, int X, int Y);
  virtual void Redraw(void);
  virtual void OnMouseEnter(MsgPkt &M);
  virtual void OnMouseLeave(MsgPkt &M);
  virtual void OnMouseDown(MsgPkt &M);
  virtual void SendScrollPosn(void);
  virtual void RcvScrollPosn(float P, BarOrient Which);
  virtual void OnKeyStroke(MsgPkt &M);
};

class Swso : public Wso {
public:
  ScrollBar *HzSlide, *VtSlide;
  Wso *Window;
  Swso(int Ba, int Fa, ColorPak &Cp);
  virtual void SetSize(int W, int H);
  virtual void Open(Iso *B, int X, int Y);
  virtual void Redraw(void);
  virtual void SendScrollPosn(void) { ; }
  virtual void RcvScrollPosn(float, BarOrient) { ; }
  virtual void Dispatch(MsgPkt &M);
};

#endif

