// gwsounit.cpp:
// Provides graphics screen objects based on the Iso type. In particular,
// this type overrides the prompting and moving methods in order to
// implement them according to the specifics of graphics mode. 

#include "gwsounit.h"

Wso::Wso(int Ba, int Fa, ColorPak &Cp)
// Initializes a Wso object as a Gfso object passed to Iso 
: Iso(new Gfso(Ba, Fa, Cp))
{
  return; 
}

void Wso::MoveLoop(MsgPkt &M)
// Moves a Swappable object by using a skeleton if the OutlineMove
// bit is set. Otherwise the object is moved by swapping the image
// in and out of screen memory. 
{
  Gskel *Red;
  Iso   *Skeleton;
  ColorPak C;

  if (Panel->IsSwappable()) {
     if ((Panel->Fattr & OutlineMove) != 0) {
       C = MonoColors;
       C.Bc = 0xff;  // Use white for border color for XOR lines 
       Red = new Gskel(C);
       Red->SetSize(Panel->Frame->Wd, Panel->Frame->Ht);
       Skeleton = new Iso(Red); // Make a skeleton Iso
       Skeleton->Open(Base, 
                      Panel->Frame->Xul-Base->Panel->Interior->Xul,
                      Panel->Frame->Yul-Base->Panel->Interior->Yul);
       Skeleton->MoveLoop(M);
       Skeleton->Remove();
       if ((Panel->Frame->Xul != Skeleton->Panel->Frame->Xul) ||
           (Panel->Frame->Yul != Skeleton->Panel->Frame->Yul)) 
           Move(Skeleton->Panel->Frame->Xul, 
               Skeleton->Panel->Frame->Yul);
       delete Skeleton;
     }
     else Iso::MoveLoop(M); // Just move whole window around
  }
}

void Wso::Prompt()
// Graphics mode prompting is accomplished by redrawing the frame of
// the object using the prompt color, Pc. 
{
  Iso::Prompt();
  if ((Panel->Bstyle > 0) &&
      ((Panel->Fattr & BorderPrompt) != 0))
      Panel->DrawFrame(0, Panel->Colors.Pc);
}

void Wso::UnPrompt(void)
// Restores the object's border by redrawing it using its default colors 
{
  if (Active) {
     if ((Panel->Bstyle > 0) && ((Panel->Fattr & BorderPrompt) != 0))
         Panel->DrawFrame(0, 0);  // 0, 0 means use default 
     Iso::UnPrompt();
  }
}
















