// mgrphtst.cpp: Tests the mouse in graphics mode using the 
// cursor shapes defined in mcursor.cpp
#include <stdlib.h>
#include <conio.h>
#include <graphics.h>
#include "msmouse.h"

int Err, Mx, My, Gd, Gm, Quad, OldQuad;
unsigned E;       

main()
{
  Gd = DETECT;
  initgraph(&Gd, &Gm, "c:\\tcpp\\bgi");  // Initialize graphics mode
  if (graphresult() != grOk) { // Graphics initialization failed
    cprintf("A graphics adapter is required for this program.\r\n");
    exit(1);
  }
  // Draw and label quadrants
  moveto(getmaxx() / 2, 0);
  lineto(getmaxx() / 2, getmaxx());
  moveto(0, getmaxy() / 2);
  lineto(getmaxx(), getmaxy() / 2);
  outtextxy(1, 1, "ArrowCursor");
  outtextxy((getmaxx()/2)+4, 1, "HandCursor");
  outtextxy(1, (getmaxy()/2)+4, "LeftRightCursor");
  outtextxy((getmaxx()/2)+4, (getmaxy()/2) + 4, "UpDownCursor");
  Mouse.Setup(Graphics);    // Initialize the mouse
  if (!Mouse.Operating()) {
    closegraph();
    cprintf("Mouse not detected.\n");
    exit(1);
  }
  Mouse.SetGCursor(ArrowCursor);  // Use this as default cursor
  OldQuad = Quad = 1;
  do {
    E = Mouse.Event(Mx,My);
    if (Mx > getmaxx() / 2) {
       if (My > getmaxy() / 2) Quad = 4; else Quad = 2;
    }
    else {
      if (My > getmaxy() / 2) Quad = 3; else Quad = 1;
    } 
    if (Quad != OldQuad) {
       switch(Quad) {
         case 1: Mouse.SetGCursor(ArrowCursor); break;
         case 2: Mouse.SetGCursor(HandCursor); break;
         case 3: Mouse.SetGCursor(LeftRightCursor); break;
         case 4: Mouse.SetGCursor(UpDownCursor); break;
       };
    }
    OldQuad = Quad;
  } while (E != MouseDown);
  Mouse.TurnOff();
  closegraph();
  return 0;
}

