// mousetst.cpp: This program tests part of the mouse object in text mode 
#include "stdlib.h"
#include "bios.h"
#include "conio.h"
#include "msmouse.h"

unsigned E;
int Mx, My;
char Ch;

main()
{
  Mouse.Setup(TextScrn);     // Initialize the mouse 
  if (!Mouse.SetupOK()) {    // Mouse intialization failed 
    cprintf("Mouse not detected.\r\n");
    exit(0);
  }

  clrscr();      // Setup and draw the screen
  gotoxy(35,12); cprintf("Press here to\r\n");
  gotoxy(35,13); cprintf("quit program\r\n");
  gotoxy(1,21);  cprintf("Current Button Event : No event\r\n");
  gotoxy(1,23);  cprintf("Mouse location (X,Y) : \r\n");
  gotoxy(1,1);   cprintf("Press here to disable mouse     \r\n");

  do { // Main interaction loop 
    E = Mouse.Event(Mx, My);
    switch(E) {
      case LMouseDown: 
        gotoxy(23,21); cprintf("LPressed   \r\n"); 
      break;
      case RMouseDown:
        gotoxy(23,21); cprintf("RPressed   \r\n"); 
      break;
      case LMouseStillDown: 
        gotoxy(23,21); cprintf("LStill Down\r\n");
      break;
      case RMouseStillDown: 
        gotoxy(23,21); cprintf("RStill Down\r\n"); 
      break;
      case LMouseUp:
        gotoxy(23,21); cprintf("LMouseUp   \r\n"); 
      break;
      case RMouseUp:
        gotoxy(23,21); cprintf("RMouseUp   \r\n"); 
      break;
    }
    gotoxy(23,23); cprintf("(%d,%d)     \r\n", Mx, My);
    if ((E == LMouseDown) && (Mx >= 0) &&
       (Mx <= 26) && (My == 0)) {
       // Disable mouse until a key is pressed 
       Mouse.TurnOff();
       gotoxy(1,1); cprintf("Press any key to re-enable mouse\r\n");
       bioskey(0);
       gotoxy(1,1); cprintf("Press here to disable mouse     \r\n");
       Mouse.TurnOn();
    }
  } while ((E != MouseDown) || (Mx <= 33) || (Mx >= 47) ||
          (My <= 10) || (My >= 13));
  Mouse.TurnOff(); // Generally, you should turn off the mouse at end
}

