// Mouse class: msmouse.h 

#ifndef H_MSMOUSE
#define H_MSMOUSE

// Defines graphics mouse cursor styles

struct HotSpotStruct { int X, Y; };

struct MouseCursor {
  HotSpotStruct HotSpot;
  unsigned ScreenMask[16];
  unsigned CursorMask[16];
};

extern const MouseCursor ArrowCursor;
extern const MouseCursor HandCursor;
extern const MouseCursor LeftRightCursor;
extern const MouseCursor UpDownCursor;

// Mouse event codes 

const unsigned Idle             = 0x0000;
const unsigned MouseDown        = 0xff01;
const unsigned LMouseDown       = 0xff01;
const unsigned RMouseDown       = 0xff02;
const unsigned MouseStillDown   = 0xff04;
const unsigned LMouseStillDown  = 0xff04;
const unsigned RMouseStillDown  = 0xff08;
const unsigned MouseUp          = 0xff10;
const unsigned LMouseUp         = 0xff10;
const unsigned RMouseUp         = 0xff20;
const unsigned MouseEnter       = 0xff40;
const unsigned MouseLeave       = 0xff80;
const unsigned MouseWithin      = 0xffc0;

// Mouse Button Masks 

const unsigned  LeftButton      =  0x0001;
const unsigned  RightButton     =  0x0002;

// The video modes that the mouse is running under
enum VideoModeType {TextScrn, LowResGr, HerculesGr, Graphics};

// The mouse class 

class MouseObject {
protected:
  int OldX, OldY;   // Used solely by Moved to keep        
  char OK;          // True if mouse initialized           
  char MouseOff;    // True if mouse is disabled (Default) 
  char LowRes;      // True if in 320x200 graphics mode    
  char TextMode;    // True if in text mode                
public:
  int X, Y, Dx, Dy; // Keeps track of the mouse's movement       
  MouseObject(void);
  void Setup(VideoModeType VideoMode);
  int  DriverExists(void);
  int  SetupOK(void);
  void Hide(void);
  void Show(void);
  unsigned Status(int &Mx, int &My);
  unsigned ButtonStatus(void);
  int PressCnt(unsigned ButtonMask);
  int ReleaseCnt(unsigned ButtonMask);
  unsigned Event(int &Mx, int &My);
  unsigned WaitForAnyEvent(int &Mx, int &My);
  void WaitForEvent(unsigned E, int &Mx, int &My);
  int  Moved(void);
  void Move(int Mx, int My);
  void TurnOn(void);
  void TurnOff(void);
  int  Operating(void);
  void SetGCursor(const MouseCursor &NewCursor);
};

extern MouseObject Mouse;

#endif
