// msounit.h: Menu screen object (mso) class definitions

#ifndef H_MSOUNIT
#define H_MSOUNIT

// Conditional directives used to determine which files 
// should be included 

#ifdef GRAPHICS
#include "gwsounit.h"
#else
#include "twsounit.h"
#endif

typedef void (*ActionProc)(Wso *Src, MsgPkt &M);

// --------- Generic menu entry screen object type --------- 

class Meso : public Wso {
public:
 char Name[40];      // Menu entry label
 ActionProc Action;  // The action assigned to the entry
 Meso *Next;         // References the next menu entry 
 Meso(char *N, ActionProc A);
 virtual void Draw(void);
 virtual void Prompt(void);
 virtual void UnPrompt(void);
 virtual void OnKeyStroke(MsgPkt &M); 
 virtual void OnClose(MsgPkt &M); 
 virtual void Activate(MsgPkt &M); 
};

class MesoList { // A circular list for storing menu entries
public: 
  Meso *Last;     // Referencs last menu entry on list
  MesoList(void);
  virtual ~MesoList(void);
  virtual void Append(Meso *Me); 
};

class Mso : public Wso {     // The menu screen object type 
public:
  MesoList *Entries;         // The list of menu entries 
  Meso *CurrSeln;            // The selected menu entry
  int EntriesDrawn;          // "Entries have been drawn" flag
  int Nrows, Ncols, Spacing; // Menu dimensions
  Mso(MesoList *El, int Nc, int Nr, int Sp, int W, int H,
      int Bd, int Fa, ColorPak &Cp);
  virtual void SetupDim(int &Nc, int &Nr, int &W, int &H); 
  virtual int EntryWidth(Meso *Me);
  virtual void SetupEntries(void);
  virtual int  IsHz(void) { return Nrows == 1; }
  virtual int  IsVt(void) { return Ncols == 1; }
  virtual void Open(Iso *B, int X, int Y);
  virtual void MoveLoop(MsgPkt &M);
  virtual void Activate(MsgPkt &M);
  virtual void Leave(MsgPkt &M);
  virtual void OnKeyStroke(MsgPkt &M);
  virtual void Forw(MsgPkt &M);
  virtual void Back(MsgPkt &M);
};

// ------ Types used to support pull-down menu systems ------ 

// This type is used to create a pull-down menu bar 

class PullDnBar : public Mso {
public:
  Mso *SubMso;
  PullDnBar(MesoList *Items, int W, int Sp, ColorPak &Cp);
  virtual void OnKeyStroke(MsgPkt &M); 
};

// This type is used to create a pull-down menu system 

class Pmso : public Wso {
public:
  PullDnBar *Bar;       // The pull-down menu bar
  Wso *Inner;           // The window region for the menu system
  Pmso(MesoList *Items, int W, int H, int Sp,
       int Ba, int Fa, ColorPak &Cp);
  virtual void Open(Iso *B, int X, int Y);
};

// This type is used to create an entry for the pull-down menu bar 

class Dmso; // Forward reference

class Pmeso : public Meso {
public:
 Dmso *Vm; // The drop menu assigned to the menu entry
 Pmeso(char *N, Dmso *D);
 virtual void SwitchFocus(MsgPkt &M);
 virtual void OnKeyStroke(MsgPkt &M);
};

// This type is used to create a drop menu 

class Dmso : public Mso {
public:
  Pmeso *Parent; // The top-level menu that the drop menu 
                 // is assigned to 
  Dmso(MesoList *Items, int W, int Ba, int Fa, ColorPak &Cp);
  virtual void OnClose(MsgPkt &M);
  virtual void OnKeyStroke(MsgPkt &M);
};

#endif
