// optexmpl.cpp: This simple program demonstrates how you can create
// a simple dialog box--like those in QP--that displays a list of options

#include <string.h>
#include "dialogue.h"

// Event says a list of options is being passed

const int PassedOpts = 0xfd00;

class OptButton : public Wso {
public:
  char Text[40];
  int SelectStat;
  OptButton(char *T, ColorPak &Cp);
  virtual void Draw(void);
  virtual void Activate(MsgPkt &M); 
  virtual void Prompt(void);
  virtual void UnPrompt(void);
};

// ----------------------- Option Type -------------------- 

OptButton::OptButton(char *T, ColorPak &Cp)
: Wso(0x00, 0x00, Cp)
{
  strcpy(Text, "[ ] ");
  strncat(Text,T,35); Text[39] = 0; // Ensure null termination
  SetSize(strlen(Text), 1);
  SelectStat = False;
}

void OptButton::Draw(void)
{
  Wso::Draw();
  Panel->HzWrtB(0, 0, Text);
}

void OptButton::Prompt(void)
{
  if (!Active) {
     Wso::Prompt();
     Panel->FillB(0, 0, 3, 1, Panel->Colors.Pc, 1);
  }
}

void OptButton::UnPrompt(void)
{
  if (Active) {
     Panel->FillB(0, 0, 3, 1, Panel->Colors.Wc, 1);
     Wso::UnPrompt();
  }
}

void OptButton::Activate(MsgPkt &)
{
  if (SelectStat) {
    Panel->HzWrtB(1, 0, " ");
    SelectStat = False;
  }
  else {
    Panel->HzWrtB(1, 0, "X");
    SelectStat = True;
  }
}

void PopupOpt(Wso *W, MsgPkt &M)
// Popup a dialogue box containing several options 
{
  DlgBox     *DB;
  OptButton  *IoOpt;
  OptButton  *StackOpt;
  OptButton  *RangeOpt;
  CmndButton *OK;
  CmndButton *Cancel;

  DB = new DlgBox(0x11, WindowStyle-BorderPrompt, InvColors);
  DB->SetSize(30,5);
  DB->Open(W, (W->Panel->Interior->Wd-DB->Panel->Overall->Wd) / 2,
              (W->Panel->Interior->Ht-DB->Panel->Overall->Ht) / 2);
  DB->Panel->Interior->Box(4,2,22,5,0x11,DB->Panel->Colors.Wc);
  DB->Panel->Interior->HzWrtB(7,0,"Compiler Options");

  IoOpt = new OptButton("I/O Checking", InvColors);
  IoOpt->Open(DB, 6, 3);
  StackOpt = new OptButton("Stack Checking", InvColors);
  StackOpt->Open(DB, 6, 4);
  RangeOpt = new OptButton("Range Checking", InvColors);
  RangeOpt->Open(DB, 6, 5);

  OK = new CmndButton("OK", InvColors);
  Cancel = new CmndButton("Cancel", InvColors);

  OK->Open(DB,
           DB->Panel->Frame->Wd - OK->Panel->Frame->Wd -
           Cancel->Panel->Frame->Wd-6,
           DB->Panel->Frame->Ht-2);
  Cancel->Open(DB,
               DB->Panel->Frame->Wd - Cancel->Panel->Frame->Wd-4,
               DB->Panel->Frame->Ht-2);

  M.RtnCode = Idle; M.Code = Idle;
  OK->SwitchFocus(M);
  do {
    DB->SubMgr->EventStep(M);
    M.Code = M.RtnCode;
  } while (M.Code != ShutDown &&
          (!DB->Active || M.Code != Close || M.Focus != (Iso *)DB));
  if (M.Code == Close) {
     DB->OnClose(M);
     M.RtnCode = Idle;
  }
  delete DB;
}

main()
{
  Setup(MouseOptional, CyanColors);
  FullScrn->Panel->Clear(177, 0x07);
  PopupOpt(FullScrn, StartMsg);
  CleanUp();
}

