// Screen style definitions

#ifndef H_SCRNSTY
#define H_SCRNSTY

inline unsigned char ForeGround(unsigned char attr)
{
  return attr & 0x0f;
}

inline unsigned char BackGround(unsigned char attr)
{
  return (attr >> 4) & 0x0f;
}

enum LineChar { 
  Ulc, Llc, Urc, Lrc, LTee, RTee, UpTee, DnTee, HzBar, VtBar
};

extern char LineChars[4][10];

enum ScrollDir  { UpScroll, DnScroll, LeftScroll, RightScroll };

struct ColorPak { unsigned char Bc, Wc, Tc, Pc, Fc; };

// Border styles

const int NoBorder = 0x00; // For both text and graphics
const int Single   = 0x10; // For text mode
const int Double   = 0x20; // For text mode
const int Dashed   = 0x30; // For text mode
const int Solid    = 0x10; // For graphics mode
const int Recessed = 0x20; // For graphics mode
const int Relief   = 0x30; // For graphics mode

// Frame styles

const int Swappable    = 0x01;
const int Closeable    = 0x02;
const int SEShadow     = 0x04;
const int NEShadow     = 0x08;
const int NWShadow     = 0x10;
const int SWShadow     = 0x20;
const int OutlineMove  = 0x40;
const int BorderPrompt = 0x80;
const int Stretchable  = 0x100;

// A shadow bit mask

const int AnyShadow = SEShadow + NEShadow + NWShadow + SWShadow;

// A set of predefined color packs and styles

extern ColorPak BlueColors;
extern ColorPak CyanColors;
extern ColorPak RedColors;
extern ColorPak InvColors;
extern ColorPak MonoColors;
extern ColorPak ErrColors;
extern ColorPak MsgColors;
extern ColorPak GrphColors;
extern ColorPak DefColors;

extern ColorPak DefColors;
extern int WithShadow;
extern int WindowStyle;
extern int ButtonStyle;

#endif






