// This program calls most of the functions in TxUnit and Keybrd
 
#include <dos.h>
#include "txunit.h"
#include "keybrd.h"

main()
{
  int K, X, Y;

  TxBuff Scrn(VideoPtr());
  Scrn.SetSize(80, 25);  // REMEMBER TO ALWAYS CALL SETSIZE

  // Put a white fill pattern on the screen 

  Scrn.Fill(0, 0, 80, 25, 176, 0x0f);

  // Alias another txbuff region to start at (30,7)   
  // Note that the size must still reflect full scrn! 

  TxBuff Win(Scrn.Txram);
  Win.SetSize(80, 25);
  Win.SetLocn(30, 7);

  // Save a 23 x 7 portion of the screen starting at this region 
  // into a save buffer, allocated off the heap 

  TxBuff SaveBuff(0);
  SaveBuff.SetSize(23, 7);
  SaveBuff.Xfr(0, 0, 23, 7, &Win, 0, 0);

  // Draw a white window with a shadow. Note that the shadow only 
  // shows up in color mode. Coordinates are relative to Win.     

  Win.Fill(0, 0, 21, 6, ' ', 0x70);
  Win.FillB(21, 1, 2, 6, 0x08, 1); // vertical shadow 
  Win.FillB(1, 6, 22, 1, 0x08, 1); // horizontal shadow 

  // Put some lines of text on the window. Note how we must skip 
  // over the length byte, and  pass the length of the string. 

  Win.HzWrtB(1, 1, "I am a window. Use");
  Win.HzWrtB(1, 2, "shift arrow keys to");
  Win.HzWrtB(1, 3, "move me. Use ENTER");
  Win.HzWrtB(1, 4, "key to quit ...   ");

  // Move the window in an event loop. Look for shift arrow
  // keys, and move the window by swapping to and from
  // the save buffer. Quit when Esc key is pressed and put
  // window back where it came from. 

  X = 30; Y = 7;

  do {
    K = bioskey(0);  // Wait for keypress
    if (IsShiftArrow(K))  {
       Scrn.Swap(X, Y, 23, 7, &SaveBuff, 0, 0);  // Hide
       switch (K) {
         case ShiftLeft:  if (X > 0)  X--;      break;
         case ShiftRight: if (X < (80-23)) X++; break;
         case ShiftUpKey: if (Y > 0)  Y--;      break;
         case ShiftDnKey: if (Y < (25-7)) Y++;  break;
         default: ;
       }
       Scrn.Swap(X, Y, 23, 7, &SaveBuff, 0, 0);  // Show
       Win.SetLocn(X, Y); // Make sure to set new location too! 
    }
  } while (K != CrKey);

  /* Move window back to center */

  Scrn.Swap(X, Y, 23, 7, &SaveBuff, 0, 0);
  Scrn.Swap(30, 7, 23, 7, &SaveBuff, 0, 0);
  Win.SetLocn(30,7); // Make sure to set window coordinates 

  // Put new messages up. go through loop and move
  // a little single character scanner until keypress

  Win.Fill(0, 0, 21, 6, ' ', 0x70);
  Win.HzWrtB(2, 1, "Now, below is a ");
  Win.HzWrtB(2, 2, "scanner. Press  ");
  Win.HzWrtB(2, 3, "Enter to stop it");

  X = 0;
  do {
   Win.Fill(X,4,1,1,' ',0x70);  // Erase scanner
   if (X < 19) X++; else X = 1;
   Win.Fill(X,4,1,1,176,0x70);  // Draw scanner
   delay(10);
   K = KeyEvent();  // Look for, but don't wait for keypress
  } while (K == 0);

  // Now put up some menu entries. Use up and down arrow to
  // select menu entry. Cr Key selects choice, Esc Key quits. 

  char *MenuChoices[4] = {
    "Do Something",
    "Be Lazy     ",
    "Just Say No ",
    "Go to Miami "
  };

  Win.Fill(0, 0, 21, 6, ' ', 0x70);
  Win.HzWrtB(1, 1, MenuChoices[0]);
  Win.HzWrtB(1, 2, MenuChoices[1]);
  Win.HzWrtB(1, 3, MenuChoices[2]);
  Win.HzWrtB(1, 4, MenuChoices[3]);

  Win.HzWrt(0, 8,  "Use arrow keys to move", 0x7f);
  Win.HzWrt(0, 9,  "highlight. Use ENTER  ", 0x7f);
  Win.HzWrt(0, 10, "to select, ESC to     ", 0x7f);
  Win.HzWrt(0, 11, "abort ...             ", 0x7f);

  X = 1; Y = 1;
  Win.HzFillB(X, Y, 0x07, 1, 19);     // Put up first highlight 

  do {
    K = bioskey(0);                   // Wait for key
    Win.HzFillB(X, Y, 0x70, 1, 19);   // Erase old highlight
    switch (K) {
      case UpKey:   if (Y > 1)  Y--; else Y = 4; break;
      case DownKey: if (Y < 4) Y++; else Y = 1;  break;
      default: ;
    }
    Win.HzFillB(X, Y, 0x07, 1, 19);   // Put up new highlight
  } while ((K != CrKey) && (K != EscKey));

  Win.Fill(0, 8, 22, 4, 176, 0x0f);

  // Process the choice

  if (K == CrKey)  {
     char Saywhat[80];
     strcpy(Saywhat, "Sorry, we won't let you ");
     strcat(Saywhat, MenuChoices[Y-1]);
     Win.HzWrt(0, 8, Saywhat, 0x7f);
  }
  else {
     Win.HzWrt(0, 8, "Can't make up your mind, huh?", 0x7f);
  }


  // Scroll up a line. Put in another menu entry

  Win.HzWrt(0, 9, "But press RETURN and watch the menu scroll!", 0x7f);
  bioskey(0);

  Win.Scroll(1, 1, 19, 4, UpScroll, 1);
  Win.HzWrtB(1, 4, "*** The End ***");

}
