// tfsounit.h: Text-Based Framed Screen Object (Tfso) Class

#ifndef H_TFSOUNIT
#define H_TFSOUNIT

#include <string.h>
#include "trsounit.h"
#include "fsounit.h"

class Tfso : public Fso {
public:
  Trso *SaveBuff;
  Tfso *HzShadow, *VtShadow;
  Tfso(int Ba, int Fa, ColorPak &Cp);
  virtual ~Tfso(void);
  virtual void SetSize(int W, int H); 
  virtual void SetLocn(int Xl, int Yl); 
  virtual int  OnCloseButton(int X, int Y); 
  virtual void DrawFrame(char Ba, char Attr);
  virtual void Clear(char Ch, char Attr);
  virtual void GetImage(Rect *C);
  virtual void PutImage(Rect *C);
  virtual void ShadowXfr(Rect *C, XfrDirn Xd, int DrawIt);
  virtual void DrawShadows(Rect *C, XfrDirn Xd, int Drawit);
  virtual void Swap(Rect *C, XfrDirn Xd);
  virtual int  TextWidth(char *Str) { return strlen(Str); }
  virtual int  TextHeight(int N)    { return N; }
};

// --- Text based "skeleton" framed screen objects --- 

class Tskel : public Fso {
public:
  Trso *Sides[4]; // Top, Bottom, Left, Right
  Tskel(ColorPak &Cp);
  virtual ~Tskel(void);
  virtual void SetSize(int W, int H); 
  virtual void DrawFrame(char Ba, char Attr);
  virtual void GetImage(Rect *C);
  virtual void PutImage(Rect *C);
  virtual void Swap(Rect *C, XfrDirn Xd);
};

extern TxBuff ScrnBuff; // The text buffer representing the screen

#endif

