// tmenu1.cpp: Menu test program

#include "wsotxscr.h"
#include "msounit.h"

void ExitAction(Wso *, MsgPkt &M)
// Quits the pull-down menu program 
{
  M.RtnCode = ShutDown;
}

void PopupAction(Wso *Src, MsgPkt &M)
// Displays a pop-up menu for the menu entry selected 
{  
  Wso *B;
  char Buff[80];
  ((Meso *)Src)->OnClose(M);    // Close the sub-menu 
  M.Code = M.RtnCode;           // Use the return code
  FullScrn->SubMgr->EventStep(M);
  // Create the pop-up window 
  B = new Wso(0x11, WindowStyle, DefColors);
  strcpy(Buff, ((Meso *)Src)->Name);
  strcat(Buff, " Action");
  B->SetSize(B->Panel->TextWidth(Buff), B->Panel->TextHeight(2));
  B->Open(FullScrn, 30, 10);
  B->Panel->HzWrt(0, 0, Buff, 0);
  B->SwitchFocus(M);
  M.RtnCode = Idle; M.Code = Idle;
  do {
    B->SubMgr->EventStep(M);
    M.Code = M.RtnCode;
  } while (M.Code != ShutDown &&
          (!B->Active || M.Code != Close || M.Focus != (Iso *)(B)));
  if (M.Code == Close) {
     B->OnClose(M);
     Mouse.WaitForEvent(MouseUp, M.Mx, M.My);
     M.RtnCode = Idle;
  }
  delete B; // Remove the window
  // Control is now returned to the menu
}

MesoList *MList;
Meso *Entry1, *Entry2, *Entry3, *Entry4, *Entry5;
Mso *Menu1;

main()
{
  // ------------------------Part 1------------------------------
  DefColors = CyanColors;           // Setup the display colors 
  Setup(MouseOptional, DefColors);  // Setup the environment 
  MList = new MesoList;             // Create the menu list
  // Add each menu entry to the list 
  Entry1 = new Meso("New", PopupAction);
  MList->Append(Entry1);
  Entry2 = new Meso("Open", PopupAction);
  MList->Append(Entry2);
  Entry3 = new Meso("Save", PopupAction);
  MList->Append(Entry3);
  Entry4 = new Meso("Close", PopupAction);
  MList->Append(Entry4);
  Entry5 = new Meso("Exit", ExitAction);
  MList->Append(Entry5);
  // ---------------Part 2: Create the menu object----------------
  Menu1 = new Mso(MList, 1, 5, 1, 15, 5, 0x11,
                 WithShadow+Swappable, DefColors);
  FullScrn->Panel->Clear(177,4);
  Menu1->Open(FullScrn, 10, 5);
  MainEventLoop();
  CleanUp();
}

