// tmenutst.cpp: Menu test program

#include "wsotxscr.h"
#include "msounit.h"

void ExitAction(Wso *, MsgPkt &M)
// Quits the pull-down menu program 
{
  M.RtnCode = ShutDown;
}

void NoAction(Wso *, MsgPkt &)
// No action here 
{  
  return;
}

void PopupAction(Wso *Src, MsgPkt &M)
// Displays a pop-up menu for the menu entry selected 
{  
  Wso *B;
  char Buff[80];
  ((Meso *)Src)->OnClose(M);    // Close the sub-menu 
  M.Code = M.RtnCode;
  FullScrn->SubMgr->EventStep(M);
  // Create the pop-up window 
  B = new Wso(0x11, WindowStyle, DefColors);
  strcpy(Buff, ((Meso *)Src)->Name);
  strcat(Buff, " Action");
  B->SetSize(B->Panel->TextWidth(Buff), B->Panel->TextHeight(2));
  B->Open(FullScrn, 30, 10);
  B->Panel->HzWrt(0, 0, Buff, 0);
  B->SwitchFocus(M);
  M.RtnCode = Idle; M.Code = Idle;
  do {
    B->SubMgr->EventStep(M);
    M.Code = M.RtnCode;
  } while (M.Code != ShutDown &&
          (!B->Active || M.Code != Close || M.Focus != (Iso *)(B)));
  if (M.Code == Close) {
     B->OnClose(M);
     Mouse.WaitForEvent(MouseUp, M.Mx, M.My);
     M.RtnCode = Idle;
  }
  delete B;
}

Pmeso *FileBut;      // The File Button
Dmso *FileMenu;      // The File drop menu 
MesoList *FileMList; // The list of entries for File 
Meso *NewBut;
Meso *OpenBut;
Meso *SaveBut;
Meso *CloseBut;
Meso *VtExitBut;

Pmeso *EditBut;      // The Edit button
Dmso *EditMenu;      // The Edit drop menu
MesoList *EditMList; // The list of entries for Edit
Meso* CutBut;
Meso *CopyBut;
Meso *PasteBut;

Pmeso *ViewBut;      // The View button
Dmso *ViewMenu;      // The View drop menu
MesoList *ViewMList; // The list of entries for View
Meso *AsciiBut;
Meso *HexBut;

 Pmso *Hm;             // The horizontal pull-down menu
 MesoList *HzMenuList; // The list of entries for the pull-down 
                       // menu bar 

main()
{
  DefColors = CyanColors;
  Setup(MouseOptional, DefColors);
  // ------------Part 1: Setup the File drop menu---------- 
  FileMList = new MesoList;
  NewBut = new Meso("New", PopupAction);
  FileMList->Append(NewBut);
  OpenBut = new Meso("Open", PopupAction);
  FileMList->Append(OpenBut);
  SaveBut = new Meso("Save", PopupAction);
  FileMList->Append(SaveBut);
  CloseBut = new Meso("Close", PopupAction);
  FileMList->Append(CloseBut);
  VtExitBut = new Meso("Exit", ExitAction);
  FileMList->Append(VtExitBut);
  FileMenu = new Dmso(FileMList, 15, 0x11, WindowStyle, DefColors);
  // ----------Part 2: Setup the Edit drop menu----------
  EditMList = new MesoList;
  CutBut = new Meso("Cut", PopupAction);
  EditMList->Append(CutBut);
  CopyBut = new Meso("Copy", PopupAction);
  EditMList->Append(CopyBut);
  PasteBut = new Meso("Paste", PopupAction);
  EditMList->Append(PasteBut);
  EditMenu = new Dmso(EditMList, 15, 0x11, WindowStyle, DefColors);
  // ----------Part 3: Setup the View drop menu---------
  ViewMList = new MesoList;
  AsciiBut = new Meso("Ascii", PopupAction);
  ViewMList->Append(AsciiBut);
  HexBut = new Meso("Hex", PopupAction);
  ViewMList->Append(HexBut);
  ViewMenu = new Dmso(ViewMList, 15, 0x11, WindowStyle, DefColors);
  // ----------Part 4: Setup the main menu bar----------
  HzMenuList = new MesoList;
  FileBut = new Pmeso("File", FileMenu);
  HzMenuList->Append(FileBut);
  EditBut = new Pmeso("Edit", EditMenu);
  HzMenuList->Append(EditBut);
  ViewBut = new Pmeso("View", ViewMenu);
  HzMenuList->Append(ViewBut);
  Hm = new Pmso(HzMenuList, 80, 25, 3, 0x00, 0x00, CyanColors);
  Hm->Open(FullScrn, 0, 0);
  Hm->Inner->Panel->Clear(177, 4); 
  MainEventLoop();                    // Start the event loop 
  CleanUp();
}

