// trtest.cpp: Test programd to demonstrate clipping abilities of Trso's

#include <string.h>
#include <stdlib.h>
#include <dos.h>
#include "trsounit.h"
#include "keybrd.h"

main()
{
  // ------------------------- Part 1 ------------------------ 
  // Create a screen buffer, clear the screen, and draw a box. 
  // ---------------------------------------------------------
  TxBuff ScrnBuff(VideoPtr()); 
  ScrnBuff.SetSize(80,25);
  Trso Screen(&ScrnBuff);  // Create a Trso, aliased to the screen 
  Screen.SetSize(80, 25);  // Default locn is (0,0)
  // Clear the screen with a fill pattern
  Screen.Fill(0, 0, Screen.Wd, Screen.Ht, 176, 0x07);
  // Draw a reverse video, single line box in the middle of it
  Screen.Box(30, 8, 15, 5, 0x11, 0x70);
  // ------------------------- Part 2 ------------------------
  // Create a small window, alias it to the screen. Blank
  // out the window, and clip some text on it.
  // ---------------------------------------------------------
  Trso Window(&ScrnBuff);
  Window.SetLocn(31, 9); // Place and size our window */
  Window.SetSize(13, 3); // to be inside our box 
  // Blank out the window 
  Window.Fill(0, 0, Window.Wd, Window.Ht, ' ', 0x07);
  // Here's an example of left- and right-hand clipping
  Window.HzWrt(-10, 1, "Hey, you: press any key now", 0x07);
  bioskey(0);
  // ------------------------- Part 3 ------------------------
  // Now, erase the box and window, and resize and reposition
  // the box and window, and show clipping of some boxes
  // inside the window.
  // ---------------------------------------------------------
  Screen.Fill(0, 0, Screen.Wd, Screen.Ht, 176, 0x07);
  Screen.Box(20, 4, 42, 17, 0x11, 0x70);
  Window.SetLocn(21, 5);
  Window.SetSize(40, 15);
  Window.Box(35, 5,  15, 4, 0x11, 0x07); // Clip to right
  Window.Box(27, -2, 15, 4, 0x11, 0x07); // Clip to top-right
  Window.Box(-5, -3, 15, 4, 0x11, 0x07); // Clip to top-left
  Window.Box(-5, 5,  15, 4, 0x11, 0x07); // Clip to left
  Window.Box(-2, 13, 15, 4, 0x11, 0x07); // Clip to bottom-left
  Window.Box(35, 13, 15, 4, 0x11, 0x07); // Clip to bottom-right
  // All the screen object destructors called automatically
}

