// twsounit.cpp: Twso Class Implementation
#include "twsounit.h"

Wso::Wso(int Ba, int Fa, ColorPak &Cp)
// Initializes a text window screen object by typing the 
// Iso's panel to be a Tfso. 
: Iso(new Tfso(Ba,Fa,Cp))
{
  return; // Nothing else to do
}

void Wso::MoveLoop(MsgPkt &M)
// The move loop drags a skeleton outline around, and 
// when the mouse button is released, the Wso is moved to the
// same location as the skeleton. If the Wso does not have the 
// "outline move" attribute, the Wso is dragged directly. 
{
  Tskel *Red;
  Iso   *Skeleton;

  if (Panel->IsSwappable()) {
    if ((Panel->Fattr & OutlineMove) != 0) {
       Red = new Tskel(Panel->Colors);
       Red->SetSize(Panel->Interior->Wd, Panel->Interior->Ht);
       Skeleton = new Iso(Red);
       Skeleton->Open(Base,
                      Panel->Frame->Xul-Base->Panel->Interior->Xul,
                      Panel->Frame->Yul-Base->Panel->Interior->Yul);
       Skeleton->MoveLoop(M);
       Skeleton->Remove();
       if ((Panel->Frame->Xul != Skeleton->Panel->Frame->Xul) ||
           (Panel->Frame->Yul != Skeleton->Panel->Frame->Yul)) 
       Move(Skeleton->Panel->Frame->Xul,
            Skeleton->Panel->Frame->Yul);
       delete Skeleton;
    }
    else { // Call inherited version which moves the whole window
      Iso::MoveLoop(M);
    } 
  }
}

void Wso::StretchLoop(MsgPkt &M)
// Very similar to MoveLoop 
{
  Tskel *Red;
  Iso   *Skeleton;

  if (Panel->IsStretchable()) {
    if ((Panel->Fattr & OutlineMove) != 0) {
       Red = new Tskel(Panel->Colors);
       Red->SetSize(Panel->Interior->Wd, Panel->Interior->Ht);
       Skeleton = new Iso(Red);
       Skeleton->Open(Base,
                      Panel->Frame->Xul-Base->Panel->Interior->Xul,
                      Panel->Frame->Yul-Base->Panel->Interior->Yul);
       Skeleton->StretchLoop(M);
       Skeleton->Remove();
       if ((Panel->Frame->Wd != Skeleton->Panel->Frame->Wd) ||
           (Panel->Frame->Ht != Skeleton->Panel->Frame->Ht)) 
       // Need to subtract borders from size
       Stretch(Skeleton->Panel->Frame->Wd-2,
               Skeleton->Panel->Frame->Ht-2);
       delete Skeleton;
    }
    else { // Call inherited version which stretches the whole window
      Iso::StretchLoop(M);
    } 
  }
}

void Wso::Prompt(void)
// Prompts by drawing a double border (if there is a border) 
{
  Iso::Prompt(); // Do inherited prompting
  if ((Panel->Bstyle > 0) &&
      ((Panel->Fattr & BorderPrompt) != 0))  
     Panel->DrawFrame(Double + Panel->Bwd, 0);
}

void Wso::UnPrompt(void)
// Unprompts by restoring the border to its original attributes 
{
  if (Active) {
     if ((Panel->Bstyle > 0) && 
         ((Panel->Fattr & BorderPrompt) != 0))  
        Panel->DrawFrame(0, 0); // 0, 0 means use default 
     Iso::UnPrompt(); // Do inherited unprompting
  }
}

