// txscroll.h: Implements scrollable windows in text mode 

#ifndef H_TXSCROLL
#define H_TXSCROLL

#include "wsotxscr.h"

// Scroll bar event code
const int HzScrollMove = 0xfe00; 
const int VtScrollMove = 0xfe01;

enum BarOrient { HzOrient, VtOrient };

// The slider frame type sets up a "frame" that's simply
// a character bar with two arrows at the end. The bar
// can be either horizontal or vertical. 

class ScrollFrame : public Tfso {
public:
  BarOrient Orientation;
  // Correction: pg 292, Cp passed by reference, not by
  //             pointer as in book
  ScrollFrame(BarOrient Orient, ColorPak &Cp);
  virtual void SetSize(int W, int H);
  virtual void SetLocn(int Xl, int Y);
  virtual void DrawFrame(char Ba, char Attr);
};

// The Slider Button Type 

class Slider : public Wso {
public:
  // Correction: pg 293, Cp passed by reference, not
  //             by pointer as in book
  Slider(ColorPak &Cp) : Wso(0x00, Swappable, Cp) { ; }
  virtual void Draw(void);
  virtual void OnMouseDown(MsgPkt &M);
  virtual void Move(int X, int Y);
  virtual void OnKeyStroke(MsgPkt &M);
};

// The slider bar type. We inherit from Iso, and set the panel
//  of the Iso to be a slider frame. 

class ScrollBar : public Iso {
public:
  Slider *Slide;
  int DelayCntr, DelayLimit;
  int InhibitMessage;
  // Correction: pg 293, Cp passed by reference, not by
  //             pointer as in book
  ScrollBar(BarOrient Orient, ColorPak &Cp);
  virtual void Draw(void);
  virtual void Redraw(void);
  virtual void Open(Iso *B, int X, int Y);
  virtual void BorderHandler(MsgPkt &M); 
  virtual void OnMouseDown(MsgPkt &M);
  virtual void OnMouseStillDown(MsgPkt &M);
  virtual void SendScrollPosn(void);
  virtual void RcvScrollPosn(float P, BarOrient Which);
  virtual void OnKeyStroke(MsgPkt &M); 
};

// An Abstract Scroll Window Screen Object Type 

class Swso : public Wso {
public:
  ScrollBar *HzSlide, *VtSlide;
  // Correction: pg 293, Cp should be passed by reference,
  //             not by pointer as in book
  Swso(int Fa, ColorPak &Cp);
  virtual void SetSize(int W, int H);
  virtual void Stretch(int W, int H);
  virtual void Open(Iso *B, int X, int Y);
  virtual void Redraw(void);
  virtual void Prompt(void);
  virtual void UnPrompt(void);
  virtual void SendScrollPosn(void) { ; }
  virtual void RcvScrollPosn(float, BarOrient) { ; }
  virtual void Dispatch(MsgPkt &M); 
};

#endif

