// vw.cpp: Implements a scrollable window with a virtual buffer 

#include <math.h>
#include "txscroll.h"

// A specific type of Swso scroll window: a virtual window 

class Vwso : public Swso {
public:
  Trso *VirtBuff;
  int Vx, Vy;
  // Correction: Pg 280, Cp passed by reference, not by
  //             pointer as shown in the book
  Vwso(int Fa, ColorPak &Cp);
  virtual ~Vwso(void);
  virtual void Draw(void);
  virtual void Open(Iso *B, int X, int Y);
  virtual void OnKeyStroke(MsgPkt &M);
  virtual void SendScrollPosn(void);
  virtual void RcvScrollPosn(float P, BarOrient Which);
};

// ---------------------- Vwso Methods ---------------------- 

// Correction: pg 281, Cp passed by reference, not by
//             by pointer as in book
Vwso::Vwso(int Fa, ColorPak &Cp)
// Initialize Vwso object and its virtual buffer 
: Swso(Fa, Cp)
{
  Vx = 0;  Vy = 0;
  VirtBuff = new Trso(NULL);
  VirtBuff->SetSize(100, 100); // Hard-coded as 100x100 characters
}

Vwso::~Vwso(void)
// Free virtual buffer 
{
  delete VirtBuff;
}

void Vwso::Draw(void)
// Put a portion of the virtual buffer up on the screen 
{
  Trso *Tp;

  Swso::Draw();
  Tp = (Trso *)(Panel->Interior);
  // Copy from virtual buffer at (Vx, Vy) to the interior
  Tp->Xfr(0, 0, Tp->Wd, Tp->Ht, VirtBuff, Vx, Vy);
}


char Line1[] = "0123456789012345678901234567890123456789";
char Line2[] = "abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz";
char Line3[] = "ABCDEFGHIJKLMNOPQRSTUVWXYZABCDEFGHIJKLMNOPQRSTUVWXYZ";
char Last[]  = "Bottom-Right of virtual buffer";

void Vwso::Open(Iso *B, int X, int Y) 
// First, fill virtual buffer with some stuff, open up 
{
  // Clear virtual buffer with a red graphics fill character 
  VirtBuff->Fill(0, 0, VirtBuff->Wd, VirtBuff->Ht, 176, 0x04);
  // Then draw some lines
  VirtBuff->HzWrt(0, 0, Line1, 0x70);
  VirtBuff->HzWrt(0, 1, Line2, 0x70);
  VirtBuff->HzWrt(0, 2, Line3, 0x70);
  VirtBuff->HzWrt(70, 99, Last, 0x70);
  // And some boxes
  VirtBuff->Box(5, 5, 50, 5, 0x11, 0x70);  
  VirtBuff->Box(70, 50, 25, 3, 0x11, 0x73);
  VirtBuff->Box(10, 30, 20, 5, 0x11, 0x74);
  // Now open up the virtual window 
  Swso::Open(B, X, Y);
}

void Vwso::OnKeyStroke(MsgPkt &M)
// Keypresses are passed to the Vwso object. Handle them here. Depending
// on which arrow key is pressed, update the offsets, Vx and Vy, into
// the virtual buffer which determines what will be displayed in the
// scrollable window. Call Draw to update the window and finally
// SendScrollPosn to send a message to scroll bars indicating the
// new location in the virutal buffer. 
{
  switch(M.Code) {
    case UpKey: 
      if (Vy > 0) Vy--;
      Draw();
      SendScrollPosn();   // Update bar position 
    break;
    case DownKey: 
      if (Vy < (VirtBuff->Ht - Panel->Interior->Ht)) Vy++;
      Draw();
      SendScrollPosn();
    break;
    case LeftKey:
      if (Vx > 0) Vx--;
      Draw();
      SendScrollPosn();
    break;
    case RightKey: 
      if (Vx < (VirtBuff->Wd - Panel->Interior->Wd)) Vx++;
      Draw();
      SendScrollPosn();
    break;
    default:
      Swso::OnKeyStroke(M);  // Let parent class handle it
  }
}

void Vwso::SendScrollPosn(void)
// Send messages to both scroll bars indicating current offset into
// virtual buffer 
{
  float P; 
  int W;

  W = VirtBuff->Wd-Panel->Interior->Wd;
  if (W == 0) P = 0.0; else P = float(Vx) / float(W);
  HzSlide->RcvScrollPosn(P, HzOrient);

  W = VirtBuff->Ht-Panel->Interior->Ht;
  if (W == 0) P = 0.0; else P = float(Vy) / float(W);
  VtSlide->RcvScrollPosn(P, VtOrient);
}

void Vwso::RcvScrollPosn(float P, BarOrient Which)
// Update the current offset into the virtual buffer, based on the
// value P. Redraw the display window with this new setting. 
{
  int W;
  if (Which == HzOrient) {
     W = VirtBuff->Wd - Panel->Interior->Wd;
     Vx = ceil(P*W);
  }
  else {
     W = VirtBuff->Ht - Panel->Interior->Ht;
     Vy = ceil(P*W);
  }
  Draw();
}

Wso *W;

main()
{
  // CORRECTION: pg 283, book passed DefColors by pointer, 
  // instead of by reference as it should have
  Setup(MouseOptional, DefColors);
  FullScrn->Panel->Clear(176, 0x07);
  // CORRECTION: pg 283, book pased CyanColors by pointer,
  // instead of by reference as it should have
  W = new Vwso(WindowStyle+Stretchable, CyanColors);
  W->SetSize(30, 10);
  W->Open(FullScrn, 5, 5);
  MainEventLoop();
  CleanUp();
}

