// wsotxscr.cpp: Text-based windows startup code

#include "wsotxscr.h"

Wso *FullScrn;
MsgPkt StartMsg;

void Setup(MouseOpt Mo, ColorPak &Cp)
// Sets up the text screen environment by initializing the mouse
// and creating a the FullScrn object to reference the text
// screen.  The FullScrn object can serve as the base for other
// window objects. 
{
  FullScrn = new Wso(0x00, 0x00, Cp); // Initialize without a border 
  StartMsg = NullMsg;
  if (Mo != NoMouse) {
     Mouse.Setup(TextScrn);
     if ((!Mouse.SetupOK()) && (Mo == MouseRequired)) {
        FullScrn->Panel->Clear(' ', 0);
        FullScrn->Panel->HzWrtB(0, 0, "Unable to initialize mouse."); 
        exit(1);
     }
  }
}

void MainEventLoop(void)
// Starts up the main event loop by calling the FullScrn object's
//  EventLoop method. But first, set the focus to the top Iso. 
{
  if (FullScrn->SubMgr->Top != NULL)
     FullScrn->SubMgr->Top->SwitchFocus(StartMsg);
  FullScrn->SubMgr->EventLoop(StartMsg);
}

void CleanUp(void)
// Shuts down the text screen environment by de-allocating the
// FullScrn and turning off the mouse 
{
  delete FullScrn;
  Mouse.TurnOff(); // Do this AFTER deleting FullScrn!
}

